/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.SystemNanoClock;

public class TimerWheel {
    public static final int INITIAL_TICK_DEPTH = 16;
    private final long mask;
    private final long startTime;
    private final long tickDurationInNs;
    private final NanoClock clock;
    private final Timer[][] wheel;
    private long currentTick;

    public TimerWheel(long tickDuration, TimeUnit timeUnit, int ticksPerWheel) {
        this(new SystemNanoClock(), tickDuration, timeUnit, ticksPerWheel);
    }

    public TimerWheel(NanoClock clock, long tickDuration, TimeUnit timeUnit, int ticksPerWheel) {
        TimerWheel.checkTicksPerWheel(ticksPerWheel);
        this.mask = ticksPerWheel - 1;
        this.clock = clock;
        this.startTime = clock.nanoTime();
        this.tickDurationInNs = timeUnit.toNanos(tickDuration);
        if (this.tickDurationInNs >= Long.MAX_VALUE / (long)ticksPerWheel) {
            throw new IllegalArgumentException(String.format("tickDuration: %d (expected: 0 < tickDurationInNs < %d", tickDuration, Long.MAX_VALUE / (long)ticksPerWheel));
        }
        this.wheel = new Timer[ticksPerWheel][];
        for (int i = 0; i < ticksPerWheel; ++i) {
            this.wheel[i] = new Timer[16];
        }
    }

    public NanoClock clock() {
        return this.clock;
    }

    private long ticks() {
        return this.clock.nanoTime() - this.startTime;
    }

    public Timer newBlankTimer() {
        return new Timer();
    }

    public Timer newTimeout(long delay, TimeUnit unit, Runnable task) {
        long deadline = this.ticks() + unit.toNanos(delay);
        Timer timeout = new Timer(deadline, task);
        this.wheel[((Timer)timeout).wheelIndex] = TimerWheel.addTimeoutToArray(this.wheel[timeout.wheelIndex], timeout);
        return timeout;
    }

    public void rescheduleTimeout(long delay, TimeUnit unit, Timer timer) {
        this.rescheduleTimeout(delay, unit, timer, timer.task);
    }

    public void rescheduleTimeout(long delay, TimeUnit unit, Timer timer, Runnable task) {
        if (timer.isActive()) {
            throw new IllegalArgumentException("timer is active");
        }
        long deadline = this.ticks() + unit.toNanos(delay);
        timer.reset(deadline, task);
        this.wheel[((Timer)timer).wheelIndex] = TimerWheel.addTimeoutToArray(this.wheel[timer.wheelIndex], timer);
    }

    public long computeDelayInMs() {
        long deadline = this.tickDurationInNs * (this.currentTick + 1L);
        return (deadline - this.ticks() + 999999L) / 1000000L;
    }

    public int expireTimers() {
        int timersExpired = 0;
        long now = this.ticks();
        for (Timer timer : this.wheel[(int)(this.currentTick & this.mask)]) {
            if (null == timer) continue;
            if (0L >= timer.remainingRounds) {
                timer.remove();
                timer.state = TimerState.EXPIRED;
                if (now < timer.deadline) continue;
                ++timersExpired;
                timer.task.run();
                continue;
            }
            timer.remainingRounds--;
        }
        ++this.currentTick;
        return timersExpired;
    }

    private static void checkTicksPerWheel(int ticksPerWheel) {
        if (ticksPerWheel < 2 || 1 != Integer.bitCount(ticksPerWheel)) {
            String msg = "ticksPerWheel must be a positive power of 2: ticksPerWheel=" + ticksPerWheel;
            throw new IllegalArgumentException(msg);
        }
    }

    private static Timer[] addTimeoutToArray(Timer[] oldArray, Timer timeout) {
        for (int i = 0; i < oldArray.length; ++i) {
            if (null != oldArray[i]) continue;
            oldArray[i] = timeout;
            timeout.tickIndex = i;
            return oldArray;
        }
        Timer[] newArray = Arrays.copyOf(oldArray, oldArray.length + 1);
        newArray[oldArray.length] = timeout;
        timeout.tickIndex = oldArray.length;
        return newArray;
    }

    public final class Timer {
        private int wheelIndex;
        private long deadline;
        private Runnable task;
        private int tickIndex;
        private long remainingRounds;
        private TimerState state;

        public Timer() {
            this.state = TimerState.CANCELLED;
        }

        public Timer(long deadline, Runnable task) {
            this.reset(deadline, task);
        }

        public void reset(long deadline, Runnable task) {
            this.deadline = deadline;
            this.task = task;
            long calculatedIndex = deadline / TimerWheel.this.tickDurationInNs;
            long ticks = Math.max(calculatedIndex, TimerWheel.this.currentTick);
            this.wheelIndex = (int)(ticks & TimerWheel.this.mask);
            this.remainingRounds = (calculatedIndex - TimerWheel.this.currentTick) / (long)TimerWheel.this.wheel.length;
            this.state = TimerState.ACTIVE;
        }

        public boolean cancel() {
            if (this.isActive()) {
                this.remove();
                this.state = TimerState.CANCELLED;
            }
            return true;
        }

        public boolean isActive() {
            return TimerState.ACTIVE == this.state;
        }

        public boolean isCancelled() {
            return TimerState.CANCELLED == this.state;
        }

        public boolean isExpired() {
            return TimerState.EXPIRED == this.state;
        }

        public void remove() {
            ((TimerWheel)TimerWheel.this).wheel[this.wheelIndex][this.tickIndex] = null;
        }

        public String toString() {
            return "Timer{wheelIndex='" + this.wheelIndex + "', tickIndex='" + this.tickIndex + "', deadline='" + this.deadline + "', remainingRounds='" + this.remainingRounds + "'}";
        }
    }

    public static enum TimerState {
        ACTIVE,
        CANCELLED,
        EXPIRED;

    }
}

