/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.compat.log.LoggerFactory;
import net.spy.memcached.internal.AbstractListenableFuture;
import net.spy.memcached.internal.BulkFuture;
import net.spy.memcached.internal.BulkGetCompletionListener;
import net.spy.memcached.internal.CheckedOperationTimeoutException;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;

public class BulkGetFuture<T>
extends AbstractListenableFuture<Map<String, T>, BulkGetCompletionListener>
implements BulkFuture<Map<String, T>> {
    private final Map<String, Future<T>> rvMap;
    private final Collection<Operation> ops;
    private final CountDownLatch latch;
    private OperationStatus status;
    private boolean cancelled = false;
    private boolean timeout = false;

    public BulkGetFuture(Map<String, Future<T>> m, Collection<Operation> getOps, CountDownLatch l, ExecutorService service) {
        super(service);
        this.rvMap = m;
        this.ops = getOps;
        this.latch = l;
        this.status = null;
    }

    @Override
    public boolean cancel(boolean ign) {
        boolean rv = false;
        for (Operation operation : this.ops) {
            rv |= operation.getState() == OperationState.WRITE_QUEUED;
            operation.cancel();
        }
        for (Future future : this.rvMap.values()) {
            future.cancel(ign);
        }
        this.cancelled = true;
        this.status = new OperationStatus(false, "Cancelled");
        this.notifyListeners();
        return rv;
    }

    @Override
    public Map<String, T> get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timed out waiting forever", e);
        }
    }

    @Override
    public Map<String, T> getSome(long to, TimeUnit unit) throws InterruptedException, ExecutionException {
        HashSet<Operation> timedoutOps = new HashSet<Operation>();
        Map<String, T> ret = this.internalGet(to, unit, timedoutOps);
        if (timedoutOps.size() > 0) {
            this.timeout = true;
            LoggerFactory.getLogger(this.getClass()).warn(new CheckedOperationTimeoutException("Operation timed out: ", timedoutOps).getMessage());
        }
        return ret;
    }

    @Override
    public Map<String, T> get(long to, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        HashSet<Operation> timedoutOps = new HashSet<Operation>();
        Map<String, T> ret = this.internalGet(to, unit, timedoutOps);
        if (timedoutOps.size() > 0) {
            this.timeout = true;
            throw new CheckedOperationTimeoutException("Operation timed out.", timedoutOps);
        }
        return ret;
    }

    private Map<String, T> internalGet(long to, TimeUnit unit, Collection<Operation> timedoutOps) throws InterruptedException, ExecutionException {
        if (!this.latch.await(to, unit)) {
            for (Operation op : this.ops) {
                if (op.getState() != OperationState.COMPLETE) {
                    MemcachedConnection.opTimedOut(op);
                    timedoutOps.add(op);
                    continue;
                }
                MemcachedConnection.opSucceeded(op);
            }
        }
        for (Operation op : this.ops) {
            if (op.isCancelled()) {
                throw new ExecutionException(new CancellationException("Cancelled"));
            }
            if (!op.hasErrored()) continue;
            throw new ExecutionException(op.getException());
        }
        HashMap<String, T> m = new HashMap<String, T>();
        for (Map.Entry<String, Future<T>> me : this.rvMap.entrySet()) {
            m.put(me.getKey(), me.getValue().get());
        }
        return m;
    }

    @Override
    public OperationStatus getStatus() {
        if (this.status == null) {
            try {
                this.get();
            }
            catch (InterruptedException e) {
                this.status = new OperationStatus(false, "Interrupted");
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                return this.status;
            }
        }
        return this.status;
    }

    public void setStatus(OperationStatus s) {
        this.status = s;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public boolean isTimeout() {
        return this.timeout;
    }

    @Override
    public Future<Map<String, T>> addListener(BulkGetCompletionListener listener) {
        super.addToListeners(listener);
        return this;
    }

    @Override
    public Future<Map<String, T>> removeListener(BulkGetCompletionListener listener) {
        super.removeFromListeners(listener);
        return this;
    }

    public void signalComplete() {
        this.notifyListeners();
    }
}

