/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.tess4j.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import net.sourceforge.tess4j.util.ImageIOHelper;
import net.sourceforge.tess4j.util.LoggHelper;
import org.ghost4j.Ghostscript;
import org.ghost4j.GhostscriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfGsUtilities {
    public static final String GS_INSTALL = "\nPlease download, install GPL Ghostscript from http://www.ghostscript.com\nand/or set the appropriate path variable.";
    private static final Logger logger = LoggerFactory.getLogger((String)new LoggHelper().toString());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File convertPdf2Tiff(File file) throws IOException {
        File[] fileArray = null;
        try {
            fileArray = PdfGsUtilities.convertPdf2Png(file);
            File file2 = File.createTempFile("multipage", ".tif");
            ImageIOHelper.mergeTiff(fileArray, file2);
            File file3 = file2;
            return file3;
        }
        finally {
            if (fileArray != null && fileArray.length > 0) {
                File file4 = new File(fileArray[0].getParent());
                for (File file5 : fileArray) {
                    file5.delete();
                }
                file4.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized File[] convertPdf2Png(File file) throws IOException {
        File[] fileArray;
        Path path = Files.createTempDirectory("tessimages", new FileAttribute[0]);
        File file2 = path.toFile();
        File[] fileArray2 = Ghostscript.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-gs");
        arrayList.add("-dNOPAUSE");
        arrayList.add("-dQUIET");
        arrayList.add("-dBATCH");
        arrayList.add("-dSAFER");
        arrayList.add("-sDEVICE=pnggray");
        arrayList.add("-r300");
        arrayList.add("-dGraphicsAlphaBits=4");
        arrayList.add("-dTextAlphaBits=4");
        arrayList.add("-sOutputFile=" + file2.getPath() + "/workingimage%04d.png");
        arrayList.add(file.getPath());
        try {
            fileArray = fileArray2;
            synchronized (fileArray2) {
                fileArray2.initialize(arrayList.toArray(new String[0]));
                fileArray2.exit();
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.error(unsatisfiedLinkError.getMessage());
            throw new RuntimeException(PdfGsUtilities.getMessage(unsatisfiedLinkError.getMessage()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.error(noClassDefFoundError.getMessage());
            throw new RuntimeException(PdfGsUtilities.getMessage(noClassDefFoundError.getMessage()));
        }
        catch (GhostscriptException ghostscriptException) {
            logger.error(ghostscriptException.getMessage());
            throw new RuntimeException(ghostscriptException.getMessage());
        }
        finally {
            if (file2.list().length == 0) {
                file2.delete();
            }
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException ghostscriptException) {}
        }
        {
            fileArray = file2.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.toLowerCase().matches("workingimage\\d{4}\\.png$");
                }
            });
            Arrays.sort(fileArray, new Comparator<File>(){

                @Override
                public int compare(File file, File file2) {
                    return file.getName().compareTo(file2.getName());
                }
            });
            return fileArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splitPdf(File file, File file2, int n, int n2) {
        Ghostscript ghostscript = Ghostscript.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-gs");
        arrayList.add("-dNOPAUSE");
        arrayList.add("-dQUIET");
        arrayList.add("-dBATCH");
        arrayList.add("-sDEVICE=pdfwrite");
        if (n > 0) {
            arrayList.add("-dFirstPage=" + n);
        }
        if (n2 > 0) {
            arrayList.add("-dLastPage=" + n2);
        }
        arrayList.add("-sOutputFile=" + file2.getPath());
        arrayList.add(file.getPath());
        try {
            Ghostscript ghostscript2 = ghostscript;
            synchronized (ghostscript2) {
                ghostscript.initialize(arrayList.toArray(new String[0]));
                ghostscript.exit();
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.error(unsatisfiedLinkError.getMessage());
            throw new RuntimeException(PdfGsUtilities.getMessage(unsatisfiedLinkError.getMessage()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.error(noClassDefFoundError.getMessage());
            throw new RuntimeException(PdfGsUtilities.getMessage(noClassDefFoundError.getMessage()));
        }
        catch (GhostscriptException ghostscriptException) {
            logger.error(ghostscriptException.getMessage());
            throw new RuntimeException(ghostscriptException.getMessage());
        }
        finally {
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException ghostscriptException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPdfPageCount(File file) {
        Ghostscript ghostscript = Ghostscript.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-gs");
        arrayList.add("-dNOPAUSE");
        arrayList.add("-dQUIET");
        arrayList.add("-dNODISPLAY");
        arrayList.add("-dBATCH");
        arrayList.add("-c");
        String string = String.format("(%s) (r) file runpdfbegin pdfpagecount = quit", file.getPath().replace('\\', '/'));
        arrayList.add(string);
        int n = 0;
        try {
            Ghostscript ghostscript2 = ghostscript;
            synchronized (ghostscript2) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ghostscript.setStdOut((OutputStream)byteArrayOutputStream);
                ghostscript.initialize(arrayList.toArray(new String[0]));
                n = Integer.parseInt(byteArrayOutputStream.toString().trim());
                byteArrayOutputStream.close();
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.error(unsatisfiedLinkError.getMessage());
            throw new RuntimeException(PdfGsUtilities.getMessage(unsatisfiedLinkError.getMessage()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.error(noClassDefFoundError.getMessage());
            throw new RuntimeException(PdfGsUtilities.getMessage(noClassDefFoundError.getMessage()));
        }
        catch (GhostscriptException ghostscriptException) {
            logger.error(ghostscriptException.getMessage());
            throw new RuntimeException(ghostscriptException.getMessage());
        }
        catch (Exception exception) {
            logger.error(exception.getMessage());
        }
        finally {
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException ghostscriptException) {}
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mergePdf(File[] ghostscript, File file) {
        Ghostscript ghostscript2 = Ghostscript.getInstance();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-gs");
        arrayList.add("-dNOPAUSE");
        arrayList.add("-dQUIET");
        arrayList.add("-dBATCH");
        arrayList.add("-sDEVICE=pdfwrite");
        arrayList.add("-sOutputFile=" + file.getPath());
        for (File file2 : ghostscript) {
            arrayList.add(file2.getPath());
        }
        try {
            Ghostscript ghostscript3 = ghostscript2;
            synchronized (ghostscript3) {
                ghostscript2.initialize(arrayList.toArray(new String[0]));
                ghostscript2.exit();
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            logger.error(unsatisfiedLinkError.getMessage());
            throw new RuntimeException(PdfGsUtilities.getMessage(unsatisfiedLinkError.getMessage()));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            logger.error(noClassDefFoundError.getMessage());
            throw new RuntimeException(PdfGsUtilities.getMessage(noClassDefFoundError.getMessage()));
        }
        catch (GhostscriptException ghostscriptException) {
            logger.error(ghostscriptException.getMessage());
            throw new RuntimeException(ghostscriptException.getMessage());
        }
        finally {
            try {
                Ghostscript.deleteInstance();
            }
            catch (GhostscriptException ghostscriptException) {}
        }
    }

    static String getMessage(String string) {
        if (string.contains("library 'gs") || string.contains("ghost4j")) {
            return string + GS_INSTALL;
        }
        return string;
    }
}

