/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.reb4j.charclass;

import fj.F2;
import fj.data.LazyString;
import fj.data.List;
import net.sourceforge.reb4j.charclass.CharClass;
import net.sourceforge.reb4j.charclass.Negated;

public final class Union
extends CharClass {
    private static final long serialVersionUID = 1L;
    public final List<CharClass> subsets;

    Union(List<CharClass> subsets) {
        if (subsets == null) {
            throw new NullPointerException("subsets");
        }
        this.subsets = subsets;
    }

    @Override
    public Negated<Union> negated() {
        return new Negated<Union>(this);
    }

    @Override
    public LazyString unitableForm() {
        return (LazyString)this.subsets.foldLeft((F2)new F2<LazyString, CharClass, LazyString>(){

            public LazyString f(LazyString a, CharClass b) {
                return a.append(b.unitableForm());
            }
        }, (Object)LazyString.empty);
    }

    @Override
    public LazyString independentForm() {
        return LazyString.str((String)"[").append(this.unitableForm()).append("]");
    }

    @Override
    public Union union(Union right) {
        return new Union((List<CharClass>)this.subsets.append(right.subsets));
    }

    @Override
    public Union union(CharClass right) {
        return new Union((List<CharClass>)this.subsets.append(List.single((Object)right)));
    }

    static Union union(CharClass left, Union right) {
        return new Union((List<CharClass>)right.subsets.cons((Object)left));
    }

    static Union union(CharClass left, CharClass right) {
        return new Union((List<CharClass>)List.list((Object[])new CharClass[]{left, right}));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.subsets.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Union other = (Union)obj;
        return this.subsets.equals(other.subsets);
    }
}

