/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.reb4j.charclass;

import fj.F2;
import fj.data.LazyString;
import fj.data.Set;
import net.sourceforge.reb4j.Literal;
import net.sourceforge.reb4j.charclass.CharClass;
import net.sourceforge.reb4j.charclass.Negated;
import net.sourceforge.reb4j.charclass.SingleChar;

public final class MultiChar
extends CharClass {
    private static final long serialVersionUID = 1L;
    public final Set<Character> characters;

    MultiChar(Set<Character> characters) {
        if (characters == null) {
            throw new NullPointerException("characters");
        }
        this.characters = characters;
    }

    @Override
    public Negated<MultiChar> negated() {
        return new Negated<MultiChar>(this);
    }

    @Override
    public LazyString unitableForm() {
        return (LazyString)this.characters.toStream().foldLeft((F2)new F2<LazyString, Character, LazyString>(){

            public LazyString f(LazyString a, Character b) {
                return a.append(Literal.escapeChar(b));
            }
        }, (Object)LazyString.empty);
    }

    @Override
    public LazyString independentForm() {
        return LazyString.str((String)"[").append(this.unitableForm()).append("]");
    }

    public MultiChar union(MultiChar right) {
        if (right == null) {
            throw new NullPointerException("right == null");
        }
        return new MultiChar((Set<Character>)this.characters.union(right.characters));
    }

    public MultiChar union(SingleChar right) {
        if (right == null) {
            throw new NullPointerException("right == null");
        }
        return new MultiChar((Set<Character>)this.characters.insert((Object)Character.valueOf(right.character)));
    }
}

