/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.reb4j.charclass;

import fj.data.LazyString;
import net.sourceforge.reb4j.charclass.CharClass;
import net.sourceforge.reb4j.charclass.Negated;

public final class CharRange
extends CharClass {
    private static final long serialVersionUID = 1L;
    public final char first;
    public final char last;

    CharRange(char first, char last) {
        if (first >= last) {
            throw new IllegalArgumentException("first must be < last");
        }
        this.first = first;
        this.last = last;
    }

    @Override
    public Negated<CharRange> negated() {
        return new Negated<CharRange>(this);
    }

    @Override
    public LazyString unitableForm() {
        return LazyString.str((String)Character.toString(this.first)).append("-").append(Character.toString(this.last));
    }

    @Override
    public LazyString independentForm() {
        return LazyString.str((String)"[").append(this.unitableForm()).append("]");
    }
}

