/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.reb4j.charclass;

import fj.Ord;
import fj.data.LazyString;
import fj.data.Set;
import net.sourceforge.reb4j.AbstractQuantifiableSequenceableAlternative;
import net.sourceforge.reb4j.Alternative;
import net.sourceforge.reb4j.Expression;
import net.sourceforge.reb4j.Quantifiable;
import net.sourceforge.reb4j.Sequenceable;
import net.sourceforge.reb4j.charclass.CharRange;
import net.sourceforge.reb4j.charclass.Intersection;
import net.sourceforge.reb4j.charclass.MultiChar;
import net.sourceforge.reb4j.charclass.NamedPredefinedClass;
import net.sourceforge.reb4j.charclass.PredefinedClass;
import net.sourceforge.reb4j.charclass.SingleChar;
import net.sourceforge.reb4j.charclass.Union;

public abstract class CharClass
extends AbstractQuantifiableSequenceableAlternative
implements Expression,
Quantifiable,
Sequenceable,
Alternative {
    private static final long serialVersionUID = 1L;

    protected abstract LazyString unitableForm();

    protected abstract LazyString independentForm();

    @Override
    public final LazyString expression() {
        return this.independentForm();
    }

    public abstract CharClass negated();

    public Union union(Union right) {
        return Union.union(this, right);
    }

    public Union union(CharClass right) {
        return Union.union(this, right);
    }

    public Intersection intersect(CharClass right) {
        return Intersection.intersect(this, right);
    }

    public Intersection intersect(Intersection right) {
        return Intersection.intersect(this, right);
    }

    public static SingleChar character(char c) {
        return new SingleChar(c);
    }

    public static MultiChar characters(char c1, char c2, char ... cs) {
        Set set = Set.set((Ord)Ord.charOrd, (Object[])new Character[]{Character.valueOf(c1), Character.valueOf(c2)});
        for (char c : cs) {
            set = set.insert((Object)Character.valueOf(c));
        }
        return new MultiChar((Set<Character>)set);
    }

    public static CharRange range(char first, char last) {
        return new CharRange(first, last);
    }

    public static abstract class Unicode {
        private Unicode() {
        }

        private static NamedPredefinedClass z(String className) {
            return new NamedPredefinedClass(className);
        }

        public static NamedPredefinedClass block(Character.UnicodeBlock unicodeBlock) {
            return Unicode.z("In" + unicodeBlock.toString());
        }

        static /* synthetic */ NamedPredefinedClass access$000(String x0) {
            return Unicode.z(x0);
        }

        public static abstract class Symbol {
            public static final NamedPredefinedClass MATH = Unicode.access$000("Sm");
            public static final NamedPredefinedClass CURRENCY = Unicode.access$000("Sc");
            public static final NamedPredefinedClass MODIFIER = Unicode.access$000("Sk");
            public static final NamedPredefinedClass OTHER = Unicode.access$000("So");
        }

        public static abstract class Punctuation {
            public static final NamedPredefinedClass CONNECTOR = Unicode.access$000("Pc");
            public static final NamedPredefinedClass DASH = Unicode.access$000("Pd");
            public static final NamedPredefinedClass OPEN = Unicode.access$000("Po");
            public static final NamedPredefinedClass CLOSE = Unicode.access$000("Pe");
            public static final NamedPredefinedClass INITIAL_QUOTE = Unicode.access$000("Pi");
            public static final NamedPredefinedClass FINAL_QUOTE = Unicode.access$000("Pf");
            public static final NamedPredefinedClass OTHER = Unicode.access$000("Po");
        }

        public static abstract class Other {
            public static final NamedPredefinedClass CONTROL = Unicode.access$000("Cc");
            public static final NamedPredefinedClass FORMAT = Unicode.access$000("Cf");
            public static final NamedPredefinedClass SURROGATE = Unicode.access$000("Cs");
            public static final NamedPredefinedClass PRIVATE_USE = Unicode.access$000("Co");
            public static final NamedPredefinedClass NOT_ASSIGNED = Unicode.access$000("Cn");

            private Other() {
            }
        }

        public static abstract class Separator {
            public static final NamedPredefinedClass SPACE = Unicode.access$000("Zs");
            public static final NamedPredefinedClass LINE = Unicode.access$000("Zl");
            public static final NamedPredefinedClass PARAGRAPH = Unicode.access$000("Zp");

            private Separator() {
            }
        }

        public static abstract class Number {
            public static final NamedPredefinedClass DECIMAL_DIGIT = Unicode.access$000("Nd");
            public static final NamedPredefinedClass LETTER = Unicode.access$000("Nl");
            public static final NamedPredefinedClass OTHER = Unicode.access$000("No");

            private Number() {
            }
        }

        public static abstract class Mark {
            public static final NamedPredefinedClass NONSPACING = Unicode.access$000("Mn");
            public static final NamedPredefinedClass SPACING_COMBINING = Unicode.access$000("Mc");
            public static final NamedPredefinedClass ENCLOSING = Unicode.access$000("Me");

            private Mark() {
            }
        }

        public static abstract class Letter {
            public static final NamedPredefinedClass UPPER_CASE = Unicode.access$000("Lu");
            public static final NamedPredefinedClass LOWER_CASE = Unicode.access$000("Ll");
            public static final NamedPredefinedClass TITLE_CASE = Unicode.access$000("Lt");
            public static final NamedPredefinedClass MODIFIER = Unicode.access$000("Lm");
            public static final NamedPredefinedClass OTHER = Unicode.access$000("Lo");

            private Letter() {
            }
        }
    }

    public static abstract class Java {
        public static final NamedPredefinedClass LOWER_CASE = new NamedPredefinedClass("javaLowerCase");
        public static final NamedPredefinedClass UPPER_CASE = new NamedPredefinedClass("javaUpperCase");
        public static final NamedPredefinedClass WHITESPACE = new NamedPredefinedClass("javaWhitespace");
        public static final NamedPredefinedClass MIRROR = new NamedPredefinedClass("javaMirrored");

        private Java() {
        }
    }

    public static abstract class Posix {
        public static final NamedPredefinedClass LOWER = new NamedPredefinedClass("Lower");
        public static final NamedPredefinedClass UPPER = new NamedPredefinedClass("Upper");
        public static final NamedPredefinedClass ALPHA = new NamedPredefinedClass("Alpha");
        public static final NamedPredefinedClass DIGIT = new NamedPredefinedClass("Digit");
        public static final NamedPredefinedClass ALNUM = new NamedPredefinedClass("Alnum");
        public static final NamedPredefinedClass PUNCT = new NamedPredefinedClass("Punct");
        public static final NamedPredefinedClass GRAPH = new NamedPredefinedClass("Graph");
        public static final NamedPredefinedClass PRINT = new NamedPredefinedClass("Print");
        public static final NamedPredefinedClass BLANK = new NamedPredefinedClass("Blank");
        public static final NamedPredefinedClass CONTROL = new NamedPredefinedClass("Cntrl");
        public static final NamedPredefinedClass HEX_DIGIT = new NamedPredefinedClass("XDigit");
        public static final NamedPredefinedClass SPACE = new NamedPredefinedClass("Space");

        private Posix() {
        }
    }

    public static abstract class Perl {
        public static final PredefinedClass DIGIT = new PredefinedClass('d');
        public static final PredefinedClass SPACE = new PredefinedClass('s');
        public static final PredefinedClass WORD = new PredefinedClass('w');

        private Perl() {
        }
    }
}

