/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.reb4j;

import fj.F2;
import fj.data.LazyString;
import fj.data.List;
import net.sourceforge.reb4j.AbstractSequenceableAlternative;
import net.sourceforge.reb4j.Literal;

public class Raw
extends AbstractSequenceableAlternative {
    private static final long serialVersionUID = 1L;
    private final LazyString rawExpression;

    Raw(LazyString rawExpression) {
        assert (rawExpression != null);
        this.rawExpression = rawExpression;
    }

    @Override
    public final LazyString expression() {
        return this.rawExpression;
    }

    @Deprecated
    public Compound then(Raw right) {
        return this.andThen(right);
    }

    @Deprecated
    public Compound then(Compound right) {
        return this.andThen(right);
    }

    @Deprecated
    public Compound then(Literal right) {
        return this.andThen(right);
    }

    public Compound andThen(Raw right) {
        if (right == null) {
            throw new NullPointerException("right");
        }
        return new Compound(List.list((Object[])new Raw[]{this, right}));
    }

    public Compound andThen(Compound right) {
        if (right == null) {
            throw new NullPointerException("right");
        }
        return new Compound(right.components.cons((Object)this));
    }

    public Compound andThen(Literal right) {
        if (right == null) {
            throw new NullPointerException("right");
        }
        return this.then(new EscapedLiteral(right));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.rawExpression.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Raw other = (Raw)obj;
        return this.rawExpression.equals(other.rawExpression);
    }

    public static final class EscapedLiteral
    extends Raw {
        private static final long serialVersionUID = 1L;
        public final Literal literal;

        private EscapedLiteral(Literal literal) {
            super(literal.escaped());
            this.literal = literal;
        }
    }

    public static final class Compound
    extends Raw {
        private static final long serialVersionUID = 1L;
        public final List<Raw> components;

        private Compound(List<Raw> components) {
            super(Compound.compoundExpression(components));
            this.components = components;
        }

        private static LazyString compoundExpression(List<Raw> components) {
            return (LazyString)components.foldLeft((F2)new F2<LazyString, Raw, LazyString>(){

                public LazyString f(LazyString a, Raw b) {
                    return a.append(b.rawExpression);
                }
            }, (Object)LazyString.empty);
        }

        @Override
        @Deprecated
        public Compound then(Raw right) {
            return this.andThen(right);
        }

        @Override
        @Deprecated
        public Compound then(Compound right) {
            return this.andThen(right);
        }

        @Override
        public Compound andThen(Raw right) {
            return new Compound((List<Raw>)this.components.append(List.single((Object)right)));
        }

        @Override
        public Compound andThen(Compound right) {
            return new Compound((List<Raw>)this.components.append(right.components));
        }
    }
}

