/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.interchange.xmlrpc;

import java.io.ByteArrayInputStream;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sf.sojo.interchange.xmlrpc.XmlRpcContentHandler;
import net.sf.sojo.interchange.xmlrpc.XmlRpcException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XmlRpcParser {
    private boolean returnValueAsList = true;
    private boolean convertResult2XmlRpcExceptionAndThrow = false;
    private String methodName = null;

    public String getMethodName() {
        return this.methodName;
    }

    public void setReturnValueAsList(boolean pvReturnValueAsList) {
        this.returnValueAsList = pvReturnValueAsList;
    }

    public boolean getReturnValueAsList() {
        return this.returnValueAsList;
    }

    public void setConvertResult2XmlRpcExceptionAndThrow(boolean pvConvertResult2XmlRpcException) {
        this.convertResult2XmlRpcExceptionAndThrow = pvConvertResult2XmlRpcException;
    }

    public boolean getConvertResult2XmlRpcExceptionAndThrow() {
        return this.convertResult2XmlRpcExceptionAndThrow;
    }

    public Object parse(String pvXmlRpcString) throws XmlRpcException {
        Object lvReturn = null;
        boolean lvIsFault = false;
        try {
            if (pvXmlRpcString != null) {
                SAXParserFactory lvFactory = SAXParserFactory.newInstance();
                SAXParser lvParser = lvFactory.newSAXParser();
                XMLReader lvReader = lvParser.getXMLReader();
                XmlRpcContentHandler lvContentHandler = new XmlRpcContentHandler();
                lvContentHandler.setReturnValueAsList(this.getReturnValueAsList());
                lvReader.setContentHandler(lvContentHandler);
                ByteArrayInputStream lvArrayInputStream = new ByteArrayInputStream(pvXmlRpcString.getBytes());
                lvReader.parse(new InputSource(lvArrayInputStream));
                lvReturn = lvContentHandler.getResults();
                this.methodName = lvContentHandler.getMethodName();
                lvIsFault = lvContentHandler.isFault();
            }
        }
        catch (SAXParseException e) {
            throw new XmlRpcException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new XmlRpcException("Exception by parse XML-RPC-String: " + pvXmlRpcString, e);
        }
        if (lvIsFault && this.getConvertResult2XmlRpcExceptionAndThrow()) {
            Map lvMap = (Map)lvReturn;
            Object lvFaultCode = lvMap.get("faultCode");
            Object lvMessage = lvMap.get("faultString");
            throw new XmlRpcException(lvFaultCode + ": " + lvMessage);
        }
        return lvReturn;
    }
}

