/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.interchange.object;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import net.sf.sojo.core.NonCriticalExceptionHandler;
import net.sf.sojo.interchange.AbstractSerializer;
import net.sf.sojo.interchange.SerializerException;

public class ObjectSerializer
extends AbstractSerializer {
    private boolean convertBySerialization = true;

    public boolean getConvertBySerialization() {
        return this.convertBySerialization;
    }

    public void setConvertBySerialization(boolean pvConvertBySerialization) {
        this.convertBySerialization = pvConvertBySerialization;
    }

    @Override
    public Object serialize(Object pvRootObject, String[] pvExcludedProperties) {
        ObjectOutputStream lvObjectOutputStream = null;
        ByteArrayOutputStream lvArrayOutputStream = new ByteArrayOutputStream();
        try {
            Object lvSimple = pvRootObject;
            if (this.getConvertBySerialization()) {
                lvSimple = this.getObjectUtil().makeSimple(pvRootObject, pvExcludedProperties);
            }
            lvObjectOutputStream = new ObjectOutputStream(lvArrayOutputStream);
            lvObjectOutputStream.writeObject(lvSimple);
        }
        catch (Exception e) {
            throw new SerializerException("Exception by serialize object: " + pvRootObject + " - " + e, e);
        }
        finally {
            block11: {
                try {
                    lvObjectOutputStream.close();
                }
                catch (IOException e) {
                    if (!NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled()) break block11;
                    NonCriticalExceptionHandler.handleException(ObjectSerializer.class, "Exception by close ObjectOutputStream: " + lvObjectOutputStream);
                }
            }
        }
        return lvArrayOutputStream.toByteArray();
    }

    @Override
    public Object serialize(Object pvRootObject) {
        return this.serialize(pvRootObject, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object deserialize(Object pvSourceObject, Class<?> pvRootClass) {
        Object lvReturn = null;
        if (pvSourceObject instanceof byte[]) {
            ObjectInputStream lvObjectInputStream = null;
            try {
                byte[] lvBytes = (byte[])pvSourceObject;
                ByteArrayInputStream lvArrayInputStream = new ByteArrayInputStream(lvBytes);
                lvObjectInputStream = new ObjectInputStream(lvArrayInputStream);
                lvReturn = lvObjectInputStream.readObject();
                if (!this.getConvertBySerialization()) return lvReturn;
                lvReturn = this.getObjectUtil().makeComplex(lvReturn, pvRootClass);
                return lvReturn;
            }
            catch (Exception e) {
                throw new SerializerException("Exception by deserialize object: " + lvReturn + " - " + e, e);
            }
            finally {
                block11: {
                    try {
                        if (lvObjectInputStream != null) {
                            lvObjectInputStream.close();
                        }
                    }
                    catch (IOException e) {
                        if (!NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled()) break block11;
                        NonCriticalExceptionHandler.handleException(ObjectSerializer.class, e, "Exception by close ObjectInputStream: " + lvObjectInputStream);
                    }
                }
            }
        }
        String lvClassName = pvSourceObject == null ? null : pvSourceObject.getClass().getName();
        throw new SerializerException("The deserialize object must be an byte array and not: " + lvClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeToFile(Object pvRootObject, String pvPath) throws IOException {
        FileOutputStream lvFileOutputStream = null;
        try {
            lvFileOutputStream = new FileOutputStream(pvPath);
            this.serializeToOutputStream(pvRootObject, lvFileOutputStream);
        }
        finally {
            block9: {
                try {
                    if (lvFileOutputStream != null) {
                        lvFileOutputStream.close();
                    }
                }
                catch (Exception e) {
                    if (!NonCriticalExceptionHandler.isNonCriticalExceptionHandlerEnabled()) break block9;
                    NonCriticalExceptionHandler.handleException(ObjectSerializer.class, e, "Exception by close FileOutputStream: " + lvFileOutputStream + " and path: " + pvPath);
                }
            }
        }
    }

    public void serializeToOutputStream(Object pvRootObject, OutputStream pvOutputStream) throws IOException {
        byte[] lvBytes = (byte[])this.serialize(pvRootObject);
        pvOutputStream.write(lvBytes);
    }

    public Object deserializeFromFile(String pvPath) throws IOException, ClassNotFoundException {
        FileInputStream lvFileInputStream = new FileInputStream(pvPath);
        Object lvReturn = this.deserializeFromInputStream(lvFileInputStream);
        return lvReturn;
    }

    public Object deserializeFromInputStream(InputStream pvInputStream) throws IOException, ClassNotFoundException {
        Object lvReturn = null;
        int i = 1;
        byte[] b = new byte[1024];
        while (i > 0) {
            i = pvInputStream.read(b);
        }
        lvReturn = this.deserialize(b);
        return lvReturn;
    }
}

