/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.interchange.json;

import java.util.Date;
import net.sf.sojo.common.WalkerInterceptor;
import net.sf.sojo.interchange.SerializerException;
import net.sf.sojo.util.Util;

public class JsonWalkerInterceptor
implements WalkerInterceptor {
    private StringBuffer jsonString = new StringBuffer();
    private boolean withNullValuesInMap = false;

    public String getJsonString() {
        return this.jsonString.toString();
    }

    public boolean getWithNullValuesInMap() {
        return this.withNullValuesInMap;
    }

    public void setWithNullValuesInMap(boolean pvWithNullValuesInMap) {
        this.withNullValuesInMap = pvWithNullValuesInMap;
    }

    @Override
    public void startWalk(Object pvStartObject) {
        this.jsonString = new StringBuffer();
    }

    @Override
    public void endWalk() {
        Util.delLastComma(this.jsonString);
    }

    public static String handleControlCharacterBack(String pvValue) {
        if (pvValue == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int l = pvValue.length();
        block12: for (int i = 0; i < l; ++i) {
            char c = pvValue.charAt(i);
            switch (c) {
                case '\u0000': {
                    continue block12;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    sb.append(c);
                    continue block12;
                }
                case '\\': {
                    c = pvValue.charAt(++i);
                    switch (c) {
                        case 'b': {
                            sb.append('\b');
                            continue block12;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block12;
                        }
                        case 'n': {
                            sb.append('\n');
                            continue block12;
                        }
                        case 'f': {
                            sb.append('\f');
                            continue block12;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block12;
                        }
                    }
                    sb.append(c);
                    continue block12;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static Object handleControlCharacter(Object pvValue) {
        Object lvReturn = pvValue;
        if (lvReturn != null && lvReturn.getClass().equals(String.class)) {
            String lvString = lvReturn.toString();
            int len = lvString.length();
            if (len == 0) {
                return "";
            }
            char c = '\u0000';
            StringBuffer sb = new StringBuffer(len + 4);
            block10: for (int i = 0; i < len; ++i) {
                c = lvString.charAt(i);
                switch (c) {
                    case '\\': {
                        sb.append('\\').append(c);
                        continue block10;
                    }
                    case '\"': {
                        sb.append('\\').append(c);
                        continue block10;
                    }
                    case '/': {
                        sb.append('\\').append(c);
                        continue block10;
                    }
                    case '\b': {
                        sb.append("\\b");
                        continue block10;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block10;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block10;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block10;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block10;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }
        return lvReturn;
    }

    public static String object2StringWithDoubleQuote(Object pvObject) {
        StringBuffer s = new StringBuffer("");
        if (pvObject.getClass().equals(String.class) || pvObject.getClass().equals(Character.class) || Date.class.isAssignableFrom(pvObject.getClass())) {
            s.append("\"").append(pvObject).append("\"");
        } else {
            s.append(pvObject);
        }
        return s.toString();
    }

    public static String handleJsonValue(Object pvValue) {
        String s = "";
        if (pvValue != null) {
            Object o = JsonWalkerInterceptor.handleControlCharacter(pvValue);
            s = JsonWalkerInterceptor.object2StringWithDoubleQuote(o);
        }
        return s;
    }

    @Override
    public boolean visitElement(Object pvKey, int pvIndex, Object pvValue, int pvType, String pvPath, int pvNumberOfRecursion) {
        if (pvType == 1) {
            if (pvKey != null && pvKey.getClass().equals(String.class)) {
                this.jsonString.append(JsonWalkerInterceptor.handleJsonValue(pvKey)).append(":");
            } else if (pvKey != null) {
                throw new SerializerException("JSON support only properties/keys from type String and not: '" + pvKey.getClass().getName() + "' (" + pvKey + ")");
            }
            this.jsonString.append(JsonWalkerInterceptor.handleJsonValue(pvValue)).append(",");
        } else if (pvType == 0) {
            if (pvPath.endsWith(")")) {
                if (this.getWithNullValuesInMap()) {
                    this.jsonString.append(JsonWalkerInterceptor.handleJsonValue(pvKey)).append(":null,");
                }
            } else {
                this.jsonString.append("null,");
            }
        } else if (pvKey != null && pvValue != null) {
            if (pvKey != null && pvKey.getClass().equals(String.class)) {
                this.jsonString.append(JsonWalkerInterceptor.handleJsonValue(pvKey)).append(":");
            } else {
                throw new SerializerException("JSON support only properties/keys from type String and not: '" + pvKey.getClass().getName() + "' (" + pvKey + ")");
            }
        }
        return false;
    }

    @Override
    public void visitIterateableElement(Object pvValue, int pvType, String pvPath, int pvBeginEnd) {
        if (pvBeginEnd == 1) {
            if (pvType == 7) {
                this.jsonString.append("[");
            } else if (pvType == 9) {
                this.jsonString.append("{");
            }
        } else if (pvBeginEnd == 2) {
            Util.delLastComma(this.jsonString);
            if (pvType == 7) {
                this.jsonString.append("],");
            } else if (pvType == 9) {
                this.jsonString.append("},");
            }
        }
    }
}

