/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sojo.common;

import java.net.URL;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.sojo.common.CompareResult;
import net.sf.sojo.common.ObjectGraphWalker;
import net.sf.sojo.common.PathRecordWalkerInterceptor;
import net.sf.sojo.core.Conversion;
import net.sf.sojo.core.ConversionHandler;
import net.sf.sojo.core.ConversionIterator;
import net.sf.sojo.core.Converter;
import net.sf.sojo.core.ConverterInterceptorHandler;
import net.sf.sojo.core.conversion.ComplexBean2MapConversion;
import net.sf.sojo.core.conversion.Iterateable2IterateableConversion;
import net.sf.sojo.core.conversion.IterateableMap2BeanConversion;
import net.sf.sojo.core.conversion.IterateableMap2MapConversion;
import net.sf.sojo.core.conversion.Simple2SimpleConversion;
import net.sf.sojo.core.conversion.SimpleFormatConversion;
import net.sf.sojo.core.conversion.interceptor.SimpleKeyMapperInterceptor;
import net.sf.sojo.core.conversion.interceptor.ThrowableConverterInterceptor;
import net.sf.sojo.core.filter.ClassPropertyFilter;
import net.sf.sojo.core.filter.ClassPropertyFilterHandler;
import net.sf.sojo.core.filter.ClassPropertyFilterHandlerImpl;

public final class ObjectUtil {
    private Converter converter = new Converter();
    private SimpleKeyMapperInterceptor simpleKeyMapperInterceptor = new SimpleKeyMapperInterceptor();
    private IterateableMap2MapConversion map2MapConversion = new IterateableMap2MapConversion();
    private IterateableMap2BeanConversion map2BeanConversion = new IterateableMap2BeanConversion();
    private ComplexBean2MapConversion bean2MapConversion = new ComplexBean2MapConversion();
    private Iterateable2IterateableConversion iterateable2IterateableConversion = new Iterateable2IterateableConversion();
    private SimpleFormatConversion simpleFormatConversion = new SimpleFormatConversion();
    private Simple2SimpleConversion simpleURL2StringConversion = new Simple2SimpleConversion(URL.class, String.class);
    private ThrowableConverterInterceptor throwableConverterInterceptor = new ThrowableConverterInterceptor();
    private boolean withSimpleKeyMapper = true;

    public ObjectUtil() {
        this(true);
    }

    public ObjectUtil(boolean pvWithSimpleKeyMapper) {
        this.setWithSimpleKeyMapper(pvWithSimpleKeyMapper);
        if (this.getWithSimpleKeyMapper()) {
            this.map2MapConversion.getConverterInterceptorHandler().addConverterInterceptor(this.simpleKeyMapperInterceptor);
        }
        this.converter.addConversion(this.map2MapConversion);
        this.converter.addConversion(this.map2BeanConversion);
        this.converter.addConversion(this.bean2MapConversion);
        this.converter.addConversion(this.iterateable2IterateableConversion);
        this.converter.addConversion(this.simpleURL2StringConversion);
        this.converter.addConverterInterceptor(this.throwableConverterInterceptor);
    }

    public void addFormatterForType(Format pvFormat, Class<?> pvType) {
        this.simpleFormatConversion.addFormatter(pvType, pvFormat);
        if (!this.getConverter().getConversionHandler().containsConversion(this.simpleFormatConversion)) {
            this.getConverter().addConversion(this.simpleFormatConversion);
        }
    }

    public void removeFormatterByType(Class<?> pvType) {
        this.simpleFormatConversion.removeFormatterByType(pvType);
        if (this.simpleFormatConversion.getFormatterSize() == 0) {
            this.getConverter().removeConversion(this.simpleFormatConversion);
        }
    }

    public void setIgnoreAllNullValues(boolean pvIgnoreNullValues) {
        this.map2MapConversion.setIgnoreNullValues(pvIgnoreNullValues);
        this.map2BeanConversion.setIgnoreNullValues(pvIgnoreNullValues);
        this.bean2MapConversion.setIgnoreNullValues(pvIgnoreNullValues);
        this.iterateable2IterateableConversion.setIgnoreNullValues(pvIgnoreNullValues);
    }

    public boolean getIgnoreAllNullValues() {
        return this.map2MapConversion.getIgnoreNullValues() && this.map2BeanConversion.getIgnoreNullValues() && this.bean2MapConversion.getIgnoreNullValues() && this.iterateable2IterateableConversion.getIgnoreNullValues();
    }

    public void setClassPropertyFilterHandler(ClassPropertyFilterHandler pvClassPropertyFilterHandler) {
        this.converter.setClassPropertyFilterHandler(pvClassPropertyFilterHandler);
    }

    public ClassPropertyFilterHandler getClassPropertyFilterHandler() {
        return this.converter.getClassPropertyFilterHandler();
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setWithSimpleKeyMapper(boolean pvWithSimpleKeyMapper) {
        this.withSimpleKeyMapper = pvWithSimpleKeyMapper;
        ConverterInterceptorHandler lvHandler = this.map2MapConversion.getConverterInterceptorHandler();
        if (!this.getWithSimpleKeyMapper()) {
            lvHandler.removeConverterInterceptor(this.simpleKeyMapperInterceptor);
        } else {
            lvHandler.addConverterInterceptor(this.simpleKeyMapperInterceptor);
        }
    }

    public boolean getWithSimpleKeyMapper() {
        return this.withSimpleKeyMapper;
    }

    public boolean getWithCycleDetection() {
        Conversion c;
        boolean lvResult = false;
        ConversionHandler ch = this.converter.getConversionHandler();
        for (int i = 0; !(i >= ch.size() || (c = ch.getConversionByPosition(i)) instanceof ConversionIterator && (lvResult = ((ConversionIterator)c).getWithCycleDetection())); ++i) {
        }
        return lvResult;
    }

    public void setWithCycleDetection(boolean pvWithCycleDetection) {
        ConversionHandler ch = this.converter.getConversionHandler();
        for (int i = 0; i < ch.size(); ++i) {
            Conversion c = ch.getConversionByPosition(i);
            if (!(c instanceof ConversionIterator)) continue;
            ((ConversionIterator)c).setWithCycleDetection(pvWithCycleDetection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object makeSimple(Object pvRootObject, String[] pvExcludedProperties) {
        ClassPropertyFilterHandler lvClassPropertyFilterHandler = this.getClassPropertyFilterHandler();
        if (pvRootObject != null && pvExcludedProperties != null && pvExcludedProperties.length > 0) {
            ClassPropertyFilter lvClassPropertyFilter = new ClassPropertyFilter(pvRootObject.getClass());
            lvClassPropertyFilter.setSupport4AddClassProperty(true);
            lvClassPropertyFilter.addProperties(pvExcludedProperties);
            ClassPropertyFilterHandlerImpl lvTempFilterHandler = new ClassPropertyFilterHandlerImpl(lvClassPropertyFilter);
            this.setClassPropertyFilterHandler(lvTempFilterHandler);
        }
        Object lvReturn = null;
        try {
            lvReturn = this.makeSimple(pvRootObject);
        }
        finally {
            this.setClassPropertyFilterHandler(lvClassPropertyFilterHandler);
        }
        return lvReturn;
    }

    public Object makeSimple(Object pvRootObject) {
        this.simpleKeyMapperInterceptor.setMakeSimple(true);
        this.converter.removeConversion(this.map2BeanConversion);
        Object lvSimple = this.converter.convert(pvRootObject);
        return lvSimple;
    }

    public Object makeComplex(Object pvRootObject) {
        return this.makeComplex(pvRootObject, null);
    }

    public Object makeComplex(Object pvRootObject, Class<?> pvRootClass) {
        this.simpleKeyMapperInterceptor.setMakeSimple(false);
        this.converter.addConversion(this.map2BeanConversion);
        Object lvComplex = this.converter.convert(pvRootObject, pvRootClass);
        return lvComplex;
    }

    public Object copy(Object pvRootObject) {
        Object lvSimple = this.makeSimple(pvRootObject);
        Object lvComplex = this.makeComplex(lvSimple);
        return lvComplex;
    }

    public int hashCode(Object pvObject) {
        long lvHashCode = 17L;
        ObjectGraphWalker ogw = new ObjectGraphWalker(this.getClassPropertyFilterHandler());
        ogw.setIgnoreNullValues(true);
        PathRecordWalkerInterceptor lvInterceptor = new PathRecordWalkerInterceptor();
        lvInterceptor.setOnlySimpleProperties(true);
        lvInterceptor.setFilterUniqueIdProperty(true);
        ogw.addInterceptor(lvInterceptor);
        ogw.walk(pvObject);
        for (Object entry : lvInterceptor.getAllRecordedPaths().values()) {
            lvHashCode = lvHashCode * 37L + (long)entry.hashCode();
        }
        return new Long(lvHashCode).intValue();
    }

    public boolean equals(Object pvObject1, Object pvObject2) {
        boolean lvEquals = false;
        if (pvObject1 != null && pvObject2 != null) {
            CompareResult lvResult = this.compare(pvObject1, pvObject2);
            lvEquals = lvResult == null;
        }
        return lvEquals;
    }

    public CompareResult compare(Object pvObject1, Object pvObject2) {
        CompareResult[] lvCompareResults = null;
        lvCompareResults = this.compareIntern(pvObject1, pvObject2, true);
        CompareResult lvResult = lvCompareResults == null ? null : lvCompareResults[0];
        return lvResult;
    }

    public CompareResult[] compareAll(Object pvObject1, Object pvObject2) {
        CompareResult[] lvCompareResults = this.compareIntern(pvObject1, pvObject2, false);
        return lvCompareResults;
    }

    public int compareTo(Object pvObject1, Object pvObject2) {
        CompareResult[] lvCompareResults;
        int lvCompareToValue = 0;
        if (pvObject1 == null) {
            throw new NullPointerException("First arg by compareTo is Null");
        }
        if (pvObject2 == null) {
            throw new NullPointerException("Second arg by compareTo is Null");
        }
        if (pvObject1 != pvObject2 && (lvCompareResults = this.compareIntern(pvObject1, pvObject2, false)) != null) {
            for (int i = 0; i < lvCompareResults.length; ++i) {
                int zw = lvCompareResults[i].getCompareToValue();
                lvCompareToValue += zw;
            }
        }
        return lvCompareToValue;
    }

    private CompareResult[] compareIntern(Object pvObject1, Object pvObject2, boolean pvBreakByFindDifferents) {
        CompareResult[] lvResult = null;
        if (pvObject1 != null && pvObject2 != null) {
            ObjectGraphWalker lvWalker1 = new ObjectGraphWalker(this.getClassPropertyFilterHandler());
            PathRecordWalkerInterceptor lvInterceptor1 = new PathRecordWalkerInterceptor();
            lvInterceptor1.setOnlySimpleProperties(true);
            lvInterceptor1.setFilterUniqueIdProperty(true);
            lvWalker1.addInterceptor(lvInterceptor1);
            lvWalker1.walk(pvObject1);
            Map<String, Object> lvPathes1 = lvInterceptor1.getAllRecordedPaths();
            ObjectGraphWalker lvWalker2 = new ObjectGraphWalker(this.getClassPropertyFilterHandler());
            PathRecordWalkerInterceptor lvInterceptor2 = new PathRecordWalkerInterceptor();
            lvInterceptor2.setOnlySimpleProperties(true);
            lvInterceptor2.setFilterUniqueIdProperty(true);
            lvWalker2.addInterceptor(lvInterceptor2);
            lvWalker2.walk(pvObject2);
            Map<String, Object> lvPathes2 = lvInterceptor2.getAllRecordedPaths();
            ArrayList<CompareResult> lvCompareResultsList = new ArrayList<CompareResult>();
            ObjectUtil.compareTwoMaps(lvPathes1, lvPathes2, pvBreakByFindDifferents, lvCompareResultsList);
            if (!(lvCompareResultsList.size() > 0 && pvBreakByFindDifferents || lvPathes1.size() == lvPathes2.size())) {
                ObjectUtil.compareTwoMaps(lvPathes2, lvPathes1, pvBreakByFindDifferents, lvCompareResultsList);
            }
            if (lvCompareResultsList.size() > 0) {
                lvResult = lvCompareResultsList.toArray(new CompareResult[lvCompareResultsList.size()]);
            }
        }
        return lvResult;
    }

    private static void compareTwoMaps(Map<?, ?> pvMap1, Map<?, ?> pvMap2, boolean pvBreakByFindDifferents, List<CompareResult> pvCompareResultsList) {
        int lvNumberOfRecursion = 0;
        for (Map.Entry<?, ?> lvEntry1 : pvMap1.entrySet()) {
            ++lvNumberOfRecursion;
            String lvPath1 = (String)lvEntry1.getKey();
            Object lvValue2 = pvMap2.get(lvPath1);
            if (lvValue2 != null && lvValue2.equals(lvEntry1.getValue())) continue;
            if (!ObjectUtil.containsListSearchPath(pvCompareResultsList, lvPath1)) {
                CompareResult lvCompareResult = new CompareResult();
                lvCompareResult.differentPath = lvPath1;
                lvCompareResult.differentValue1 = lvEntry1.getValue();
                lvCompareResult.differentValue2 = lvValue2;
                lvCompareResult.numberOfRecursion = lvNumberOfRecursion;
                pvCompareResultsList.add(lvCompareResult);
            }
            if (!pvBreakByFindDifferents) continue;
            break;
        }
    }

    private static boolean containsListSearchPath(List<CompareResult> pvCompareResultsList, String pvSearchPath) {
        for (CompareResult lvCompareResult : pvCompareResultsList) {
            if (!lvCompareResult.differentPath.equals(pvSearchPath)) continue;
            return true;
        }
        return false;
    }
}

