/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.FieldOptimizationInfo;
import proguard.optimize.info.SimpleEnumMarker;

public class SimpleEnumDescriptorSimplifier
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
MemberVisitor,
AttributeVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor {
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraInstructionVisitor;
    private final PartialEvaluator partialEvaluator;
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(false, true);

    public SimpleEnumDescriptorSimplifier() {
        this(new PartialEvaluator(), null);
    }

    public SimpleEnumDescriptorSimplifier(PartialEvaluator partialEvaluator, InstructionVisitor extraInstructionVisitor) {
        this.partialEvaluator = partialEvaluator;
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.constantPoolEntriesAccept(this);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        String name;
        Clazz referencedClass = stringConstant.referencedClass;
        if (this.isSimpleEnum(referencedClass) && ClassUtil.isInternalArrayType(name = stringConstant.getString(clazz))) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
            String newName = this.simplifyDescriptor(name, referencedClass);
            stringConstant.u2stringIndex = constantPoolEditor.addUtf8Constant(newName);
            stringConstant.referencedClass = null;
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        String name;
        Clazz referencedClass = classConstant.referencedClass;
        if (this.isSimpleEnum(referencedClass) && ClassUtil.isInternalArrayType(name = classConstant.getName(clazz))) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor((ProgramClass)clazz);
            String newName = this.simplifyDescriptor(name, referencedClass);
            classConstant.u2nameIndex = constantPoolEditor.addUtf8Constant(newName);
            classConstant.referencedClass = null;
        }
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String newDescriptor;
        String descriptor = programField.getDescriptor(programClass);
        if (!descriptor.equals(newDescriptor = this.simplifyDescriptor(descriptor, programField.referencedClass))) {
            String name = programField.getName(programClass);
            String newName = name + '$' + Long.toHexString(Math.abs(descriptor.hashCode()));
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            programField.u2nameIndex = constantPoolEditor.addUtf8Constant(newName);
            programField.u2descriptorIndex = constantPoolEditor.addUtf8Constant(newDescriptor);
            programField.referencedClass = null;
            FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(programField);
            if (fieldOptimizationInfo != null) {
                fieldOptimizationInfo.resetValue(programClass, programField);
            }
            programField.attributesAccept(programClass, this);
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.attributesAccept(programClass, this);
        String descriptor = programMethod.getDescriptor(programClass);
        String newDescriptor = this.simplifyDescriptor(descriptor, programMethod.referencedClasses);
        if (!descriptor.equals(newDescriptor)) {
            String name;
            String newName = name = programMethod.getName(programClass);
            if (!name.equals("<init>")) {
                newName = newName + '$' + Long.toHexString(Math.abs(descriptor.hashCode()));
            }
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            if (!newName.equals(name)) {
                programMethod.u2nameIndex = constantPoolEditor.addUtf8Constant(newName);
            }
            programMethod.u2descriptorIndex = constantPoolEditor.addUtf8Constant(newDescriptor);
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitSignatureAttribute(Clazz clazz, Field field, SignatureAttribute signatureAttribute) {
        String newSignature;
        String signature;
        if (signatureAttribute.referencedClasses != null && signatureAttribute.referencedClasses.length > 0 && !(signature = clazz.getString(signatureAttribute.u2signatureIndex)).equals(newSignature = this.simplifyDescriptor(signature, signatureAttribute.referencedClasses[0]))) {
            signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newSignature);
            signatureAttribute.referencedClasses[0] = null;
        }
    }

    public void visitSignatureAttribute(Clazz clazz, Method method, SignatureAttribute signatureAttribute) {
        String newSignature;
        String signature = clazz.getString(signatureAttribute.u2signatureIndex);
        if (!signature.equals(newSignature = this.simplifyDescriptor(signature, signatureAttribute.referencedClasses))) {
            signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newSignature);
        }
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        String newDescriptor;
        String descriptor = clazz.getString(localVariableInfo.u2descriptorIndex);
        if (!descriptor.equals(newDescriptor = this.simplifyDescriptor(descriptor, localVariableInfo.referencedClass))) {
            localVariableInfo.u2descriptorIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newDescriptor);
            localVariableInfo.referencedClass = null;
        }
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        String newSignature;
        String signature;
        if (localVariableTypeInfo.referencedClasses != null && localVariableTypeInfo.referencedClasses.length > 0 && !(signature = clazz.getString(localVariableTypeInfo.u2signatureIndex)).equals(newSignature = this.simplifyDescriptor(signature, localVariableTypeInfo.referencedClasses[0]))) {
            localVariableTypeInfo.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newSignature);
            localVariableTypeInfo.referencedClasses[0] = null;
        }
    }

    private String simplifyDescriptor(String descriptor, Clazz referencedClass) {
        return this.isSimpleEnum(referencedClass) ? descriptor.substring(0, ClassUtil.internalArrayTypeDimensionCount(descriptor)) + 'I' : descriptor;
    }

    private String simplifyDescriptor(String descriptor, Clazz[] referencedClasses) {
        if (referencedClasses != null) {
            Clazz referencedClass;
            int counter;
            int referencedClassIndex = 0;
            int newReferencedClassIndex = 0;
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(descriptor);
            StringBuffer newDescriptorBuffer = new StringBuffer();
            newDescriptorBuffer.append(internalTypeEnumeration.formalTypeParameters());
            newDescriptorBuffer.append('(');
            String type = internalTypeEnumeration.formalTypeParameters();
            int count = new DescriptorClassEnumeration(type).classCount();
            for (counter = 0; counter < count; ++counter) {
                if (this.isSimpleEnum(referencedClass = referencedClasses[referencedClassIndex++])) continue;
                referencedClasses[newReferencedClassIndex++] = referencedClass;
            }
            while (internalTypeEnumeration.hasMoreTypes()) {
                type = internalTypeEnumeration.nextType();
                count = new DescriptorClassEnumeration(type).classCount();
                for (counter = 0; counter < count; ++counter) {
                    if (!this.isSimpleEnum(referencedClass = referencedClasses[referencedClassIndex++])) {
                        referencedClasses[newReferencedClassIndex++] = referencedClass;
                        continue;
                    }
                    type = type.substring(0, ClassUtil.internalArrayTypeDimensionCount(type)) + 'I';
                }
                newDescriptorBuffer.append(type);
            }
            type = internalTypeEnumeration.returnType();
            count = new DescriptorClassEnumeration(type).classCount();
            for (counter = 0; counter < count; ++counter) {
                if (!this.isSimpleEnum(referencedClass = referencedClasses[referencedClassIndex++])) {
                    referencedClasses[newReferencedClassIndex++] = referencedClass;
                    continue;
                }
                type = type.substring(0, ClassUtil.internalArrayTypeDimensionCount(type)) + 'I';
            }
            newDescriptorBuffer.append(')');
            newDescriptorBuffer.append(type);
            while (newReferencedClassIndex < referencedClassIndex) {
                referencedClasses[newReferencedClassIndex++] = null;
            }
            descriptor = newDescriptorBuffer.toString();
        }
        return descriptor;
    }

    private boolean isSimpleEnum(Clazz clazz) {
        return clazz != null && SimpleEnumMarker.isSimpleEnum(clazz);
    }
}

