/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ClassReferenceFixer
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor,
MemberVisitor,
AttributeVisitor,
InnerClassesInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private final boolean ensureUniqueMemberNames;

    public ClassReferenceFixer(boolean ensureUniqueMemberNames) {
        this.ensureUniqueMemberNames = ensureUniqueMemberNames;
    }

    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.fieldsAccept(this);
        libraryClass.methodsAccept(this);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String newDescriptor;
        String descriptor = programField.getDescriptor(programClass);
        if (!descriptor.equals(newDescriptor = ClassReferenceFixer.newDescriptor(descriptor, programField.referencedClass))) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            programField.u2descriptorIndex = constantPoolEditor.addUtf8Constant(newDescriptor);
            if (this.ensureUniqueMemberNames) {
                String name = programField.getName(programClass);
                String newName = this.newUniqueMemberName(name, descriptor);
                programField.u2nameIndex = constantPoolEditor.addUtf8Constant(newName);
            }
        }
        programField.attributesAccept(programClass, this);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String newDescriptor;
        String descriptor = programMethod.getDescriptor(programClass);
        if (!descriptor.equals(newDescriptor = ClassReferenceFixer.newDescriptor(descriptor, programMethod.referencedClasses))) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            programMethod.u2descriptorIndex = constantPoolEditor.addUtf8Constant(newDescriptor);
            if (this.ensureUniqueMemberNames) {
                String name = programMethod.getName(programClass);
                String newName = this.newUniqueMemberName(name, descriptor);
                programMethod.u2nameIndex = constantPoolEditor.addUtf8Constant(newName);
            }
        }
        programMethod.attributesAccept(programClass, this);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        String newDescriptor;
        String descriptor = libraryField.getDescriptor(libraryClass);
        libraryField.descriptor = newDescriptor = ClassReferenceFixer.newDescriptor(descriptor, libraryField.referencedClass);
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        String newDescriptor;
        String descriptor = libraryMethod.getDescriptor(libraryClass);
        libraryMethod.descriptor = newDescriptor = ClassReferenceFixer.newDescriptor(descriptor, libraryMethod.referencedClasses);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        String externalClassName;
        String internalClassName;
        String newInternalClassName;
        Clazz referencedClass = stringConstant.referencedClass;
        Member referencedMember = stringConstant.referencedMember;
        if (referencedClass != null && referencedMember == null && !(newInternalClassName = ClassReferenceFixer.newClassName(internalClassName = ClassUtil.internalClassName(externalClassName = stringConstant.getString(clazz)), referencedClass)).equals(internalClassName)) {
            String newExternalClassName = ClassUtil.externalClassName(newInternalClassName);
            stringConstant.u2stringIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newExternalClassName);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        String newClassName;
        String className;
        Clazz referencedClass = classConstant.referencedClass;
        if (referencedClass != null && !(className = classConstant.getName(clazz)).equals(newClassName = ClassReferenceFixer.newClassName(className, referencedClass))) {
            classConstant.u2nameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newClassName);
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        String newSignature;
        String signature = clazz.getString(signatureAttribute.u2signatureIndex);
        if (!signature.equals(newSignature = ClassReferenceFixer.newDescriptor(signature, signatureAttribute.referencedClasses))) {
            signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newSignature);
        }
    }

    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        String newInnerName;
        int index;
        int innerClassIndex = innerClassesInfo.u2innerClassIndex;
        int innerNameIndex = innerClassesInfo.u2innerNameIndex;
        if (innerClassIndex != 0 && innerNameIndex != 0 && (index = (newInnerName = clazz.getClassName(innerClassIndex)).lastIndexOf(36)) >= 0) {
            innerClassesInfo.u2innerNameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newInnerName.substring(index + 1));
        }
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        String newDescriptor;
        String descriptor = clazz.getString(localVariableInfo.u2descriptorIndex);
        if (!descriptor.equals(newDescriptor = ClassReferenceFixer.newDescriptor(descriptor, localVariableInfo.referencedClass))) {
            localVariableInfo.u2descriptorIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newDescriptor);
        }
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        String newSignature;
        String signature = clazz.getString(localVariableTypeInfo.u2signatureIndex);
        if (!signature.equals(newSignature = ClassReferenceFixer.newDescriptor(signature, localVariableTypeInfo.referencedClasses))) {
            localVariableTypeInfo.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newSignature);
        }
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        String newTypeName;
        String typeName = clazz.getString(annotation.u2typeIndex);
        if (!typeName.equals(newTypeName = ClassReferenceFixer.newDescriptor(typeName, annotation.referencedClasses))) {
            annotation.u2typeIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newTypeName);
        }
        annotation.elementValuesAccept(clazz, this);
    }

    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
    }

    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        String newTypeName;
        String typeName = clazz.getString(enumConstantElementValue.u2typeNameIndex);
        if (!typeName.equals(newTypeName = ClassReferenceFixer.newDescriptor(typeName, enumConstantElementValue.referencedClasses))) {
            enumConstantElementValue.u2typeNameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newTypeName);
        }
    }

    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        String newClassName;
        String className = clazz.getString(classElementValue.u2classInfoIndex);
        if (!className.equals(newClassName = ClassReferenceFixer.newDescriptor(className, classElementValue.referencedClasses))) {
            classElementValue.u2classInfoIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(newClassName);
        }
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        annotationElementValue.annotationAccept(clazz, this);
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private static String newDescriptor(String descriptor, Clazz referencedClass) {
        if (referencedClass == null) {
            return descriptor;
        }
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(descriptor);
        StringBuffer newDescriptorBuffer = new StringBuffer(descriptor.length());
        newDescriptorBuffer.append(descriptorClassEnumeration.nextFluff());
        if (descriptorClassEnumeration.hasMoreClassNames()) {
            String className = descriptorClassEnumeration.nextClassName();
            String fluff = descriptorClassEnumeration.nextFluff();
            String newClassName = ClassReferenceFixer.newClassName(className, referencedClass);
            newDescriptorBuffer.append(newClassName);
            newDescriptorBuffer.append(fluff);
        }
        return newDescriptorBuffer.toString();
    }

    private static String newDescriptor(String descriptor, Clazz[] referencedClasses) {
        if (referencedClasses == null || referencedClasses.length == 0) {
            return descriptor;
        }
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(descriptor);
        StringBuffer newDescriptorBuffer = new StringBuffer(descriptor.length());
        newDescriptorBuffer.append(descriptorClassEnumeration.nextFluff());
        int index = 0;
        while (descriptorClassEnumeration.hasMoreClassNames()) {
            String className = descriptorClassEnumeration.nextClassName();
            boolean isInnerClassName = descriptorClassEnumeration.isInnerClassName();
            String fluff = descriptorClassEnumeration.nextFluff();
            String newClassName = ClassReferenceFixer.newClassName(className, referencedClasses[index++]);
            if (isInnerClassName) {
                newClassName = newClassName.substring(newClassName.lastIndexOf(36) + 1);
            }
            newDescriptorBuffer.append(newClassName);
            newDescriptorBuffer.append(fluff);
        }
        return newDescriptorBuffer.toString();
    }

    private String newUniqueMemberName(String name, String descriptor) {
        return name.equals("<init>") ? "<init>" : name + '$' + Long.toHexString(Math.abs(descriptor.hashCode()));
    }

    private static String newClassName(String className, Clazz referencedClass) {
        if (referencedClass == null) {
            return className;
        }
        String newClassName = referencedClass.getName();
        if (className.charAt(0) == '[') {
            newClassName = className.substring(0, className.indexOf(76) + 1) + newClassName + ';';
        }
        return newClassName;
    }
}

