/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.ogn;

import java.lang.reflect.AccessibleObject;
import java.util.Locale;
import net.sf.oval.exception.InvalidConfigurationException;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.internal.util.ReflectionUtils;
import net.sf.oval.ogn.ObjectGraphNavigationResult;
import net.sf.oval.ogn.ObjectGraphNavigator;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.JXPathNotFoundException;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.commons.jxpath.ri.model.beans.BeanPointer;
import org.apache.commons.jxpath.ri.model.beans.BeanPointerFactory;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;
import org.apache.commons.jxpath.ri.model.beans.NullPropertyPointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

public class ObjectGraphNavigatorJXPathImpl
implements ObjectGraphNavigator {
    static {
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new BeanPointerFactoryEx());
    }

    public ObjectGraphNavigationResult navigateTo(Object root, String xpath) throws InvalidConfigurationException {
        Pointer pointer;
        block5: {
            Assert.argumentNotNull("root", root);
            Assert.argumentNotNull("xpath", xpath);
            try {
                JXPathContext ctx = JXPathContext.newContext((Object)root);
                ctx.setLenient(true);
                pointer = ctx.getPointer(xpath);
                if (!(pointer instanceof NullPropertyPointer)) break block5;
                return null;
            }
            catch (JXPathNotFoundException ex) {
                throw new InvalidConfigurationException(ex);
            }
        }
        if (pointer instanceof PropertyPointer) {
            PropertyPointer pp = (PropertyPointer)pointer;
            Class<?> beanClass = pp.getBean().getClass();
            AccessibleObject accessor = ReflectionUtils.getField(beanClass, pp.getPropertyName());
            if (accessor == null) {
                accessor = ReflectionUtils.getGetter(beanClass, pp.getPropertyName());
            }
            return new ObjectGraphNavigationResult(root, xpath, pp.getBean(), accessor, pointer.getValue());
        }
        return new ObjectGraphNavigationResult(root, xpath, pointer.getNode(), null, pointer.getValue());
    }

    protected static final class BeanPointerEx
    extends BeanPointer {
        private static final long serialVersionUID = 1L;
        private final JXPathBeanInfo beanInfo;

        public BeanPointerEx(NodePointer parent, QName name, Object bean, JXPathBeanInfo beanInfo) {
            super(parent, name, bean, beanInfo);
            this.beanInfo = beanInfo;
        }

        public BeanPointerEx(QName name, Object bean, JXPathBeanInfo beanInfo, Locale locale) {
            super(name, bean, beanInfo, locale);
            this.beanInfo = beanInfo;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            BeanPointerEx other = (BeanPointerEx)((Object)obj);
            return !(this.beanInfo == null ? other.beanInfo != null : !this.beanInfo.equals(other.beanInfo));
        }

        public boolean isValidProperty(QName name) {
            if (!super.isValidProperty(name)) {
                return false;
            }
            if (this.beanInfo.getPropertyDescriptor(name.getName()) == null) {
                throw new JXPathNotFoundException("No pointer for xpath: " + this.toString() + "/" + name);
            }
            return true;
        }
    }

    protected static final class BeanPointerFactoryEx
    extends BeanPointerFactory {
        protected BeanPointerFactoryEx() {
        }

        public NodePointer createNodePointer(NodePointer parent, QName name, Object bean) {
            if (bean == null) {
                return new NullPointer(parent, name);
            }
            JXPathBeanInfo bi = JXPathIntrospector.getBeanInfo(bean.getClass());
            return new BeanPointerEx(parent, name, bean, bi);
        }

        public NodePointer createNodePointer(QName name, Object bean, Locale locale) {
            JXPathBeanInfo bi = JXPathIntrospector.getBeanInfo(bean.getClass());
            return new BeanPointerEx(name, bean, bi, locale);
        }

        public int getOrder() {
            return 899;
        }
    }
}

