/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.WeakHashMap;
import net.sf.oval.internal.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializableField
implements Serializable {
    private static final Log LOG = Log.getLog(SerializableField.class);
    private static final WeakHashMap<Field, SerializableField> CACHE = new WeakHashMap();
    private static final long serialVersionUID = 1L;
    private final Class<?> declaringClass;
    private transient Field field;
    private final String name;

    public static SerializableField getInstance(Field field) {
        SerializableField sm = CACHE.get(field);
        if (sm == null) {
            sm = new SerializableField(field);
            CACHE.put(field, sm);
        }
        return sm;
    }

    private SerializableField(Field field) {
        this.field = field;
        this.name = field.getName();
        this.declaringClass = field.getDeclaringClass();
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.field = this.declaringClass.getDeclaredField(this.name);
        }
        catch (NoSuchFieldException ex) {
            LOG.debug("Unexpected NoSuchFieldException occured", ex);
            throw new IOException(ex.getMessage());
        }
    }
}

