/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Locale;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.AssertURL;
import net.sf.oval.context.OValContext;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertURLCheck
extends AbstractAnnotationCheck<AssertURL> {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Log.getLog(AssertURLCheck.class);
    private boolean connect = false;
    private final List<URIScheme> permittedURISchemes = Validator.getCollectionFactory().createList(2);

    private static boolean canConnect(String url) {
        block3: {
            int rc;
            block4: {
                try {
                    URL theURL = new URL(url);
                    URLConnection conn = theURL.openConnection();
                    conn.connect();
                    conn.getInputStream().close();
                    if (!(conn instanceof HttpURLConnection)) break block3;
                    HttpURLConnection httpConnection = (HttpURLConnection)conn;
                    rc = httpConnection.getResponseCode();
                    if (rc >= 400) break block4;
                    return true;
                }
                catch (IOException ex) {
                    LOG.debug("Connecting failed with exception", ex);
                    return false;
                }
            }
            LOG.debug("Connecting failed with HTTP response code " + rc);
            return false;
        }
        return true;
    }

    @Override
    public void configure(AssertURL constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setConnect(constraintAnnotation.connect());
        this.setPermittedURISchemes(constraintAnnotation.permittedURISchemes());
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public URIScheme[] getPermittedURISchemes() {
        return this.permittedURISchemes.size() == 0 ? null : this.permittedURISchemes.toArray(new URIScheme[this.permittedURISchemes.size()]);
    }

    public boolean isConnect() {
        return this.connect;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        String uriString;
        block7: {
            String scheme;
            block6: {
                if (valueToValidate == null) {
                    return true;
                }
                uriString = valueToValidate.toString();
                try {
                    URI uri = new URI(uriString);
                    scheme = uri.getScheme();
                    if (scheme != null && uri.getRawSchemeSpecificPart() != null) break block6;
                    LOG.debug("URI scheme or scheme-specific-part not specified");
                    return false;
                }
                catch (URISyntaxException uRISyntaxException) {
                    LOG.debug("URI scheme or scheme-specific-part not specified");
                    return false;
                }
            }
            if (this.isURISchemeValid(scheme.toLowerCase(Locale.getDefault()))) break block7;
            return false;
        }
        if (this.connect) {
            return AssertURLCheck.canConnect(uriString);
        }
        return true;
    }

    private boolean isURISchemeValid(String url) {
        for (URIScheme scheme : this.permittedURISchemes) {
            if (!url.startsWith(scheme.getScheme())) continue;
            return true;
        }
        return false;
    }

    public void setConnect(boolean connect) {
        this.connect = connect;
    }

    public void setPermittedURISchemes(URIScheme[] permittedURISchemes) {
        this.permittedURISchemes.clear();
        ArrayUtils.addAll(this.permittedURISchemes, permittedURISchemes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum URIScheme {
        FTP("ftp"),
        HTTP("http"),
        HTTPS("https");

        private final String scheme;

        private URIScheme(String scheme) {
            this.scheme = scheme;
        }

        public String getScheme() {
            return this.scheme;
        }

        public String toString() {
            return this.scheme;
        }
    }
}

