/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import net.sf.oval.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LinkedSet<E>
implements Cloneable,
Set<E>,
List<E> {
    private final List<E> list;

    public LinkedSet() {
        this.list = Validator.getCollectionFactory().createList(16);
    }

    public LinkedSet(int initialCapacity) {
        this.list = Validator.getCollectionFactory().createList(initialCapacity);
    }

    @Override
    public boolean add(E e) {
        return this.list.add(e);
    }

    @Override
    public void add(int index, E e) {
        if (!this.list.contains(e)) {
            this.list.add(index, e);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean itemAdded = false;
        for (E o : c) {
            if (this.list.contains(o)) continue;
            this.add(o);
            itemAdded = true;
        }
        return itemAdded;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        List tmp = Validator.getCollectionFactory().createList(c.size());
        for (E o : c) {
            if (this.list.contains(o)) continue;
            tmp.add(o);
        }
        return this.list.addAll(index, tmp);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        LinkedSet os = (LinkedSet)super.clone();
        os.list.addAll(this.list);
        return os;
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkedSet other = (LinkedSet)obj;
        return !(this.list == null ? other.list != null : !this.list.equals(other.list));
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.list == null ? 0 : this.list.hashCode());
        return result;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public E remove(int index) {
        return this.list.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.list.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.list.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        int elementIndex = this.list.indexOf(element);
        if (elementIndex == index) {
            return element;
        }
        if (elementIndex == -1) {
            return this.list.set(index, element);
        }
        if (elementIndex > index) {
            this.list.remove(element);
            return this.list.set(index, element);
        }
        this.list.remove(element);
        return this.list.set(index - 1, element);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public String toString() {
        return this.list.toString();
    }
}

