/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.Map;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.ExpressionLanguage;
import net.sf.oval.internal.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionLanguageBeanShellImpl
implements ExpressionLanguage {
    private static final Log LOG = Log.getLog(ExpressionLanguageBeanShellImpl.class);

    @Override
    public Object evaluate(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        LOG.debug("Evaluating BeanShell expression: {1}", expression);
        try {
            Interpreter interpreter = new Interpreter();
            interpreter.eval("setAccessibility(true)");
            for (Map.Entry<String, ?> entry : values.entrySet()) {
                interpreter.set(entry.getKey(), entry.getValue());
            }
            return interpreter.eval(expression);
        }
        catch (EvalError ex) {
            throw new ExpressionEvaluationException("Evaluating BeanShell expression failed: " + expression, ex);
        }
    }

    @Override
    public boolean evaluateAsBoolean(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        Object result = this.evaluate(expression, values);
        if (!(result instanceof Boolean)) {
            throw new ExpressionEvaluationException("The script must return a boolean value.");
        }
        return (Boolean)result;
    }
}

