/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.configuration.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.CollectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.Sun14ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.mapper.Mapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.oval.AbstractCheck;
import net.sf.oval.Check;
import net.sf.oval.CheckExclusion;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.configuration.CheckInitializationListener;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.configuration.annotation.Constraint;
import net.sf.oval.configuration.pojo.POJOConfigurer;
import net.sf.oval.configuration.pojo.elements.ClassConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstraintSetConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstructorConfiguration;
import net.sf.oval.configuration.pojo.elements.FieldConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodPostExecutionConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodPreExecutionConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodReturnValueConfiguration;
import net.sf.oval.configuration.pojo.elements.ObjectConfiguration;
import net.sf.oval.configuration.pojo.elements.ParameterConfiguration;
import net.sf.oval.constraint.AssertCheck;
import net.sf.oval.constraint.AssertConstraintSetCheck;
import net.sf.oval.constraint.AssertFalseCheck;
import net.sf.oval.constraint.AssertFieldConstraintsCheck;
import net.sf.oval.constraint.AssertNullCheck;
import net.sf.oval.constraint.AssertTrueCheck;
import net.sf.oval.constraint.AssertURLCheck;
import net.sf.oval.constraint.AssertValidCheck;
import net.sf.oval.constraint.CheckWithCheck;
import net.sf.oval.constraint.DateRangeCheck;
import net.sf.oval.constraint.DigitsCheck;
import net.sf.oval.constraint.EmailCheck;
import net.sf.oval.constraint.EqualToFieldCheck;
import net.sf.oval.constraint.FutureCheck;
import net.sf.oval.constraint.HasSubstringCheck;
import net.sf.oval.constraint.InstanceOfAnyCheck;
import net.sf.oval.constraint.InstanceOfCheck;
import net.sf.oval.constraint.LengthCheck;
import net.sf.oval.constraint.MatchPatternCheck;
import net.sf.oval.constraint.MaxCheck;
import net.sf.oval.constraint.MaxLengthCheck;
import net.sf.oval.constraint.MaxSizeCheck;
import net.sf.oval.constraint.MemberOfCheck;
import net.sf.oval.constraint.MinCheck;
import net.sf.oval.constraint.MinLengthCheck;
import net.sf.oval.constraint.MinSizeCheck;
import net.sf.oval.constraint.NoSelfReferenceCheck;
import net.sf.oval.constraint.NotBlankCheck;
import net.sf.oval.constraint.NotEmptyCheck;
import net.sf.oval.constraint.NotEqualCheck;
import net.sf.oval.constraint.NotEqualToFieldCheck;
import net.sf.oval.constraint.NotMatchPatternCheck;
import net.sf.oval.constraint.NotMemberOfCheck;
import net.sf.oval.constraint.NotNegativeCheck;
import net.sf.oval.constraint.NotNullCheck;
import net.sf.oval.constraint.PastCheck;
import net.sf.oval.constraint.RangeCheck;
import net.sf.oval.constraint.SizeCheck;
import net.sf.oval.constraint.ValidateWithMethodCheck;
import net.sf.oval.constraint.exclusion.NullableExclusion;
import net.sf.oval.exception.InvalidConfigurationException;
import net.sf.oval.guard.PostCheck;
import net.sf.oval.guard.PreCheck;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.internal.util.LinkedSet;
import net.sf.oval.internal.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLConfigurer
implements Configurer {
    private static final Log LOG = Log.getLog(Validator.class);
    protected final Set<CheckInitializationListener> listeners = new LinkedSet<CheckInitializationListener>(2);
    private POJOConfigurer pojoConfigurer = new POJOConfigurer();
    private final XStream xStream;

    public XMLConfigurer() {
        StaxDriver xmlDriver = ReflectionUtils.isClassPresent("javax.xml.stream.XMLStreamReader") ? new StaxDriver() : (ReflectionUtils.isClassPresent("org.xmlpull.mxp1.MXParser") ? new XppDriver() : new DomDriver());
        LOG.info("XML driver implementation: {1}", xmlDriver.getClass().getName());
        this.xStream = new XStream((ReflectionProvider)new XStreamReflectionProvider(), (HierarchicalStreamDriver)xmlDriver);
        this.configureXStream();
    }

    public XMLConfigurer(File xmlConfigFile) throws IOException {
        this();
        this.fromXML(xmlConfigFile);
    }

    public XMLConfigurer(InputStream xmlConfigStream) {
        this();
        this.fromXML(xmlConfigStream);
    }

    public XMLConfigurer(Reader xmlConfigReader) {
        this();
        this.fromXML(xmlConfigReader);
    }

    public XMLConfigurer(String xmlConfigAsString) {
        this();
        this.fromXML(xmlConfigAsString);
    }

    public boolean addCheckInitializationListener(CheckInitializationListener listener) {
        Assert.argumentNotNull("listener", listener);
        return this.listeners.add(listener);
    }

    private void configureXStream() {
        this.xStream.registerConverter((Converter)new ReflectionConverter(this.xStream.getMapper(), this.xStream.getReflectionProvider()){

            public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
                Object instance = super.unmarshal(reader, context);
                if (instance instanceof Check) {
                    for (CheckInitializationListener listener : XMLConfigurer.this.listeners) {
                        listener.onCheckInitialized((Check)instance);
                    }
                }
                return instance;
            }
        }, -20);
        this.xStream.registerConverter((Converter)new ListConverter(this.xStream.getMapper()));
        this.xStream.registerConverter((Converter)new AssertCheckConverter());
        this.xStream.omitField(AbstractCheck.class, "messageVariablesUpToDate");
        this.xStream.useAttributeFor(Class.class);
        this.xStream.useAttributeFor(Boolean.TYPE);
        this.xStream.useAttributeFor(Byte.TYPE);
        this.xStream.useAttributeFor(Character.TYPE);
        this.xStream.useAttributeFor(Double.TYPE);
        this.xStream.useAttributeFor(Float.TYPE);
        this.xStream.useAttributeFor(Integer.TYPE);
        this.xStream.useAttributeFor(Long.TYPE);
        this.xStream.useAttributeFor(Boolean.class);
        this.xStream.useAttributeFor(Byte.class);
        this.xStream.useAttributeFor(Character.class);
        this.xStream.useAttributeFor(Double.class);
        this.xStream.useAttributeFor(Float.class);
        this.xStream.useAttributeFor(Integer.class);
        this.xStream.useAttributeFor(Long.class);
        this.xStream.useAttributeFor(String.class);
        this.xStream.alias("java-type", Class.class);
        this.xStream.alias("constraintTarget", ConstraintTarget.class);
        this.xStream.alias("assert", AssertCheck.class);
        this.xStream.alias("assertConstraintSet", AssertConstraintSetCheck.class);
        this.xStream.alias("assertFalse", AssertFalseCheck.class);
        this.xStream.alias("assertFieldConstraints", AssertFieldConstraintsCheck.class);
        this.xStream.alias("assertNull", AssertNullCheck.class);
        this.xStream.alias("assertTrue", AssertTrueCheck.class);
        this.xStream.alias("assertURL", AssertURLCheck.class);
        this.xStream.alias("permittedURIScheme", AssertURLCheck.URIScheme.class);
        this.xStream.addImplicitCollection(AssertURLCheck.class, "permittedURISchemes", AssertURLCheck.URIScheme.class);
        this.xStream.alias("assertValid", AssertValidCheck.class);
        this.xStream.alias("checkWith", CheckWithCheck.class);
        this.xStream.alias("dateRange", DateRangeCheck.class);
        this.xStream.alias("digits", DigitsCheck.class);
        this.xStream.alias("email", EmailCheck.class);
        this.xStream.alias("equalToField", EqualToFieldCheck.class);
        this.xStream.alias("future", FutureCheck.class);
        this.xStream.alias("hasSubstring", HasSubstringCheck.class);
        this.xStream.alias("instanceOf", InstanceOfCheck.class);
        this.xStream.alias("instanceOfAny", InstanceOfAnyCheck.class);
        this.xStream.alias("length", LengthCheck.class);
        this.xStream.alias("matchPattern", MatchPatternCheck.class);
        this.xStream.alias("pattern", Pattern.class);
        this.xStream.addImplicitCollection(MatchPatternCheck.class, "patterns", Pattern.class);
        this.xStream.alias("max", MaxCheck.class);
        this.xStream.alias("maxLength", MaxLengthCheck.class);
        this.xStream.alias("maxSize", MaxSizeCheck.class);
        this.xStream.alias("memberOf", MemberOfCheck.class);
        this.xStream.alias("min", MinCheck.class);
        this.xStream.alias("minLength", MinLengthCheck.class);
        this.xStream.alias("minSize", MinSizeCheck.class);
        this.xStream.alias("noSelfReference", NoSelfReferenceCheck.class);
        this.xStream.alias("notBlank", NotBlankCheck.class);
        this.xStream.alias("notEmpty", NotEmptyCheck.class);
        this.xStream.alias("notEqual", NotEqualCheck.class);
        this.xStream.alias("notEqualToField", NotEqualToFieldCheck.class);
        this.xStream.alias("notMatchPattern", NotMatchPatternCheck.class);
        this.xStream.addImplicitCollection(NotMatchPatternCheck.class, "patterns", Pattern.class);
        this.xStream.alias("notMemberOf", NotMemberOfCheck.class);
        this.xStream.alias("notNegative", NotNegativeCheck.class);
        this.xStream.alias("notNull", NotNullCheck.class);
        this.xStream.alias("past", PastCheck.class);
        this.xStream.alias("range", RangeCheck.class);
        this.xStream.alias("simpleCheck", CheckWithCheck.SimpleCheck.class);
        this.xStream.alias("size", SizeCheck.class);
        this.xStream.alias("validateWithMethod", ValidateWithMethodCheck.class);
        this.xStream.alias("nullable", NullableExclusion.class);
        this.xStream.alias("oval", POJOConfigurer.class);
        this.xStream.addImplicitCollection(POJOConfigurer.class, "constraintSetConfigurations", ConstraintSetConfiguration.class);
        this.xStream.alias("constraintSet", ConstraintSetConfiguration.class);
        this.xStream.addImplicitCollection(ConstraintSetConfiguration.class, "checks");
        this.xStream.addImplicitCollection(POJOConfigurer.class, "classConfigurations", ClassConfiguration.class);
        this.xStream.alias("class", ClassConfiguration.class);
        this.xStream.aliasField("object", ClassConfiguration.class, "objectConfiguration");
        this.xStream.addImplicitCollection(ObjectConfiguration.class, "checks");
        this.xStream.addImplicitCollection(ClassConfiguration.class, "fieldConfigurations", FieldConfiguration.class);
        this.xStream.alias("field", FieldConfiguration.class);
        this.xStream.addImplicitCollection(FieldConfiguration.class, "checks");
        this.xStream.alias("parameter", ParameterConfiguration.class);
        this.xStream.addImplicitCollection(ParameterConfiguration.class, "checks", Check.class);
        this.xStream.addImplicitCollection(ParameterConfiguration.class, "checkExclusions", CheckExclusion.class);
        this.xStream.addImplicitCollection(ClassConfiguration.class, "constructorConfigurations", ConstructorConfiguration.class);
        this.xStream.alias("constructor", ConstructorConfiguration.class);
        this.xStream.addImplicitCollection(ConstructorConfiguration.class, "parameterConfigurations", ParameterConfiguration.class);
        this.xStream.addImplicitCollection(ClassConfiguration.class, "methodConfigurations", MethodConfiguration.class);
        this.xStream.alias("method", MethodConfiguration.class);
        this.xStream.addImplicitCollection(MethodConfiguration.class, "parameterConfigurations", ParameterConfiguration.class);
        this.xStream.aliasField("returnValue", MethodConfiguration.class, "returnValueConfiguration");
        this.xStream.addImplicitCollection(MethodReturnValueConfiguration.class, "checks", Check.class);
        this.xStream.aliasField("preExecution", MethodConfiguration.class, "preExecutionConfiguration");
        this.xStream.addImplicitCollection(MethodPreExecutionConfiguration.class, "checks", PreCheck.class);
        this.xStream.alias("pre", PreCheck.class);
        this.xStream.aliasField("postExecution", MethodConfiguration.class, "postExecutionConfiguration");
        this.xStream.addImplicitCollection(MethodPostExecutionConfiguration.class, "checks", PostCheck.class);
        this.xStream.alias("post", PostCheck.class);
    }

    public void fromXML(File input) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(input));
        try {
            this.fromXML(bis);
        }
        finally {
            bis.close();
        }
    }

    public void fromXML(InputStream input) {
        this.pojoConfigurer = (POJOConfigurer)this.xStream.fromXML(input);
    }

    public void fromXML(Reader input) {
        this.pojoConfigurer = (POJOConfigurer)this.xStream.fromXML(input);
    }

    public void fromXML(String input) {
        this.pojoConfigurer = (POJOConfigurer)this.xStream.fromXML(input);
    }

    @Override
    public ClassConfiguration getClassConfiguration(Class<?> clazz) throws InvalidConfigurationException {
        return this.pojoConfigurer.getClassConfiguration(clazz);
    }

    @Override
    public ConstraintSetConfiguration getConstraintSetConfiguration(String constraintSetId) throws InvalidConfigurationException {
        return this.pojoConfigurer.getConstraintSetConfiguration(constraintSetId);
    }

    public POJOConfigurer getPojoConfigurer() {
        return this.pojoConfigurer;
    }

    public XStream getXStream() {
        return this.xStream;
    }

    public boolean removeCheckInitializationListener(CheckInitializationListener listener) {
        return this.listeners.remove(listener);
    }

    public void setPojoConfigurer(POJOConfigurer pojoConfigurer) {
        this.pojoConfigurer = pojoConfigurer;
    }

    public synchronized String toXML() {
        return this.xStream.toXML((Object)this.pojoConfigurer);
    }

    public synchronized void toXML(OutputStream out) {
        this.xStream.toXML((Object)this.pojoConfigurer, out);
    }

    public synchronized void toXML(Writer out) {
        this.xStream.toXML((Object)this.pojoConfigurer, out);
    }

    protected final class AssertCheckConverter
    implements Converter {
        protected AssertCheckConverter() {
        }

        public boolean canConvert(Class clazz) {
            return clazz.equals(AssertCheck.class);
        }

        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            ConstraintTarget[] appliesTo;
            int n;
            AssertCheck assertCheck = (AssertCheck)value;
            writer.addAttribute("lang", assertCheck.getLang());
            if (!"net.sf.oval.constraint.Assert.violated".equals(assertCheck.getMessage())) {
                writer.addAttribute("message", assertCheck.getMessage());
            }
            if (!"net.sf.oval.constraint.Assert".equals(assertCheck.getErrorCode())) {
                writer.addAttribute("errorCode", assertCheck.getErrorCode());
            }
            writer.addAttribute("severity", Integer.toString(assertCheck.getSeverity()));
            if (assertCheck.getWhen() != null) {
                writer.addAttribute("when", assertCheck.getWhen());
            }
            writer.startNode("expr");
            writer.setValue(assertCheck.getExpr());
            writer.endNode();
            String[] profiles = assertCheck.getProfiles();
            if (profiles != null && profiles.length > 0) {
                writer.startNode("profiles");
                String[] stringArray = profiles;
                n = profiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String profile = stringArray[n2];
                    writer.startNode("string");
                    writer.setValue(profile);
                    writer.endNode();
                    ++n2;
                }
                writer.endNode();
            }
            if ((appliesTo = assertCheck.getAppliesTo()) != null && appliesTo.length > 0) {
                writer.startNode("appliesTo");
                ConstraintTarget[] constraintTargetArray = appliesTo;
                int n3 = appliesTo.length;
                n = 0;
                while (n < n3) {
                    ConstraintTarget ctarget = constraintTargetArray[n];
                    writer.startNode("constraintTarget");
                    writer.setValue(ctarget.name());
                    writer.endNode();
                    ++n;
                }
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            AssertCheck assertCheck = new AssertCheck();
            assertCheck.setLang(reader.getAttribute("lang"));
            assertCheck.setMessage(reader.getAttribute("message"));
            assertCheck.setErrorCode(reader.getAttribute("errorCode"));
            if (reader.getAttribute("severity") != null) {
                assertCheck.setSeverity(Integer.parseInt(reader.getAttribute("severity")));
            }
            assertCheck.setTarget(reader.getAttribute("target"));
            assertCheck.setWhen(reader.getAttribute("when"));
            reader.moveDown();
            assertCheck.setExpr(reader.getValue());
            reader.moveUp();
            if (reader.hasMoreChildren()) {
                reader.moveDown();
                if ("appliesTo".equals(reader.getNodeName())) {
                    ArrayList<ConstraintTarget> targets = new ArrayList<ConstraintTarget>(2);
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        if ("constraintTarget".equals(reader.getNodeName())) {
                            targets.add(ConstraintTarget.valueOf(reader.getValue()));
                        }
                        reader.moveUp();
                    }
                    assertCheck.setAppliesTo(targets.toArray(new ConstraintTarget[targets.size()]));
                } else if ("profiles".equals(reader.getNodeName())) {
                    ArrayList<String> profiles = new ArrayList<String>(4);
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        if ("string".equals(reader.getNodeName())) {
                            profiles.add(reader.getValue());
                        }
                        reader.moveUp();
                    }
                    assertCheck.setProfiles(profiles.toArray(new String[profiles.size()]));
                }
                reader.moveUp();
            }
            for (CheckInitializationListener listener : XMLConfigurer.this.listeners) {
                listener.onCheckInitialized(assertCheck);
            }
            return assertCheck;
        }
    }

    private static final class ListConverter
    extends CollectionConverter {
        protected ListConverter(Mapper mapper) {
            super(mapper);
        }

        public boolean canConvert(Class type) {
            return List.class.isAssignableFrom(type);
        }
    }

    protected static final class XStreamReflectionProvider
    extends Sun14ReflectionProvider {
        protected XStreamReflectionProvider() {
        }

        public Object newInstance(Class type) {
            Object instance = super.newInstance(type);
            if (instance instanceof AbstractAnnotationCheck) {
                Class constraintAnnotation = null;
                ParameterizedType genericSuperclass = (ParameterizedType)type.getGenericSuperclass();
                Object[] objectArray = genericSuperclass.getActualTypeArguments();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Type genericType = objectArray[n2];
                    Class genericClass = (Class)genericType;
                    if (genericClass.isAnnotation() && genericClass.isAnnotationPresent(Constraint.class)) {
                        constraintAnnotation = genericClass;
                        break;
                    }
                    ++n2;
                }
                if (constraintAnnotation != null) {
                    objectArray = constraintAnnotation.getMethods();
                    n = objectArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        Object m = objectArray[n2];
                        Object defaultValue = ((Method)m).getDefaultValue();
                        if (defaultValue != null) {
                            ReflectionUtils.setViaSetter(instance, ((Method)m).getName(), defaultValue);
                        }
                        ++n2;
                    }
                }
            }
            return instance;
        }
    }
}

