/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.configuration.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Version;
import net.sf.oval.Check;
import net.sf.oval.Validator;
import net.sf.oval.collection.CollectionFactory;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.pojo.elements.ClassConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstraintSetConfiguration;
import net.sf.oval.configuration.pojo.elements.FieldConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodReturnValueConfiguration;
import net.sf.oval.constraint.AssertValidCheck;
import net.sf.oval.constraint.LengthCheck;
import net.sf.oval.constraint.NotNullCheck;
import net.sf.oval.constraint.RangeCheck;
import net.sf.oval.internal.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAAnnotationsConfigurer
implements Configurer {
    protected Boolean applyFieldConstraintsToSetters;
    protected Boolean applyFieldConstraintsToConstructors;

    public Boolean getApplyFieldConstraintsToConstructors() {
        return this.applyFieldConstraintsToConstructors;
    }

    @Override
    public ClassConfiguration getClassConfiguration(Class<?> clazz) {
        Annotation annotation;
        int n;
        int n2;
        Annotation[] annotationArray;
        CollectionFactory cf = Validator.getCollectionFactory();
        ClassConfiguration config = new ClassConfiguration();
        config.type = clazz;
        config.applyFieldConstraintsToConstructors = this.applyFieldConstraintsToConstructors;
        config.applyFieldConstraintsToSetters = this.applyFieldConstraintsToSetters;
        List<Check> checks = cf.createList(2);
        AccessibleObject[] accessibleObjectArray = config.type.getDeclaredFields();
        int n3 = accessibleObjectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Field field = accessibleObjectArray[n4];
            annotationArray = field.getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                annotation = annotationArray[n];
                if (annotation instanceof Basic) {
                    this.initializeChecks((Basic)annotation, checks);
                } else if (annotation instanceof Column) {
                    this.initializeChecks((Column)annotation, checks, field);
                } else if (annotation instanceof OneToOne) {
                    this.initializeChecks((OneToOne)annotation, checks);
                } else if (annotation instanceof ManyToOne) {
                    this.initializeChecks((ManyToOne)annotation, checks);
                } else if (annotation instanceof ManyToMany) {
                    this.initializeChecks((ManyToMany)annotation, checks);
                } else if (annotation instanceof OneToMany) {
                    this.initializeChecks((OneToMany)annotation, checks);
                }
                ++n;
            }
            if (checks.size() > 0) {
                if (config.fieldConfigurations == null) {
                    config.fieldConfigurations = cf.createSet(8);
                }
                FieldConfiguration fc = new FieldConfiguration();
                fc.name = field.getName();
                fc.checks = checks;
                checks = cf.createList();
                config.fieldConfigurations.add(fc);
            }
            ++n4;
        }
        accessibleObjectArray = config.type.getDeclaredMethods();
        n3 = accessibleObjectArray.length;
        n4 = 0;
        while (n4 < n3) {
            AccessibleObject method = accessibleObjectArray[n4];
            if (ReflectionUtils.isGetter((Method)method)) {
                annotationArray = method.getAnnotations();
                n2 = annotationArray.length;
                n = 0;
                while (n < n2) {
                    annotation = annotationArray[n];
                    if (annotation instanceof Basic) {
                        this.initializeChecks((Basic)annotation, checks);
                    } else if (annotation instanceof Column) {
                        this.initializeChecks((Column)annotation, checks, method);
                    } else if (annotation instanceof OneToOne) {
                        this.initializeChecks((OneToOne)annotation, checks);
                    } else if (annotation instanceof ManyToOne) {
                        this.initializeChecks((ManyToOne)annotation, checks);
                    } else if (annotation instanceof ManyToMany) {
                        this.initializeChecks((ManyToMany)annotation, checks);
                    } else if (annotation instanceof OneToMany) {
                        this.initializeChecks((OneToMany)annotation, checks);
                    }
                    ++n;
                }
                if (checks.size() > 0) {
                    if (config.methodConfigurations == null) {
                        config.methodConfigurations = cf.createSet(2);
                    }
                    MethodConfiguration mc = new MethodConfiguration();
                    mc.name = ((Method)method).getName();
                    mc.isInvariant = true;
                    mc.returnValueConfiguration = new MethodReturnValueConfiguration();
                    mc.returnValueConfiguration.checks = checks;
                    checks = cf.createList();
                    config.methodConfigurations.add(mc);
                }
            }
            ++n4;
        }
        return config;
    }

    @Override
    public ConstraintSetConfiguration getConstraintSetConfiguration(String constraintSetId) {
        return null;
    }

    protected void initializeChecks(Basic annotation, Collection<Check> checks) {
        assert (annotation != null);
        assert (checks != null);
        if (!annotation.optional()) {
            checks.add(new NotNullCheck());
        }
    }

    protected void initializeChecks(Column annotation, Collection<Check> checks, AccessibleObject fieldOrMethod) {
        assert (annotation != null);
        assert (checks != null);
        if (!(annotation.nullable() || fieldOrMethod.isAnnotationPresent(GeneratedValue.class) || fieldOrMethod.isAnnotationPresent(Version.class))) {
            checks.add(new NotNullCheck());
        }
        if (!fieldOrMethod.isAnnotationPresent(Lob.class)) {
            LengthCheck lengthCheck = new LengthCheck();
            lengthCheck.setMax(annotation.length());
            checks.add(lengthCheck);
        }
        if (annotation.precision() > 0 && Number.class.isAssignableFrom(fieldOrMethod instanceof Field ? ((Field)fieldOrMethod).getType() : ((Method)fieldOrMethod).getReturnType())) {
            RangeCheck rangeCheck = new RangeCheck();
            rangeCheck.setMax(Math.pow(10.0, annotation.precision() - annotation.scale()) - Math.pow(0.1, annotation.scale()));
            rangeCheck.setMin(-1.0 * rangeCheck.getMax());
            checks.add(rangeCheck);
        }
    }

    protected void initializeChecks(ManyToMany annotation, Collection<Check> checks) {
        assert (annotation != null);
        assert (checks != null);
        checks.add(new AssertValidCheck());
    }

    protected void initializeChecks(ManyToOne annotation, Collection<Check> checks) {
        assert (annotation != null);
        assert (checks != null);
        if (!annotation.optional()) {
            checks.add(new NotNullCheck());
        }
        checks.add(new AssertValidCheck());
    }

    protected void initializeChecks(OneToMany annotation, Collection<Check> checks) {
        assert (annotation != null);
        assert (checks != null);
        checks.add(new AssertValidCheck());
    }

    protected void initializeChecks(OneToOne annotation, Collection<Check> checks) {
        assert (annotation != null);
        assert (checks != null);
        if (!annotation.optional()) {
            checks.add(new NotNullCheck());
        }
        checks.add(new AssertValidCheck());
    }

    public Boolean isApplyFieldConstraintsToSetter() {
        return this.applyFieldConstraintsToSetters;
    }

    public void setApplyFieldConstraintsToConstructors(Boolean applyFieldConstraintsToConstructors) {
        this.applyFieldConstraintsToConstructors = applyFieldConstraintsToConstructors;
    }

    public void setApplyFieldConstraintsToSetters(Boolean applyFieldConstraintsToSetters) {
        this.applyFieldConstraintsToSetters = applyFieldConstraintsToSetters;
    }
}

