/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.logging;

import net.sf.oval.internal.util.Assert;
import net.sf.oval.logging.Logger;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class LoggerL4JImpl
implements Logger {
    private static final String WRAPPER = "net.sf.oval.logging";
    private final org.apache.log4j.Logger log4jLogger;

    public LoggerL4JImpl(String name) throws IllegalArgumentException {
        Assert.notNull("name", name);
        this.log4jLogger = org.apache.log4j.Logger.getLogger((String)name);
    }

    public void debug(String msg) {
        this.log4jLogger.log(WRAPPER, (Priority)Level.DEBUG, (Object)msg, null);
    }

    public void debug(String msg, Throwable t) {
        this.log4jLogger.log(WRAPPER, (Priority)Level.DEBUG, (Object)msg, t);
    }

    public void error(String msg) {
        this.log4jLogger.log(WRAPPER, (Priority)Level.ERROR, (Object)msg, null);
    }

    public void error(String msg, Throwable t) {
        this.log4jLogger.log(WRAPPER, (Priority)Level.ERROR, (Object)msg, t);
    }

    public void info(String msg) {
        this.log4jLogger.log(WRAPPER, (Priority)Level.INFO, (Object)msg, null);
    }

    public void info(String msg, Throwable t) {
        this.log4jLogger.log(WRAPPER, (Priority)Level.INFO, (Object)msg, t);
    }

    public boolean isDebug() {
        return this.log4jLogger.isDebugEnabled();
    }

    public boolean isError() {
        return this.log4jLogger.isEnabledFor((Priority)Level.ERROR);
    }

    public boolean isInfo() {
        return this.log4jLogger.isInfoEnabled();
    }

    public boolean isTrace() {
        return this.log4jLogger.isTraceEnabled();
    }

    public boolean isWarn() {
        return this.log4jLogger.isEnabledFor((Priority)Level.WARN);
    }

    public void trace(String msg) {
        this.log4jLogger.log(WRAPPER, (Priority)Level.TRACE, (Object)msg, null);
    }

    public void trace(String msg, Throwable t) {
        this.log4jLogger.log(WRAPPER, (Priority)Level.TRACE, (Object)msg, t);
    }

    public void warn(String msg) {
        this.log4jLogger.log(WRAPPER, (Priority)Level.WARN, (Object)msg, null);
    }

    public void warn(String msg, Throwable t) {
        this.log4jLogger.log(WRAPPER, (Priority)Level.WARN, (Object)msg, t);
    }
}

