/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.oval.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentitySet<E>
implements Set<E>,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient Map<Integer, E> map;

    public IdentitySet() {
        this.map = Validator.getCollectionFactory().createMap();
    }

    public IdentitySet(int initialCapacity) {
        this.map = Validator.getCollectionFactory().createMap(initialCapacity);
    }

    @Override
    public boolean add(E o) {
        int hash = System.identityHashCode(o);
        return this.map.put(hash, o) == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        int count = 0;
        for (E e : c) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count > 0;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        int hash = System.identityHashCode(o);
        return this.map.containsKey(hash);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.values().iterator();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        int size = ois.readInt();
        this.map = Validator.getCollectionFactory().createMap(size);
        int i = 0;
        while (i < size) {
            Object o = ois.readObject();
            int hash = System.identityHashCode(o);
            this.map.put(hash, o);
            ++i;
        }
    }

    @Override
    public boolean remove(Object o) {
        int hash = System.identityHashCode(o);
        return this.map.remove(hash) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object e : c) {
            if (!this.remove(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Object[] toArray() {
        return this.map.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map.values().toArray(a);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeInt(this.map.size());
        for (E e : this.map.values()) {
            oos.writeObject(e);
        }
    }
}

