/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.guard;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sf.oval.Check;
import net.sf.oval.CheckExclusion;
import net.sf.oval.ConstraintViolation;
import net.sf.oval.Validator;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.context.ConstructorParameterContext;
import net.sf.oval.context.MethodEntryContext;
import net.sf.oval.context.MethodExitContext;
import net.sf.oval.context.MethodParameterContext;
import net.sf.oval.context.MethodReturnValueContext;
import net.sf.oval.context.OValContext;
import net.sf.oval.exception.ConstraintsViolatedException;
import net.sf.oval.exception.InvalidConfigurationException;
import net.sf.oval.exception.OValException;
import net.sf.oval.exception.ValidationFailedException;
import net.sf.oval.expression.ExpressionLanguage;
import net.sf.oval.guard.ConstraintsViolatedListener;
import net.sf.oval.guard.ParameterNameResolver;
import net.sf.oval.guard.PostCheck;
import net.sf.oval.guard.PreCheck;
import net.sf.oval.guard.ProbeModeListener;
import net.sf.oval.internal.ClassChecks;
import net.sf.oval.internal.ContextCache;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.ParameterChecks;
import net.sf.oval.internal.util.ArrayUtils;
import net.sf.oval.internal.util.Assert;
import net.sf.oval.internal.util.IdentitySet;
import net.sf.oval.internal.util.Invocable;
import net.sf.oval.internal.util.LinkedSet;
import net.sf.oval.internal.util.ReflectionUtils;
import net.sf.oval.internal.util.ThreadLocalList;
import net.sf.oval.internal.util.ThreadLocalWeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Guard
extends Validator {
    protected static final GuardMethodPreResult DO_NOT_PROCEED = new GuardMethodPreResult(null, null, null, null, false, null, null);
    private static final Log LOG = Log.getLog(Guard.class);
    private static final ThreadLocalList<String> currentlyCheckingMethodReturnValues = new ThreadLocalList();
    private static final ThreadLocalList<String> currentlyCheckingPreConditions = new ThreadLocalList();
    private static final ThreadLocalList<String> currentlyCheckingPostConditions = new ThreadLocalList();
    private boolean isActivated = true;
    private boolean isInvariantsEnabled = true;
    private boolean isPreConditionsEnabled = true;
    private boolean isPostConditionsEnabled = true;
    private boolean isListenersFeatureUsed = false;
    private boolean isProbeModeFeatureUsed = false;
    private final Set<ConstraintsViolatedListener> listeners = new IdentitySet<ConstraintsViolatedListener>(4);
    private final Map<Class<?>, Set<ConstraintsViolatedListener>> listenersByClass = new WeakHashMap(4);
    private final Map<Object, Set<ConstraintsViolatedListener>> listenersByObject = new WeakHashMap<Object, Set<ConstraintsViolatedListener>>(4);
    private final ThreadLocalWeakHashMap<Object, ProbeModeListener> objectsInProbeMode = new ThreadLocalWeakHashMap();

    public Guard() {
    }

    public Guard(Collection<Configurer> configurers) {
        super(configurers);
    }

    public Guard(Configurer ... configurers) {
        super(configurers);
    }

    private List<CheckExclusion> _getActiveExclusions(Set<CheckExclusion> exclusions) {
        LinkedList<CheckExclusion> activeExclusions = new LinkedList<CheckExclusion>(exclusions);
        Iterator it = activeExclusions.iterator();
        while (it.hasNext()) {
            CheckExclusion exclusion = (CheckExclusion)it.next();
            if (this.isAnyProfileEnabled(exclusion.getProfiles(), null)) continue;
            it.remove();
        }
        return activeExclusions.size() == 0 ? null : activeExclusions;
    }

    private void _validateParameterChecks(ParameterChecks checks, Object validatedObject, Object valueToValidate, OValContext context, List<ConstraintViolation> violations) {
        List<CheckExclusion> activeExclusions = checks.hasExclusions() ? this._getActiveExclusions(checks.checkExclusions) : null;
        for (Check check : checks.checks) {
            boolean skip = false;
            if (activeExclusions != null) {
                for (CheckExclusion exclusion : activeExclusions) {
                    if (!exclusion.isActive(validatedObject, valueToValidate, this) || !exclusion.isCheckExcluded(check, validatedObject, valueToValidate, context, this)) continue;
                    skip = true;
                }
            }
            if (skip) continue;
            this.checkConstraint(violations, check, validatedObject, valueToValidate, context, null, false);
        }
    }

    public void addCheckExclusions(Constructor<?> ctor, int paramIndex, CheckExclusion ... exclusions) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.notNull("ctor", ctor);
        Assert.notEmpty("exclusions", exclusions);
        this.getClassChecks(ctor.getDeclaringClass()).addConstructorParameterCheckExclusions(ctor, paramIndex, exclusions);
    }

    public void addCheckExclusions(Method method, int paramIndex, CheckExclusion ... exclusions) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.notNull("method", method);
        Assert.notEmpty("exclusions", exclusions);
        this.getClassChecks(method.getDeclaringClass()).addMethodParameterCheckExclusions(method, paramIndex, exclusions);
    }

    public void addChecks(Constructor<?> ctor, int paramIndex, Check ... checks) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.notNull("ctor", ctor);
        Assert.notEmpty("checks", checks);
        this.getClassChecks(ctor.getDeclaringClass()).addConstructorParameterChecks(ctor, paramIndex, checks);
    }

    @Override
    public void addChecks(Method method, Check ... checks) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.notNull("method", method);
        Assert.notEmpty("checks", checks);
        this.getClassChecks(method.getDeclaringClass()).addMethodReturnValueChecks(method, null, checks);
    }

    public void addChecks(Method method, int paramIndex, Check ... checks) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.notNull("method", method);
        Assert.notEmpty("checks", checks);
        this.getClassChecks(method.getDeclaringClass()).addMethodParameterChecks(method, paramIndex, checks);
    }

    public void addChecks(Method method, PostCheck ... checks) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.notNull("method", method);
        Assert.notEmpty("checks", checks);
        this.getClassChecks(method.getDeclaringClass()).addMethodPostChecks(method, checks);
    }

    public void addChecks(Method method, PreCheck ... checks) throws IllegalArgumentException, InvalidConfigurationException {
        Assert.notNull("method", method);
        Assert.notEmpty("checks", checks);
        this.getClassChecks(method.getDeclaringClass()).addMethodPreChecks(method, checks);
    }

    public boolean addListener(ConstraintsViolatedListener listener) throws IllegalArgumentException {
        Assert.notNull("listener", listener);
        this.isListenersFeatureUsed = true;
        return this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(ConstraintsViolatedListener listener, Class<?> guardedClass) throws IllegalArgumentException {
        Assert.notNull("listener", listener);
        Assert.notNull("guardedClass", guardedClass);
        this.isListenersFeatureUsed = true;
        Map<Class<?>, Set<ConstraintsViolatedListener>> map = this.listenersByClass;
        synchronized (map) {
            Set<ConstraintsViolatedListener> classListeners = this.listenersByClass.get(guardedClass);
            if (classListeners == null) {
                classListeners = Guard.getCollectionFactory().createSet();
                this.listenersByClass.put(guardedClass, classListeners);
            }
            return classListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(ConstraintsViolatedListener listener, Object guardedObject) {
        Assert.notNull("listener", listener);
        Assert.notNull("guardedObject", guardedObject);
        this.isListenersFeatureUsed = true;
        Map<Object, Set<ConstraintsViolatedListener>> map = this.listenersByObject;
        synchronized (map) {
            Set<ConstraintsViolatedListener> objectListeners = this.listenersByObject.get(guardedObject);
            if (objectListeners == null) {
                objectListeners = Guard.getCollectionFactory().createSet(2);
                this.listenersByObject.put(guardedObject, objectListeners);
            }
            return objectListeners.add(listener);
        }
    }

    protected Map<PostCheck, Object> calculateMethodPostOldValues(Object validatedObject, Method method, Object[] args) throws ValidationFailedException {
        Set<PostCheck> postChecks;
        block7: {
            ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
            postChecks = cc.checksForMethodsPostExcecution.get(method);
            if (postChecks != null) break block7;
            return null;
        }
        try {
            String[] parameterNames = this.parameterNameResolver.getParameterNames(method);
            boolean hasParameters = parameterNames.length > 0;
            Map<PostCheck, Object> oldValues = Guard.getCollectionFactory().createMap(postChecks.size());
            for (PostCheck check : postChecks) {
                if (!this.isAnyProfileEnabled(check.getProfiles(), null) || check.getOld() == null || check.getOld().length() <= 0) continue;
                ExpressionLanguage eng = this.getExpressionLanguage(check.getLanguage());
                Map values = Guard.getCollectionFactory().createMap();
                values.put("_this", validatedObject);
                if (hasParameters) {
                    values.put("_args", args);
                    int i = 0;
                    while (i < args.length) {
                        values.put(parameterNames[i], args[i]);
                        ++i;
                    }
                } else {
                    values.put("_args", ArrayUtils.EMPTY_OBJECT_ARRAY);
                }
                oldValues.put(check, eng.evaluate(check.getOld(), values));
            }
            return oldValues;
        }
        catch (OValException ex) {
            throw new ValidationFailedException("Method post conditions validation failed. Method: " + method + " Validated object: " + validatedObject, ex);
        }
    }

    public ProbeModeListener disableProbeMode(Object guardedObject) throws IllegalArgumentException, IllegalStateException {
        Assert.notNull("guardedObject", guardedObject);
        return (ProbeModeListener)((WeakHashMap)this.objectsInProbeMode.get()).remove(guardedObject);
    }

    public void enableProbeMode(Object guardedObject) throws IllegalArgumentException, IllegalStateException {
        Assert.notNull("guardedObject", guardedObject);
        if (guardedObject instanceof Class) {
            LOG.warn("Enabling probe mode for a class looks like a programming error. Class: {1}", guardedObject);
        }
        this.isProbeModeFeatureUsed = true;
        if (((WeakHashMap)this.objectsInProbeMode.get()).get(guardedObject) != null) {
            throw new IllegalStateException("The object is already in probe mode.");
        }
        ((WeakHashMap)this.objectsInProbeMode.get()).put(guardedObject, new ProbeModeListener(guardedObject));
    }

    public Check[] getChecks(Method method, int paramIndex) throws InvalidConfigurationException {
        Assert.notNull("method", method);
        ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
        Map<Integer, ParameterChecks> checks = cc.checksForMethodParameters.get(method);
        if (checks == null) {
            return null;
        }
        ParameterChecks paramChecks = checks.get(paramIndex);
        return paramChecks == null ? null : paramChecks.checks.toArray(new Check[checks.size()]);
    }

    public PostCheck[] getChecksPost(Method method) throws IllegalArgumentException {
        Assert.notNull("method", method);
        ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
        Set<PostCheck> checks = cc.checksForMethodsPostExcecution.get(method);
        return checks == null ? null : checks.toArray(new PostCheck[checks.size()]);
    }

    public PreCheck[] getChecksPre(Method method) throws IllegalArgumentException {
        Assert.notNull("method", method);
        ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
        Set<PreCheck> checks = cc.checksForMethodsPreExecution.get(method);
        return checks == null ? null : checks.toArray(new PreCheck[checks.size()]);
    }

    public ParameterNameResolver getParameterNameResolver() {
        return this.parameterNameResolver;
    }

    protected void guardConstructorPost(Object guardedObject, Constructor<?> ctor, Object[] args) throws ConstraintsViolatedException, ValidationFailedException {
        if (!this.isActivated) {
            return;
        }
        ClassChecks cc = this.getClassChecks(ctor.getDeclaringClass());
        if (this.isInvariantsEnabled && cc.isCheckInvariants || cc.methodsWithCheckInvariantsPost.contains(ctor)) {
            List<ConstraintViolation> violations = Guard.getCollectionFactory().createList();
            try {
                this.validateInvariants(guardedObject, violations, null);
            }
            catch (ValidationFailedException ex) {
                throw this.translateException(ex);
            }
            if (violations.size() > 0) {
                ConstraintsViolatedException violationException = new ConstraintsViolatedException(violations);
                if (this.isListenersFeatureUsed) {
                    this.notifyListeners(guardedObject, violationException);
                }
                throw this.translateException(violationException);
            }
        }
    }

    protected void guardConstructorPre(Object guardedObject, Constructor<?> ctor, Object[] args) throws ConstraintsViolatedException, ValidationFailedException {
        if (!this.isActivated) {
            return;
        }
        if (this.isPreConditionsEnabled && args.length > 0) {
            List<ConstraintViolation> violations;
            try {
                violations = this.validateConstructorParameters(guardedObject, ctor, args);
            }
            catch (ValidationFailedException ex) {
                throw this.translateException(ex);
            }
            if (violations != null) {
                ConstraintsViolatedException violationException = new ConstraintsViolatedException(violations);
                if (this.isListenersFeatureUsed) {
                    this.notifyListeners(guardedObject, violationException);
                }
                throw this.translateException(violationException);
            }
        }
    }

    protected Object guardMethod(Object guardedObject, Method method, Object[] args, Invocable invocable) throws Throwable {
        ProbeModeListener pml;
        if (!this.isActivated) {
            return invocable.invoke();
        }
        ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
        boolean checkInvariants = this.isInvariantsEnabled && cc.isCheckInvariants && !ReflectionUtils.isPrivate(method) && !ReflectionUtils.isProtected(method);
        List<ConstraintViolation> violations = Guard.getCollectionFactory().createList();
        if (guardedObject == null && ReflectionUtils.isStatic(method)) {
            guardedObject = method.getDeclaringClass();
        }
        try {
            if (checkInvariants || cc.methodsWithCheckInvariantsPre.contains(method)) {
                this.validateInvariants(guardedObject, violations, null);
            }
            if (this.isPreConditionsEnabled) {
                if (violations.size() == 0 && args.length > 0) {
                    this.validateMethodParameters(guardedObject, method, args, violations);
                }
                if (violations.size() == 0) {
                    this.validateMethodPre(guardedObject, method, args, violations);
                }
            }
        }
        catch (ValidationFailedException ex) {
            throw this.translateException(ex);
        }
        ProbeModeListener probeModeListener = pml = this.isProbeModeFeatureUsed ? (ProbeModeListener)((WeakHashMap)this.objectsInProbeMode.get()).get(guardedObject) : null;
        if (pml != null) {
            pml.onMethodCall(method, args);
        }
        if (violations.size() > 0) {
            ConstraintsViolatedException violationException = new ConstraintsViolatedException(violations);
            if (this.isListenersFeatureUsed) {
                this.notifyListeners(guardedObject, violationException);
            }
            if (pml != null) {
                pml.onConstraintsViolatedException(violationException);
                return null;
            }
            throw this.translateException(violationException);
        }
        if (pml != null) {
            return null;
        }
        Map<PostCheck, Object> postCheckOldValues = this.calculateMethodPostOldValues(guardedObject, method, args);
        Object returnValue = invocable.invoke();
        try {
            if (checkInvariants || cc.methodsWithCheckInvariantsPost.contains(method)) {
                this.validateInvariants(guardedObject, violations, null);
            }
            if (this.isPostConditionsEnabled) {
                if (violations.size() == 0) {
                    this.validateMethodReturnValue(guardedObject, method, returnValue, violations);
                }
                if (violations.size() == 0) {
                    this.validateMethodPost(guardedObject, method, args, returnValue, postCheckOldValues, violations);
                }
            }
        }
        catch (ValidationFailedException ex) {
            throw this.translateException(ex);
        }
        if (violations.size() > 0) {
            ConstraintsViolatedException violationException = new ConstraintsViolatedException(violations);
            if (this.isListenersFeatureUsed) {
                this.notifyListeners(guardedObject, violationException);
            }
            throw this.translateException(violationException);
        }
        return returnValue;
    }

    protected void guardMethodPost(Object returnValue, GuardMethodPreResult preResult) throws ConstraintsViolatedException, ValidationFailedException {
        if (!this.isActivated) {
            return;
        }
        try {
            if (preResult.checkInvariants || preResult.cc.methodsWithCheckInvariantsPost.contains(preResult.method)) {
                this.validateInvariants(preResult.guardedObject, preResult.violations, null);
            }
            if (this.isPostConditionsEnabled) {
                if (preResult.violations.size() == 0) {
                    this.validateMethodReturnValue(preResult.guardedObject, preResult.method, returnValue, preResult.violations);
                }
                if (preResult.violations.size() == 0) {
                    this.validateMethodPost(preResult.guardedObject, preResult.method, preResult.args, returnValue, preResult.postCheckOldValues, preResult.violations);
                }
            }
        }
        catch (ValidationFailedException ex) {
            throw this.translateException(ex);
        }
        if (preResult.violations.size() > 0) {
            ConstraintsViolatedException violationException = new ConstraintsViolatedException(preResult.violations);
            if (this.isListenersFeatureUsed) {
                this.notifyListeners(preResult.guardedObject, violationException);
            }
            throw this.translateException(violationException);
        }
    }

    protected GuardMethodPreResult guardMethodPre(Object guardedObject, Method method, Object[] args) throws ConstraintsViolatedException, ValidationFailedException {
        ProbeModeListener pml;
        if (!this.isActivated) {
            return null;
        }
        ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
        boolean checkInvariants = this.isInvariantsEnabled && cc.isCheckInvariants && !ReflectionUtils.isPrivate(method) && !ReflectionUtils.isProtected(method);
        List<ConstraintViolation> violations = Guard.getCollectionFactory().createList();
        if (guardedObject == null && ReflectionUtils.isStatic(method)) {
            guardedObject = method.getDeclaringClass();
        }
        try {
            if (checkInvariants || cc.methodsWithCheckInvariantsPre.contains(method)) {
                this.validateInvariants(guardedObject, violations, null);
            }
            if (this.isPreConditionsEnabled) {
                if (violations.size() == 0 && args.length > 0) {
                    this.validateMethodParameters(guardedObject, method, args, violations);
                }
                if (violations.size() == 0) {
                    this.validateMethodPre(guardedObject, method, args, violations);
                }
            }
        }
        catch (ValidationFailedException ex) {
            throw this.translateException(ex);
        }
        ProbeModeListener probeModeListener = pml = this.isProbeModeFeatureUsed ? (ProbeModeListener)((WeakHashMap)this.objectsInProbeMode.get()).get(guardedObject) : null;
        if (pml != null) {
            pml.onMethodCall(method, args);
        }
        if (violations.size() > 0) {
            ConstraintsViolatedException violationException = new ConstraintsViolatedException(violations);
            if (this.isListenersFeatureUsed) {
                this.notifyListeners(guardedObject, violationException);
            }
            if (pml != null) {
                pml.onConstraintsViolatedException(violationException);
                return DO_NOT_PROCEED;
            }
            throw this.translateException(violationException);
        }
        if (pml != null) {
            return DO_NOT_PROCEED;
        }
        Map<PostCheck, Object> postCheckOldValues = this.calculateMethodPostOldValues(guardedObject, method, args);
        return new GuardMethodPreResult(guardedObject, method, args, cc, checkInvariants, postCheckOldValues, violations);
    }

    public boolean hasListener(ConstraintsViolatedListener listener) throws IllegalArgumentException {
        Assert.notNull("listener", listener);
        return this.listeners.contains(listener);
    }

    public boolean hasListener(ConstraintsViolatedListener listener, Class<?> guardedClass) throws IllegalArgumentException {
        Assert.notNull("listener", listener);
        Assert.notNull("guardedClass", guardedClass);
        Set<ConstraintsViolatedListener> classListeners = this.listenersByClass.get(guardedClass);
        if (classListeners == null) {
            return false;
        }
        return classListeners.contains(listener);
    }

    public boolean hasListener(ConstraintsViolatedListener listener, Object guardedObject) throws IllegalArgumentException {
        Assert.notNull("listener", listener);
        Assert.notNull("guardedObject", guardedObject);
        Set<ConstraintsViolatedListener> objectListeners = this.listenersByObject.get(guardedObject);
        if (objectListeners == null) {
            return false;
        }
        return objectListeners.contains(listener);
    }

    public boolean isActivated() {
        return this.isActivated;
    }

    public boolean isInProbeMode(Object guardedObject) {
        if (guardedObject == null) {
            return false;
        }
        return ((WeakHashMap)this.objectsInProbeMode.get()).containsKey(guardedObject);
    }

    public boolean isInvariantsEnabled() {
        return this.isInvariantsEnabled;
    }

    public boolean isInvariantsEnabled(Class<?> guardedClass) {
        return this.getClassChecks(guardedClass).isCheckInvariants;
    }

    public boolean isPostConditionsEnabled() {
        return this.isPostConditionsEnabled;
    }

    public boolean isPreConditionsEnabled() {
        return this.isPreConditionsEnabled;
    }

    protected void notifyListeners(Object guardedObject, ConstraintsViolatedException ex) {
        Set<ConstraintsViolatedListener> classListeners;
        if (guardedObject == null) {
            return;
        }
        LinkedSet<ConstraintsViolatedListener> listenersToNotify = new LinkedSet<ConstraintsViolatedListener>();
        Set<ConstraintsViolatedListener> objectListeners = this.listenersByObject.get(guardedObject);
        if (objectListeners != null) {
            listenersToNotify.addAll(objectListeners);
        }
        if ((classListeners = this.listenersByClass.get(guardedObject.getClass())) != null) {
            listenersToNotify.addAll(classListeners);
        }
        Class<?>[] classArray = guardedObject.getClass().getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> interfaze = classArray[n2];
            Set<ConstraintsViolatedListener> interfaceListeners = this.listenersByClass.get(interfaze);
            if (interfaceListeners != null) {
                listenersToNotify.addAll(interfaceListeners);
            }
            ++n2;
        }
        listenersToNotify.addAll(this.listeners);
        for (ConstraintsViolatedListener listener : listenersToNotify) {
            try {
                listener.onConstraintsViolatedException(ex);
            }
            catch (RuntimeException rex) {
                LOG.warn("Notifying listener '{1}' failed.", (Object)listener, rex);
            }
        }
    }

    public void removeCheckExclusions(Constructor<?> ctor, int paramIndex, CheckExclusion ... exclusions) throws InvalidConfigurationException {
        Assert.notNull("ctor", ctor);
        Assert.notEmpty("exclusions", exclusions);
        this.getClassChecks(ctor.getDeclaringClass()).removeConstructorParameterCheckExclusions(ctor, paramIndex, exclusions);
    }

    public void removeCheckExclusions(Method method, int paramIndex, CheckExclusion ... exclusions) throws InvalidConfigurationException {
        Assert.notNull("method", method);
        Assert.notEmpty("exclusions", exclusions);
        this.getClassChecks(method.getDeclaringClass()).removeMethodParameterCheckExclusions(method, paramIndex, exclusions);
    }

    public void removeChecks(Constructor<?> ctor, int paramIndex, Check ... checks) throws InvalidConfigurationException {
        Assert.notNull("ctor", ctor);
        Assert.notEmpty("checks", checks);
        this.getClassChecks(ctor.getDeclaringClass()).removeConstructorParameterChecks(ctor, paramIndex, checks);
    }

    public void removeChecks(Method method, int paramIndex, Check ... checks) throws InvalidConfigurationException {
        Assert.notNull("method", method);
        Assert.notEmpty("checks", checks);
        this.getClassChecks(method.getDeclaringClass()).removeMethodParameterChecks(method, paramIndex, checks);
    }

    public void removeChecks(Method method, PostCheck ... checks) throws InvalidConfigurationException {
        Assert.notNull("method", method);
        Assert.notEmpty("checks", checks);
        this.getClassChecks(method.getDeclaringClass()).removeMethodPostChecks(method, checks);
    }

    public void removeChecks(Method method, PreCheck ... checks) throws InvalidConfigurationException {
        Assert.notNull("method", method);
        Assert.notEmpty("checks", checks);
        this.getClassChecks(method.getDeclaringClass()).removeMethodPreChecks(method, checks);
    }

    public boolean removeListener(ConstraintsViolatedListener listener) throws IllegalArgumentException {
        Assert.notNull("listener", listener);
        return this.listeners.remove(listener);
    }

    public boolean removeListener(ConstraintsViolatedListener listener, Class<?> guardedClass) throws IllegalArgumentException {
        Assert.notNull("listener", listener);
        Assert.notNull("guardedClass", guardedClass);
        Set<ConstraintsViolatedListener> currentListeners = this.listenersByClass.get(guardedClass);
        return currentListeners == null ? false : currentListeners.remove(listener);
    }

    public boolean removeListener(ConstraintsViolatedListener listener, Object guardedObject) throws IllegalArgumentException {
        Assert.notNull("listener", listener);
        Assert.notNull("guardedObject", guardedObject);
        Set<ConstraintsViolatedListener> currentListeners = this.listenersByObject.get(guardedObject);
        return currentListeners == null ? false : currentListeners.remove(listener);
    }

    public void setActivated(boolean isActivated) {
        this.isActivated = isActivated;
    }

    public void setInvariantsEnabled(boolean isEnabled) {
        this.isInvariantsEnabled = isEnabled;
    }

    public void setInvariantsEnabled(Class<?> guardedClass, boolean isEnabled) {
        this.getClassChecks(guardedClass).isCheckInvariants = isEnabled;
    }

    public void setParameterNameResolver(ParameterNameResolver parameterNameResolver) throws IllegalArgumentException {
        Assert.notNull("parameterNameResolver", parameterNameResolver);
        this.parameterNameResolver.setDelegate(parameterNameResolver);
    }

    public void setPostConditionsEnabled(boolean isEnabled) {
        this.isPostConditionsEnabled = isEnabled;
    }

    public void setPreConditionsEnabled(boolean isEnabled) {
        this.isPreConditionsEnabled = isEnabled;
    }

    protected List<ConstraintViolation> validateConstructorParameters(Object validatedObject, Constructor<?> constructor, Object[] argsToValidate) throws ValidationFailedException {
        ((LinkedList)this.currentlyValidatedObjects.get()).add(new IdentitySet(4));
        try {
            ClassChecks cc = this.getClassChecks(constructor.getDeclaringClass());
            Map<Integer, ParameterChecks> parameterChecks = cc.checksForConstructorParameters.get(constructor);
            if (parameterChecks == null) {
                return null;
            }
            List<ConstraintViolation> violations = Guard.getCollectionFactory().createList();
            String[] parameterNames = this.parameterNameResolver.getParameterNames(constructor);
            int i = 0;
            while (i < argsToValidate.length) {
                ParameterChecks checks = parameterChecks.get(i);
                if (checks != null && checks.hasChecks()) {
                    Object valueToValidate = argsToValidate[i];
                    ConstructorParameterContext context = new ConstructorParameterContext(constructor, i, parameterNames[i]);
                    this._validateParameterChecks(checks, validatedObject, valueToValidate, context, violations);
                }
                ++i;
            }
            List<ConstraintViolation> list = violations.size() == 0 ? null : violations;
            return list;
        }
        catch (OValException ex) {
            throw new ValidationFailedException("Validation of constructor parameters failed. Constructor: " + constructor + " Validated object: " + validatedObject.getClass().getName() + "@" + Integer.toHexString(validatedObject.hashCode()), ex);
        }
        finally {
            ((LinkedList)this.currentlyValidatedObjects.get()).removeLast();
        }
    }

    @Override
    protected void validateInvariants(Object guardedObject, List<ConstraintViolation> violations, String[] profiles) throws IllegalArgumentException, ValidationFailedException {
        ((LinkedList)this.currentlyValidatedObjects.get()).add(new IdentitySet(4));
        try {
            super.validateInvariants(guardedObject, violations, profiles);
        }
        finally {
            ((LinkedList)this.currentlyValidatedObjects.get()).removeLast();
        }
    }

    protected void validateMethodParameters(Object validatedObject, Method method, Object[] args, List<ConstraintViolation> violations) throws ValidationFailedException {
        ((LinkedList)this.currentlyValidatedObjects.get()).add(new IdentitySet(4));
        try {
            ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
            Map<Integer, ParameterChecks> parameterChecks = cc.checksForMethodParameters.get(method);
            if (parameterChecks == null) {
                return;
            }
            try {
                String[] parameterNames = this.parameterNameResolver.getParameterNames(method);
                if (parameterNames.length > 0) {
                    int i = 0;
                    while (i < args.length) {
                        ParameterChecks checks = parameterChecks.get(i);
                        if (checks != null && checks.checks.size() > 0) {
                            Object valueToValidate = args[i];
                            MethodParameterContext context = new MethodParameterContext(method, i, parameterNames[i]);
                            this._validateParameterChecks(checks, validatedObject, valueToValidate, context, violations);
                        }
                        ++i;
                    }
                }
            }
            catch (OValException ex) {
                throw new ValidationFailedException("Method pre conditions validation failed. Method: " + method + " Validated object: " + validatedObject, ex);
            }
        }
        finally {
            ((LinkedList)this.currentlyValidatedObjects.get()).removeLast();
        }
    }

    protected void validateMethodPost(Object validatedObject, Method method, Object[] args, Object returnValue, Map<PostCheck, Object> oldValues, List<ConstraintViolation> violations) throws ValidationFailedException {
        String key = String.valueOf(System.identityHashCode(validatedObject)) + " " + System.identityHashCode(method);
        if (((List)currentlyCheckingPostConditions.get()).contains(key)) {
            return;
        }
        ((List)currentlyCheckingPostConditions.get()).add(key);
        try {
            ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
            Set<PostCheck> postChecks = cc.checksForMethodsPostExcecution.get(method);
            if (postChecks == null) {
                return;
            }
            try {
                String[] parameterNames = this.parameterNameResolver.getParameterNames(method);
                boolean hasParameters = parameterNames.length > 0;
                MethodExitContext context = ContextCache.getMethodExitContext(method);
                for (PostCheck check : postChecks) {
                    if (!this.isAnyProfileEnabled(check.getProfiles(), null)) continue;
                    ExpressionLanguage eng = this.getExpressionLanguage(check.getLanguage());
                    Map values = Guard.getCollectionFactory().createMap();
                    values.put("_this", validatedObject);
                    values.put("_returns", returnValue);
                    values.put("_old", oldValues.get(check));
                    if (hasParameters) {
                        values.put("_args", args);
                        int i = 0;
                        while (i < args.length) {
                            values.put(parameterNames[i], args[i]);
                            ++i;
                        }
                    } else {
                        values.put("_args", ArrayUtils.EMPTY_OBJECT_ARRAY);
                    }
                    if (eng.evaluateAsBoolean(check.getExpression(), values)) continue;
                    Map messageVariables = Guard.getCollectionFactory().createMap(2);
                    messageVariables.put("expression", check.getExpression());
                    String errorMessage = this.renderMessage(context, null, check.getMessage(), messageVariables);
                    violations.add(new ConstraintViolation(check, errorMessage, validatedObject, null, context));
                }
            }
            catch (OValException ex) {
                throw new ValidationFailedException("Method post conditions validation failed. Method: " + method + " Validated object: " + validatedObject, ex);
            }
        }
        finally {
            ((List)currentlyCheckingPreConditions.get()).remove(key);
        }
    }

    protected void validateMethodPre(Object validatedObject, Method method, Object[] args, List<ConstraintViolation> violations) throws ValidationFailedException {
        String key = String.valueOf(System.identityHashCode(validatedObject)) + " " + System.identityHashCode(method);
        if (((List)currentlyCheckingPreConditions.get()).contains(key)) {
            return;
        }
        ((List)currentlyCheckingPreConditions.get()).add(key);
        try {
            ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
            Set<PreCheck> preChecks = cc.checksForMethodsPreExecution.get(method);
            if (preChecks == null) {
                return;
            }
            try {
                String[] parameterNames = this.parameterNameResolver.getParameterNames(method);
                boolean hasParameters = parameterNames.length > 0;
                MethodEntryContext context = ContextCache.getMethodEntryContext(method);
                for (PreCheck check : preChecks) {
                    if (!this.isAnyProfileEnabled(check.getProfiles(), null)) continue;
                    ExpressionLanguage eng = this.getExpressionLanguage(check.getLanguage());
                    Map values = Guard.getCollectionFactory().createMap();
                    values.put("_this", validatedObject);
                    if (hasParameters) {
                        values.put("_args", args);
                        int i = 0;
                        while (i < args.length) {
                            values.put(parameterNames[i], args[i]);
                            ++i;
                        }
                    } else {
                        values.put("_args", ArrayUtils.EMPTY_OBJECT_ARRAY);
                    }
                    if (eng.evaluateAsBoolean(check.getExpression(), values)) continue;
                    Map messageVariables = Guard.getCollectionFactory().createMap(2);
                    messageVariables.put("expression", check.getExpression());
                    String errorMessage = this.renderMessage(context, null, check.getMessage(), messageVariables);
                    violations.add(new ConstraintViolation(check, errorMessage, validatedObject, null, context));
                }
            }
            catch (OValException ex) {
                throw new ValidationFailedException("Method pre conditions validation failed. Method: " + method + " Validated object: " + validatedObject, ex);
            }
        }
        finally {
            ((List)currentlyCheckingPreConditions.get()).remove(key);
        }
    }

    protected void validateMethodReturnValue(Object validatedObject, Method method, Object returnValue, List<ConstraintViolation> violations) throws ValidationFailedException {
        String key = String.valueOf(System.identityHashCode(validatedObject)) + " " + System.identityHashCode(method);
        if (((List)currentlyCheckingMethodReturnValues.get()).contains(key)) {
            return;
        }
        ((List)currentlyCheckingMethodReturnValues.get()).add(key);
        ((LinkedList)this.currentlyValidatedObjects.get()).add(new IdentitySet(4));
        try {
            ClassChecks cc = this.getClassChecks(method.getDeclaringClass());
            Collection returnValueChecks = cc.checksForMethodReturnValues.get(method);
            if (returnValueChecks == null || returnValueChecks.size() == 0) {
                return;
            }
            try {
                MethodReturnValueContext context = ContextCache.getMethodReturnValueContext(method);
                for (Check check : returnValueChecks) {
                    this.checkConstraint(violations, check, validatedObject, returnValue, context, null, false);
                }
            }
            catch (OValException ex) {
                throw new ValidationFailedException("Method post conditions validation failed. Method: " + method + " Validated object: " + validatedObject, ex);
            }
        }
        finally {
            ((List)currentlyCheckingMethodReturnValues.get()).remove(key);
            ((LinkedList)this.currentlyValidatedObjects.get()).removeLast();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class GuardMethodPreResult {
        protected final boolean checkInvariants;
        protected final Method method;
        protected final Object[] args;
        protected final ClassChecks cc;
        protected final List<ConstraintViolation> violations;
        protected final Map<PostCheck, Object> postCheckOldValues;
        protected final Object guardedObject;

        public GuardMethodPreResult(Object guardedObject, Method method, Object[] args, ClassChecks cc, boolean checkInvariants, Map<PostCheck, Object> postCheckOldValues, List<ConstraintViolation> violations) {
            this.guardedObject = guardedObject;
            this.method = method;
            this.args = args;
            this.cc = cc;
            this.checkInvariants = checkInvariants;
            this.postCheckOldValues = postCheckOldValues;
            this.violations = violations;
        }
    }
}

