/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.Map;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.Length;
import net.sf.oval.context.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LengthCheck
extends AbstractAnnotationCheck<Length> {
    private static final long serialVersionUID = 1L;
    private int min;
    private int max;

    @Override
    public void configure(Length constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMax(constraintAnnotation.max());
        this.setMin(constraintAnnotation.min());
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        int len = valueToValidate.toString().length();
        return len >= this.min && len <= this.max;
    }

    public void setMax(int max) {
        this.max = max;
        this.requireMessageVariablesRecreation();
    }

    public void setMin(int min) {
        this.min = min;
        this.requireMessageVariablesRecreation();
    }

    public Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(2);
        messageVariables.put("max", Integer.toString(this.max));
        messageVariables.put("min", Integer.toString(this.min));
        return messageVariables;
    }
}

