/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.util.regex.Pattern;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.Email;
import net.sf.oval.context.OValContext;
import net.sf.oval.exception.OValException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailCheck
extends AbstractAnnotationCheck<Email> {
    private static final long serialVersionUID = 1L;
    public static final Pattern EMAIL_PATTERN = Pattern.compile("\\b(^['_A-Za-z0-9-&]+(\\.['_A-Za-z0-9-&]+)*[.]{0,1}@([A-Za-z0-9-])+(\\.[A-Za-z0-9-]+)*((\\.[A-Za-z0-9]{2,})|(\\.[A-Za-z0-9]{2,}\\.[A-Za-z0-9]{2,}))$)\\b");

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) throws OValException {
        if (valueToValidate == null) {
            return true;
        }
        return EMAIL_PATTERN.matcher(valueToValidate.toString()).matches();
    }
}

