/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import net.sf.oval.ConstraintTarget;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.DateRange;
import net.sf.oval.context.OValContext;
import net.sf.oval.exception.InvalidConfigurationException;
import net.sf.oval.internal.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateRangeCheck
extends AbstractAnnotationCheck<DateRange> {
    private static final Log LOG = Log.getLog(DateRangeCheck.class);
    private static final long serialVersionUID = 1L;
    private String format;
    private String max;
    private String min;
    private transient Long maxMillis;
    private transient Long minMillis;
    private long tolerance;

    @Override
    public void configure(DateRange constraintAnnotation) {
        super.configure(constraintAnnotation);
        this.setMin(constraintAnnotation.min());
        this.setMax(constraintAnnotation.max());
        this.setFormat(constraintAnnotation.format());
        this.setTolerance(constraintAnnotation.tolerance());
    }

    public Map<String, String> createMessageVariables() {
        Map<String, String> messageVariables = Validator.getCollectionFactory().createMap(3);
        messageVariables.put("min", this.min == null ? ".." : this.min);
        messageVariables.put("max", this.max == null ? ".." : this.max);
        messageVariables.put("format", this.format);
        return messageVariables;
    }

    @Override
    protected ConstraintTarget[] getAppliesToDefault() {
        return new ConstraintTarget[]{ConstraintTarget.VALUES};
    }

    public String getFormat() {
        return this.format;
    }

    public String getMax() {
        return this.max;
    }

    private long getMaxMillis() throws InvalidConfigurationException {
        if (this.maxMillis == null) {
            if (this.max == null || this.max.length() == 0) {
                return Long.MAX_VALUE;
            }
            if ("now".equals(this.max)) {
                return System.currentTimeMillis() + this.tolerance;
            }
            if ("today".equals(this.max)) {
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(6, 1);
                cal.add(14, -1);
                return cal.getTimeInMillis() + this.tolerance;
            }
            if ("tomorrow".equals(this.max)) {
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(6, 2);
                cal.add(14, -1);
                return cal.getTimeInMillis() + this.tolerance;
            }
            if ("yesterday".equals(this.max)) {
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(14, -1);
                return cal.getTimeInMillis() + this.tolerance;
            }
            if (this.format != null && this.format.length() > 0) {
                SimpleDateFormat sdf = new SimpleDateFormat(this.format);
                try {
                    this.maxMillis = sdf.parse(this.max).getTime() + this.tolerance;
                }
                catch (ParseException e) {
                    throw new InvalidConfigurationException("Unable to parse the max Date String", e);
                }
            }
            try {
                this.maxMillis = DateFormat.getDateTimeInstance().parse(this.max).getTime() + this.tolerance;
            }
            catch (ParseException e) {
                throw new InvalidConfigurationException("Unable to parse the max Date String", e);
            }
        }
        return this.maxMillis;
    }

    public String getMin() {
        return this.min;
    }

    private long getMinMillis() throws InvalidConfigurationException {
        if (this.minMillis == null) {
            if (this.min == null || this.min.length() == 0) {
                return 0L;
            }
            if ("now".equals(this.min)) {
                return System.currentTimeMillis() - this.tolerance;
            }
            if ("today".equals(this.min)) {
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                return cal.getTimeInMillis() - this.tolerance;
            }
            if ("tomorrow".equals(this.min)) {
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(6, 1);
                return cal.getTimeInMillis() - this.tolerance;
            }
            if ("yesterday".equals(this.min)) {
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(6, -1);
                return cal.getTimeInMillis() - this.tolerance;
            }
            if (this.format != null && this.format.length() > 0) {
                SimpleDateFormat sdf = new SimpleDateFormat(this.format);
                try {
                    this.minMillis = sdf.parse(this.min).getTime() - this.tolerance;
                }
                catch (ParseException e) {
                    throw new InvalidConfigurationException("Unable to parse the min Date String", e);
                }
            }
            try {
                this.minMillis = DateFormat.getDateTimeInstance().parse(this.min).getTime() - this.tolerance;
            }
            catch (ParseException e) {
                throw new InvalidConfigurationException("Unable to parse the min Date String", e);
            }
        }
        return this.minMillis;
    }

    public long getTolerance() {
        return this.tolerance;
    }

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        long valueInMillis = -1L;
        if (valueToValidate instanceof Date) {
            valueInMillis = ((Date)valueToValidate).getTime();
        } else if (valueToValidate instanceof Calendar) {
            valueInMillis = ((Calendar)valueToValidate).getTime().getTime();
        } else {
            String stringValue = valueToValidate.toString();
            try {
                if (this.format != null) {
                    try {
                        valueInMillis = new SimpleDateFormat(this.format).parse(stringValue).getTime();
                    }
                    catch (ParseException ex) {
                        LOG.debug("valueToValidate not parsable with specified format {1}", (Object)this.format, ex);
                    }
                }
                if (valueInMillis == -1L) {
                    valueInMillis = DateFormat.getDateTimeInstance().parse(stringValue).getTime();
                }
            }
            catch (ParseException ex) {
                LOG.debug("valueToValidate is unparsable.", ex);
                return false;
            }
        }
        return valueInMillis >= this.getMinMillis() && valueInMillis <= this.getMaxMillis();
    }

    public void setFormat(String format) {
        this.format = format;
        this.requireMessageVariablesRecreation();
    }

    public void setMax(String max) {
        this.max = max;
        this.maxMillis = null;
        this.requireMessageVariablesRecreation();
    }

    public void setMin(String min) {
        this.min = min;
        this.minMillis = null;
        this.requireMessageVariablesRecreation();
    }

    public void setTolerance(long tolerance) {
        this.tolerance = tolerance;
        this.minMillis = null;
        this.maxMillis = null;
    }
}

