/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.configuration.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import net.sf.oval.Check;
import net.sf.oval.Validator;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.configuration.pojo.elements.ClassConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstraintSetConfiguration;
import net.sf.oval.configuration.pojo.elements.FieldConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodReturnValueConfiguration;
import net.sf.oval.constraint.AssertFalseCheck;
import net.sf.oval.constraint.AssertNullCheck;
import net.sf.oval.constraint.AssertTrueCheck;
import net.sf.oval.constraint.AssertValidCheck;
import net.sf.oval.constraint.DigitsCheck;
import net.sf.oval.constraint.FutureCheck;
import net.sf.oval.constraint.MatchPatternCheck;
import net.sf.oval.constraint.MaxCheck;
import net.sf.oval.constraint.MinCheck;
import net.sf.oval.constraint.NotNullCheck;
import net.sf.oval.constraint.PastCheck;
import net.sf.oval.constraint.SizeCheck;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanValidationAnnotationsConfigurer
implements Configurer {
    private static final Log LOG = Log.getLog(BeanValidationAnnotationsConfigurer.class);
    protected Boolean applyFieldConstraintsToSetters;
    protected Boolean applyFieldConstraintsToConstructors;

    public Boolean getApplyFieldConstraintsToConstructors() {
        return this.applyFieldConstraintsToConstructors;
    }

    @Override
    public ClassConfiguration getClassConfiguration(Class<?> clazz) {
        Annotation annotation;
        int n;
        int n2;
        Annotation[] annotationArray;
        List<Check> checks;
        ClassConfiguration config = new ClassConfiguration();
        config.type = clazz;
        config.applyFieldConstraintsToConstructors = this.applyFieldConstraintsToConstructors;
        config.applyFieldConstraintsToSetters = this.applyFieldConstraintsToSetters;
        AccessibleObject[] accessibleObjectArray = config.type.getDeclaredFields();
        int n3 = accessibleObjectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Field field = accessibleObjectArray[n4];
            checks = Validator.getCollectionFactory().createList(4);
            annotationArray = field.getAnnotations();
            n2 = annotationArray.length;
            n = 0;
            while (n < n2) {
                annotation = annotationArray[n];
                this.initializeChecks(annotation, checks);
                ++n;
            }
            if (checks.size() > 0) {
                if (config.fieldConfigurations == null) {
                    config.fieldConfigurations = Validator.getCollectionFactory().createSet(8);
                }
                FieldConfiguration fc = new FieldConfiguration();
                fc.name = field.getName();
                fc.checks = checks;
                config.fieldConfigurations.add(fc);
            }
            ++n4;
        }
        accessibleObjectArray = config.type.getDeclaredMethods();
        n3 = accessibleObjectArray.length;
        n4 = 0;
        while (n4 < n3) {
            AccessibleObject method = accessibleObjectArray[n4];
            if (ReflectionUtils.isGetter((Method)method)) {
                checks = Validator.getCollectionFactory().createList(2);
                annotationArray = method.getAnnotations();
                n2 = annotationArray.length;
                n = 0;
                while (n < n2) {
                    annotation = annotationArray[n];
                    this.initializeChecks(annotation, checks);
                    ++n;
                }
                if (checks.size() > 0) {
                    if (config.methodConfigurations == null) {
                        config.methodConfigurations = Validator.getCollectionFactory().createSet(2);
                    }
                    MethodConfiguration mc = new MethodConfiguration();
                    mc.name = ((Method)method).getName();
                    mc.isInvariant = true;
                    if (checks.size() > 0) {
                        mc.returnValueConfiguration = new MethodReturnValueConfiguration();
                        mc.returnValueConfiguration.checks = checks;
                    }
                    config.methodConfigurations.add(mc);
                }
            }
            ++n4;
        }
        return config;
    }

    @Override
    public ConstraintSetConfiguration getConstraintSetConfiguration(String constraintSetId) {
        return null;
    }

    protected void initializeChecks(Annotation annotation, Collection<Check> checks) {
        int n;
        MinCheck minCheck;
        MaxCheck maxCheck;
        assert (annotation != null);
        assert (checks != null);
        Class[] groups = null;
        AbstractAnnotationCheck check = null;
        if (annotation instanceof NotNull) {
            groups = ((NotNull)annotation).groups();
            check = new NotNullCheck();
        } else if (annotation instanceof Null) {
            groups = ((Null)annotation).groups();
            check = new AssertNullCheck();
        } else if (annotation instanceof Valid) {
            check = new AssertValidCheck();
        } else if (annotation instanceof AssertTrue) {
            groups = ((AssertTrue)annotation).groups();
            check = new AssertTrueCheck();
        } else if (annotation instanceof AssertFalse) {
            groups = ((AssertFalse)annotation).groups();
            check = new AssertFalseCheck();
        } else if (annotation instanceof DecimalMax) {
            groups = ((DecimalMax)annotation).groups();
            maxCheck = new MaxCheck();
            maxCheck.setMax(Double.parseDouble(((DecimalMax)annotation).value()));
            check = maxCheck;
        } else if (annotation instanceof DecimalMin) {
            groups = ((DecimalMin)annotation).groups();
            minCheck = new MinCheck();
            minCheck.setMin(Double.parseDouble(((DecimalMin)annotation).value()));
            check = minCheck;
        } else if (annotation instanceof Max) {
            groups = ((Max)annotation).groups();
            maxCheck = new MaxCheck();
            maxCheck.setMax(((Max)annotation).value());
            check = maxCheck;
        } else if (annotation instanceof Min) {
            groups = ((Min)annotation).groups();
            minCheck = new MinCheck();
            minCheck.setMin(((Min)annotation).value());
            check = minCheck;
        } else if (annotation instanceof Future) {
            groups = ((Future)annotation).groups();
            check = new FutureCheck();
        } else if (annotation instanceof Past) {
            groups = ((Past)annotation).groups();
            check = new PastCheck();
        } else if (annotation instanceof Pattern) {
            groups = ((Pattern)annotation).groups();
            MatchPatternCheck matchPatternCheck = new MatchPatternCheck();
            int iflag = 0;
            Pattern.Flag[] flagArray = ((Pattern)annotation).flags();
            int n2 = flagArray.length;
            n = 0;
            while (n < n2) {
                Pattern.Flag flag = flagArray[n];
                iflag |= flag.getValue();
                ++n;
            }
            matchPatternCheck.setPattern(((Pattern)annotation).regexp(), iflag);
            check = matchPatternCheck;
        } else if (annotation instanceof Digits) {
            groups = ((Digits)annotation).groups();
            DigitsCheck digitsCheck = new DigitsCheck();
            digitsCheck.setMaxFraction(((Digits)annotation).fraction());
            digitsCheck.setMaxInteger(((Digits)annotation).integer());
            check = digitsCheck;
        } else if (annotation instanceof Size) {
            groups = ((Size)annotation).groups();
            SizeCheck sizeCheck = new SizeCheck();
            sizeCheck.setMax(((Size)annotation).max());
            sizeCheck.setMin(((Size)annotation).min());
            check = sizeCheck;
        } else {
            LOG.warn("Ignoring unsupported JSR303 constraint annotation {1}", annotation);
            return;
        }
        if (check != null) {
            if (groups != null && groups.length > 0) {
                String[] profiles = new String[groups.length];
                int i = 0;
                int l = groups.length;
                while (i < l) {
                    profiles[i] = groups.getClass().getName();
                    ++i;
                }
                check.setProfiles(profiles);
            }
            checks.add(check);
            return;
        }
        Annotation[] list = null;
        if (annotation instanceof AssertFalse.List) {
            list = ((AssertFalse.List)annotation).value();
        } else if (annotation instanceof AssertTrue.List) {
            list = ((AssertTrue.List)annotation).value();
        } else if (annotation instanceof DecimalMax.List) {
            list = ((DecimalMax.List)annotation).value();
        } else if (annotation instanceof DecimalMin.List) {
            list = ((DecimalMin.List)annotation).value();
        } else if (annotation instanceof Digits.List) {
            list = ((Digits.List)annotation).value();
        } else if (annotation instanceof Future.List) {
            list = ((Future.List)annotation).value();
        } else if (annotation instanceof Max.List) {
            list = ((Max.List)annotation).value();
        } else if (annotation instanceof Min.List) {
            list = ((Min.List)annotation).value();
        } else if (annotation instanceof NotNull.List) {
            list = ((NotNull.List)annotation).value();
        } else if (annotation instanceof Null.List) {
            list = ((Null.List)annotation).value();
        } else if (annotation instanceof Past.List) {
            list = ((Past.List)annotation).value();
        } else if (annotation instanceof Pattern.List) {
            list = ((Pattern.List)annotation).value();
        } else if (annotation instanceof Size.List) {
            list = ((Size.List)annotation).value();
        }
        if (list != null) {
            Annotation[] annotationArray = list;
            n = list.length;
            int n3 = 0;
            while (n3 < n) {
                Annotation anno = annotationArray[n3];
                this.initializeChecks(anno, checks);
                ++n3;
            }
        }
    }

    public Boolean isApplyFieldConstraintsToSetter() {
        return this.applyFieldConstraintsToSetters;
    }

    public void setApplyFieldConstraintsToConstructors(Boolean applyFieldConstraintsToConstructors) {
        this.applyFieldConstraintsToConstructors = applyFieldConstraintsToConstructors;
    }

    public void setApplyFieldConstraintsToSetters(Boolean applyFieldConstraintsToSetters) {
        this.applyFieldConstraintsToSetters = applyFieldConstraintsToSetters;
    }
}

