/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.internal.util;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectCache<K, V> {
    private final Map<K, SoftReference<V>> map = new HashMap<K, SoftReference<V>>();
    private final LinkedList<V> objectsLastAccessed = new LinkedList();
    private final int objectsToKeepCount;

    public ObjectCache() {
        this.objectsToKeepCount = -1;
    }

    public ObjectCache(int maxObjectsToKeep) {
        this.objectsToKeepCount = maxObjectsToKeep;
    }

    public void compact() {
        for (Map.Entry<K, SoftReference<V>> entry : this.map.entrySet()) {
            SoftReference<V> ref = entry.getValue();
            if (ref.get() != null) continue;
            this.map.remove(entry.getKey());
        }
    }

    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    public V get(K key) {
        SoftReference<V> softReference = this.map.get(key);
        if (softReference != null) {
            V value = softReference.get();
            if (value == null) {
                this.map.remove(key);
            } else if (this.objectsToKeepCount > 0 && value != this.objectsLastAccessed.getFirst()) {
                this.objectsLastAccessed.remove(value);
                this.objectsLastAccessed.addFirst(value);
                if (this.objectsLastAccessed.size() > this.objectsToKeepCount) {
                    this.objectsLastAccessed.removeLast();
                }
            }
            return softReference.get();
        }
        return null;
    }

    public void put(K key, V value) {
        this.map.remove(key);
        this.map.put(key, new SoftReference<V>(value));
    }
}

