/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.constraint;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import net.sf.oval.Validator;
import net.sf.oval.configuration.annotation.AbstractAnnotationCheck;
import net.sf.oval.constraint.Past;
import net.sf.oval.context.OValContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PastCheck
extends AbstractAnnotationCheck<Past> {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean isSatisfied(Object validatedObject, Object valueToValidate, OValContext context, Validator validator) {
        if (valueToValidate == null) {
            return true;
        }
        if (valueToValidate instanceof Date) {
            return ((Date)valueToValidate).getTime() < System.currentTimeMillis();
        }
        if (valueToValidate instanceof Calendar) {
            return ((Calendar)valueToValidate).getTime().getTime() < System.currentTimeMillis();
        }
        String stringValue = valueToValidate.toString();
        try {
            return DateFormat.getDateTimeInstance().parse(stringValue).getTime() < System.currentTimeMillis();
        }
        catch (ParseException parseException) {
            return false;
        }
    }
}

