/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.configuration.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.sf.oval.AbstractCheck;
import net.sf.oval.Check;
import net.sf.oval.CheckExclusion;
import net.sf.oval.Validator;
import net.sf.oval.configuration.Configurer;
import net.sf.oval.configuration.annotation.AnnotationCheck;
import net.sf.oval.configuration.annotation.AnnotationCheckExclusion;
import net.sf.oval.configuration.annotation.Constraint;
import net.sf.oval.configuration.annotation.Constraints;
import net.sf.oval.configuration.annotation.Exclusion;
import net.sf.oval.configuration.annotation.IsInvariant;
import net.sf.oval.configuration.pojo.elements.ClassConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstraintSetConfiguration;
import net.sf.oval.configuration.pojo.elements.ConstructorConfiguration;
import net.sf.oval.configuration.pojo.elements.FieldConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodPostExecutionConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodPreExecutionConfiguration;
import net.sf.oval.configuration.pojo.elements.MethodReturnValueConfiguration;
import net.sf.oval.configuration.pojo.elements.ObjectConfiguration;
import net.sf.oval.configuration.pojo.elements.ParameterConfiguration;
import net.sf.oval.exception.ReflectionException;
import net.sf.oval.guard.Guarded;
import net.sf.oval.guard.Post;
import net.sf.oval.guard.PostCheck;
import net.sf.oval.guard.PostValidateThis;
import net.sf.oval.guard.Pre;
import net.sf.oval.guard.PreCheck;
import net.sf.oval.guard.PreValidateThis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsConfigurer
implements Configurer {
    private List<ParameterConfiguration> _createParameterConfiguration(Annotation[][] paramAnnotations, Class<?>[] parameterTypes) {
        List<ParameterConfiguration> paramCfg = Validator.getCollectionFactory().createList(2);
        int i = 0;
        while (i < paramAnnotations.length) {
            List<Check> paramChecks = Validator.getCollectionFactory().createList(2);
            List paramCheckExclusions = Validator.getCollectionFactory().createList(2);
            Annotation[] annotationArray = paramAnnotations[i];
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation.annotationType().isAnnotationPresent(Constraint.class)) {
                    paramChecks.add(this.initializeCheck(annotation));
                } else if (annotation.annotationType().isAnnotationPresent(Constraints.class)) {
                    this.initializeChecks(annotation, paramChecks);
                } else if (annotation.annotationType().isAnnotationPresent(Exclusion.class)) {
                    paramCheckExclusions.add((CheckExclusion)this.initializeExclusion(annotation));
                }
                ++n2;
            }
            ParameterConfiguration pc = new ParameterConfiguration();
            paramCfg.add(pc);
            pc.type = parameterTypes[i];
            pc.checks = paramChecks.size() == 0 ? null : paramChecks;
            pc.checkExclusions = paramCheckExclusions.size() == 0 ? null : paramCheckExclusions;
            ++i;
        }
        return paramCfg;
    }

    protected void configureConstructorParameterChecks(ClassConfiguration classCfg) {
        Constructor<?>[] constructorArray = classCfg.type.getDeclaredConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> ctor = constructorArray[n2];
            List<ParameterConfiguration> paramCfg = this._createParameterConfiguration(ctor.getParameterAnnotations(), ctor.getParameterTypes());
            boolean postValidateThis = ctor.isAnnotationPresent(PostValidateThis.class);
            if (paramCfg.size() > 0 | postValidateThis) {
                if (classCfg.constructorConfigurations == null) {
                    classCfg.constructorConfigurations = Validator.getCollectionFactory().createSet(2);
                }
                ConstructorConfiguration cc = new ConstructorConfiguration();
                cc.parameterConfigurations = paramCfg;
                cc.postCheckInvariants = postValidateThis;
                classCfg.constructorConfigurations.add(cc);
            }
            ++n2;
        }
    }

    protected void configureFieldChecks(ClassConfiguration classCfg) {
        Field[] fieldArray = classCfg.type.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            List<Check> checks = Validator.getCollectionFactory().createList(2);
            Annotation[] annotationArray = field.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Annotation annotation = annotationArray[n4];
                if (annotation.annotationType().isAnnotationPresent(Constraint.class)) {
                    checks.add(this.initializeCheck(annotation));
                } else if (annotation.annotationType().isAnnotationPresent(Constraints.class)) {
                    this.initializeChecks(annotation, checks);
                }
                ++n4;
            }
            if (checks.size() > 0) {
                if (classCfg.fieldConfigurations == null) {
                    classCfg.fieldConfigurations = Validator.getCollectionFactory().createSet(2);
                }
                FieldConfiguration fc = new FieldConfiguration();
                fc.name = field.getName();
                fc.checks = checks;
                classCfg.fieldConfigurations.add(fc);
            }
            ++n2;
        }
    }

    protected void configureMethodChecks(ClassConfiguration classCfg) {
        Method[] methodArray = classCfg.type.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            List<Check> returnValueChecks = Validator.getCollectionFactory().createList(2);
            List preChecks = Validator.getCollectionFactory().createList(2);
            List postChecks = Validator.getCollectionFactory().createList(2);
            boolean preValidateThis = false;
            boolean postValidateThis = false;
            Annotation[] annotationArray = method.getAnnotations();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                AbstractCheck pc;
                Annotation annotation = annotationArray[n4];
                if (annotation instanceof Pre) {
                    pc = new PreCheck();
                    ((PreCheck)pc).configure((Pre)annotation);
                    preChecks.add(pc);
                } else if (annotation instanceof PreValidateThis) {
                    preValidateThis = true;
                } else if (annotation instanceof Post) {
                    pc = new PostCheck();
                    ((PostCheck)pc).configure((Post)annotation);
                    postChecks.add(pc);
                } else if (annotation instanceof PostValidateThis) {
                    postValidateThis = true;
                } else if (annotation.annotationType().isAnnotationPresent(Constraint.class)) {
                    returnValueChecks.add(this.initializeCheck(annotation));
                } else if (annotation.annotationType().isAnnotationPresent(Constraints.class)) {
                    this.initializeChecks(annotation, returnValueChecks);
                }
                ++n4;
            }
            List<ParameterConfiguration> paramCfg = this._createParameterConfiguration(method.getParameterAnnotations(), method.getParameterTypes());
            if (paramCfg.size() > 0 || returnValueChecks.size() > 0 || preChecks.size() > 0 || postChecks.size() > 0 || preValidateThis || postValidateThis) {
                if (classCfg.methodConfigurations == null) {
                    classCfg.methodConfigurations = Validator.getCollectionFactory().createSet(2);
                }
                MethodConfiguration mc = new MethodConfiguration();
                mc.name = method.getName();
                mc.parameterConfigurations = paramCfg;
                mc.isInvariant = method.isAnnotationPresent(IsInvariant.class);
                mc.preCheckInvariants = preValidateThis;
                mc.postCheckInvariants = postValidateThis;
                if (returnValueChecks.size() > 0) {
                    mc.returnValueConfiguration = new MethodReturnValueConfiguration();
                    mc.returnValueConfiguration.checks = returnValueChecks;
                }
                if (preChecks.size() > 0) {
                    mc.preExecutionConfiguration = new MethodPreExecutionConfiguration();
                    mc.preExecutionConfiguration.checks = preChecks;
                }
                if (postChecks.size() > 0) {
                    mc.postExecutionConfiguration = new MethodPostExecutionConfiguration();
                    mc.postExecutionConfiguration.checks = postChecks;
                }
                classCfg.methodConfigurations.add(mc);
            }
            ++n2;
        }
    }

    protected void configureObjectLevelChecks(ClassConfiguration classCfg) {
        List<Check> checks = Validator.getCollectionFactory().createList(2);
        Annotation[] annotationArray = classCfg.type.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType().isAnnotationPresent(Constraint.class)) {
                checks.add(this.initializeCheck(annotation));
            } else if (annotation.annotationType().isAnnotationPresent(Constraints.class)) {
                this.initializeChecks(annotation, checks);
            }
            ++n2;
        }
        if (checks.size() > 0) {
            classCfg.objectConfiguration = new ObjectConfiguration();
            classCfg.objectConfiguration.checks = checks;
        }
    }

    @Override
    public ClassConfiguration getClassConfiguration(Class<?> clazz) {
        ClassConfiguration classCfg = new ClassConfiguration();
        classCfg.type = clazz;
        Guarded guarded = clazz.getAnnotation(Guarded.class);
        classCfg.applyFieldConstraintsToConstructors = guarded != null && guarded.applyFieldConstraintsToConstructors();
        classCfg.applyFieldConstraintsToSetters = guarded != null && guarded.applyFieldConstraintsToSetters();
        classCfg.assertParametersNotNull = guarded != null && guarded.assertParametersNotNull();
        classCfg.checkInvariants = guarded != null && guarded.checkInvariants();
        this.configureObjectLevelChecks(classCfg);
        this.configureFieldChecks(classCfg);
        this.configureConstructorParameterChecks(classCfg);
        this.configureMethodChecks(classCfg);
        return classCfg;
    }

    @Override
    public ConstraintSetConfiguration getConstraintSetConfiguration(String constraintSetId) {
        return null;
    }

    protected <ConstraintsAnnotation extends Annotation> void initializeChecks(ConstraintsAnnotation constraintsAnnotation, List<Check> checks) throws ReflectionException {
        try {
            Object[] constraintAnnotations;
            Method getValue = constraintsAnnotation.annotationType().getDeclaredMethod("value", null);
            Object[] objectArray = constraintAnnotations = (Object[])getValue.invoke(constraintsAnnotation, null);
            int n = constraintAnnotations.length;
            int n2 = 0;
            while (n2 < n) {
                Object ca = objectArray[n2];
                checks.add(this.initializeCheck((Annotation)ca));
                ++n2;
            }
        }
        catch (Exception e) {
            throw new ReflectionException("Cannot initialize constraint exclusion " + constraintsAnnotation.annotationType().getName(), e);
        }
    }

    protected <ConstraintAnnotation extends Annotation> AnnotationCheck<ConstraintAnnotation> initializeCheck(ConstraintAnnotation constraintAnnotation) throws ReflectionException {
        assert (constraintAnnotation != null);
        Constraint constraint = constraintAnnotation.annotationType().getAnnotation(Constraint.class);
        Class<? extends AnnotationCheck<? extends Annotation>> checkClass = constraint.checkWith();
        try {
            AnnotationCheck<? extends Annotation> check = checkClass.newInstance();
            check.configure(constraintAnnotation);
            return check;
        }
        catch (Exception e) {
            throw new ReflectionException("Cannot initialize constraint check " + checkClass.getName(), e);
        }
    }

    protected <ExclusionAnnotation extends Annotation> AnnotationCheckExclusion<ExclusionAnnotation> initializeExclusion(ExclusionAnnotation exclusionAnnotation) throws ReflectionException {
        assert (exclusionAnnotation != null);
        Exclusion constraint = exclusionAnnotation.annotationType().getAnnotation(Exclusion.class);
        Class<? extends AnnotationCheckExclusion<? extends Annotation>> exclusionClass = constraint.excludeWith();
        try {
            AnnotationCheckExclusion<? extends Annotation> exclusion = exclusionClass.newInstance();
            exclusion.configure(exclusionAnnotation);
            return exclusion;
        }
        catch (Exception e) {
            throw new ReflectionException("Cannot initialize constraint exclusion " + exclusionClass.getName(), e);
        }
    }
}

