/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.nonstop;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.constructs.nonstop.NonstopExecutorService;
import net.sf.ehcache.constructs.nonstop.NonstopThreadPool;
import net.sf.ehcache.constructs.nonstop.TaskNotSubmittedTimeoutException;
import net.sf.ehcache.constructs.nonstop.ThrowTimeoutException;
import net.sf.ehcache.constructs.nonstop.concurrency.InvalidLockStateAfterRejoinException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonstopExecutorServiceImpl
implements NonstopExecutorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonstopExecutorServiceImpl.class);
    private static final String EOL = System.getProperty("line.separator");
    private final NonstopThreadPool nonstopThreadPool;

    public NonstopExecutorServiceImpl(ThreadFactory threadFactory) {
        this.nonstopThreadPool = new NonstopThreadPool(threadFactory);
    }

    @Override
    public <V> V execute(Callable<V> callable, long timeoutValueInMillis) throws TimeoutException, CacheException, InterruptedException {
        int attempt = 0;
        V result = null;
        long startTime = System.nanoTime();
        while (true) {
            boolean success = false;
            try {
                ++attempt;
                result = this.nonstopThreadPool.submit(callable).get(timeoutValueInMillis, TimeUnit.MILLISECONDS);
                success = true;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (RejectedExecutionException e) {
                long now = System.nanoTime();
                if (now - startTime <= TimeUnit.NANOSECONDS.convert(timeoutValueInMillis, TimeUnit.MILLISECONDS)) continue;
                throw new TaskNotSubmittedTimeoutException(attempt);
            }
            catch (ExecutionException e) {
                Throwable rootCause = this.getRootCause(e);
                if (rootCause.getClass().getSimpleName().equals("TCNotRunningException")) {
                    throw new TimeoutException(rootCause.getMessage());
                }
                if (rootCause instanceof ThrowTimeoutException) {
                    throw new TimeoutException("Callable threw " + rootCause.getClass().getName());
                }
                if (rootCause instanceof InterruptedException) {
                    throw new TimeoutException("Callable threw " + rootCause.getClass().getName());
                }
                if (e.getCause() instanceof InvalidLockStateAfterRejoinException) {
                    throw new InvalidLockStateAfterRejoinException(e.getCause());
                }
                throw new CacheException(e.getCause());
            }
            catch (TimeoutException e) {
                throw e;
            }
            finally {
                if (success) continue;
                this.printNonstopThreadStackTrace(callable, timeoutValueInMillis);
                continue;
            }
            break;
        }
        return result;
    }

    private void printNonstopThreadStackTrace(Callable callable, long timeoutValueInMillis) {
        if (Boolean.getBoolean("net.sf.ehcache.nonstop.printStackTraceOnException")) {
            StackTraceElement[] stackTrace = this.nonstopThreadPool.getNonstopThreadStackTrace();
            StringBuilder builder = new StringBuilder();
            builder.append("Nonstop thread Stacktrace for callable: ").append(callable).append(", timeoutValueMillis: ").append(timeoutValueInMillis).append(", current thread: ").append(Thread.currentThread().getName()).append(EOL);
            if (stackTrace.length > 0) {
                for (StackTraceElement ste : stackTrace) {
                    builder.append("  at ").append(ste.getClassName()).append(".").append(ste.getMethodName()).append("(").append(ste.getFileName() == null ? "<no file name info>" : ste.getFileName()).append(":").append((ste.getLineNumber() >= 0 ? ste.getLineNumber() + "" : "<unknown line number>") + ")").append(EOL);
                }
            } else {
                builder.append("<No stacktrace info available>");
            }
            LOGGER.info(builder.toString());
        }
    }

    private Throwable getRootCause(Throwable exception) {
        Throwable e = exception;
        while (e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    @Override
    public void shutdown() {
        LOGGER.debug("Shutting down NonstopExecutorService");
        this.nonstopThreadPool.shutdownNow();
    }
}

