/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.derived;

import java.util.EnumSet;
import java.util.Set;
import org.terracotta.statistics.AbstractSourceStatistic;
import org.terracotta.statistics.Time;
import org.terracotta.statistics.jsr166e.ThreadLocalRandom;
import org.terracotta.statistics.observer.EventObserver;
import org.terracotta.statistics.observer.OperationObserver;

public class LatencySampling<T extends Enum<T>>
extends AbstractSourceStatistic<EventObserver>
implements OperationObserver<T> {
    private final ThreadLocal<Long> operationStartTime = new ThreadLocal();
    private final Set<T> targetOperations;
    private final int ceiling;

    public LatencySampling(Set<T> targets, double sampling) {
        if (sampling > 1.0 || sampling < 0.0) {
            throw new IllegalArgumentException();
        }
        this.ceiling = (int)(2.147483647E9 * sampling);
        this.targetOperations = EnumSet.copyOf(targets);
    }

    @Override
    public void begin() {
        if (this.sample()) {
            this.operationStartTime.set(Time.time());
        }
    }

    @Override
    public void end(T result) {
        Long start;
        if (this.targetOperations.contains(result) && (start = this.operationStartTime.get()) != null) {
            long latency = Time.time() - start;
            if (!this.derivedStatistics.isEmpty()) {
                for (EventObserver observer : this.derivedStatistics) {
                    observer.event(latency);
                }
            }
        }
        this.operationStartTime.remove();
    }

    @Override
    public void end(T result, long ... parameters) {
        this.end(result);
    }

    private boolean sample() {
        return (double)this.ceiling == 1.0 || ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE) < this.ceiling;
    }
}

