/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.writebehind;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.writer.CacheWriter;
import org.terracotta.modules.ehcache.async.ItemProcessor;
import org.terracotta.modules.ehcache.writebehind.operations.BatchAsyncOperation;
import org.terracotta.modules.ehcache.writebehind.operations.DeleteAllAsyncOperation;
import org.terracotta.modules.ehcache.writebehind.operations.DeleteAsyncOperation;
import org.terracotta.modules.ehcache.writebehind.operations.SingleAsyncOperation;
import org.terracotta.modules.ehcache.writebehind.operations.WriteAllAsyncOperation;
import org.terracotta.modules.ehcache.writebehind.operations.WriteAsyncOperation;

public class CacheWriterProcessor
implements ItemProcessor<SingleAsyncOperation> {
    private final CacheWriter cacheWriter;

    public CacheWriterProcessor(CacheWriter cacheWriter) {
        this.cacheWriter = cacheWriter;
    }

    @Override
    public void process(SingleAsyncOperation item) {
        try {
            item.performSingleOperation(this.cacheWriter);
        }
        catch (Exception e) {
            throw new CacheException("Unexpected exception while processing write behind operation", e);
        }
    }

    @Override
    public void process(Collection<SingleAsyncOperation> items) {
        HashMap separatedItemsPerType = new HashMap();
        for (SingleAsyncOperation singleAsyncOperation : items) {
            ArrayList<SingleAsyncOperation> itemsPerType = (ArrayList<SingleAsyncOperation>)separatedItemsPerType.get(singleAsyncOperation.getClass());
            if (null == itemsPerType) {
                itemsPerType = new ArrayList<SingleAsyncOperation>();
                separatedItemsPerType.put(singleAsyncOperation.getClass(), itemsPerType);
            }
            itemsPerType.add(singleAsyncOperation);
        }
        try {
            for (Map.Entry entry : separatedItemsPerType.entrySet()) {
                BatchAsyncOperation batch = this.createBatchOprForType(entry.getClass(), (Collection)entry.getValue());
                batch.performBatchOperation(this.cacheWriter);
            }
        }
        catch (Exception e) {
            throw new CacheException("Unexpected exception while processing write behind operation", e);
        }
    }

    private BatchAsyncOperation createBatchOprForType(Class operationClass, Collection<SingleAsyncOperation> operations) {
        if (operationClass == WriteAsyncOperation.class) {
            ArrayList<Element> elements = new ArrayList<Element>();
            for (SingleAsyncOperation operation : operations) {
                elements.add(operation.getElement());
            }
            return new WriteAllAsyncOperation(elements);
        }
        if (operationClass == DeleteAsyncOperation.class) {
            ArrayList<CacheEntry> entries = new ArrayList<CacheEntry>();
            for (SingleAsyncOperation operation : operations) {
                entries.add(new CacheEntry(operation.getKey(), operation.getElement()));
            }
            return new DeleteAllAsyncOperation(entries);
        }
        return null;
    }

    @Override
    public void throwAway(SingleAsyncOperation item, RuntimeException runtimeException) {
        try {
            item.throwAwayElement(this.cacheWriter, runtimeException);
        }
        catch (Exception e) {
            throw new CacheException("Unexpected exception while throwing away write behind operation", e);
        }
    }
}

