/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache.store.bulkload;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.store.StoreListener;
import org.terracotta.modules.ehcache.store.bulkload.BulkLoadConstants;
import org.terracotta.toolkit.cluster.ClusterEvent;
import org.terracotta.toolkit.cluster.ClusterInfo;
import org.terracotta.toolkit.cluster.ClusterListener;
import org.terracotta.toolkit.cluster.ClusterNode;
import org.terracotta.toolkit.collections.ToolkitSet;
import org.terracotta.toolkit.concurrent.locks.ToolkitLock;
import org.terracotta.toolkit.internal.ToolkitInternal;
import org.terracotta.toolkit.internal.ToolkitLogger;

public class BulkLoadEnabledNodesSet {
    private static final String BULK_LOAD_NODES_SET_PREFIX = "__tc_bulk-load-nodes-set_for_cache_";
    private final ToolkitLogger logger;
    private final ClusterInfo clusterInfo;
    private final ToolkitSet<String> bulkLoadEnabledNodesSet;
    private final ToolkitLock clusteredLock;
    private final String name;
    private final CleanupOnNodeLeftListener cleanupOnNodeLeftListener;
    private final boolean loggingEnabled;
    private final StoreListener listener;

    protected BulkLoadEnabledNodesSet(ToolkitInternal toolkit, String name, StoreListener listener) {
        this.name = name;
        this.clusterInfo = toolkit.getClusterInfo();
        this.listener = listener;
        this.bulkLoadEnabledNodesSet = toolkit.getSet(BULK_LOAD_NODES_SET_PREFIX + name, String.class);
        this.clusteredLock = this.bulkLoadEnabledNodesSet.getReadWriteLock().writeLock();
        this.logger = toolkit.getLogger(BulkLoadEnabledNodesSet.class.getName());
        this.cleanupOfflineNodes();
        this.cleanupOnNodeLeftListener = new CleanupOnNodeLeftListener(this, this.clusterInfo, toolkit);
        this.clusterInfo.addClusterListener((ClusterListener)this.cleanupOnNodeLeftListener);
        this.loggingEnabled = BulkLoadConstants.isLoggingEnabled(toolkit.getProperties());
    }

    private static final String getIdForNode(ClusterNode node) {
        return node.getId();
    }

    private void debug(String msg) {
        ArrayList<String> nodes = new ArrayList<String>((Collection<String>)this.bulkLoadEnabledNodesSet);
        this.logger.info((Object)("['" + this.name + "'] " + msg + " [bulk-load enabled nodes: " + nodes + "]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupOfflineNodes() {
        this.clusteredLock.lock();
        try {
            Set liveNodes = this.clusterInfo.getNodes();
            ArrayList<String> defunctNodes = new ArrayList<String>((Collection<String>)this.bulkLoadEnabledNodesSet);
            if (this.loggingEnabled) {
                this.debug("Cleaning up offline nodes. Live nodes: " + liveNodes);
            }
            for (ClusterNode node : liveNodes) {
                defunctNodes.remove(BulkLoadEnabledNodesSet.getIdForNode(node));
            }
            for (String nodeId : defunctNodes) {
                this.bulkLoadEnabledNodesSet.remove((Object)nodeId);
            }
            if (this.loggingEnabled) {
                this.debug("Offline nodes cleanup complete");
            }
        }
        finally {
            this.clusteredLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCurrentNode() {
        this.clusteredLock.lock();
        try {
            String currentNodeId = BulkLoadEnabledNodesSet.getIdForNode(this.clusterInfo.getCurrentNode());
            this.bulkLoadEnabledNodesSet.add((Object)currentNodeId);
            if (this.loggingEnabled) {
                this.debug("Added current node ('" + currentNodeId + "')");
            }
        }
        finally {
            this.clusteredLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCurrentNode() {
        this.clusteredLock.lock();
        try {
            this.removeNodeIdAndNotifyAll(BulkLoadEnabledNodesSet.getIdForNode(this.clusterInfo.getCurrentNode()));
        }
        finally {
            this.clusteredLock.unlock();
        }
    }

    private void removeNodeIdAndNotifyAll(String nodeId) {
        this.bulkLoadEnabledNodesSet.remove((Object)nodeId);
        if (this.loggingEnabled) {
            this.debug("Removed node ('" + nodeId + "'), going to signal all.");
        }
        this.clusteredLock.getCondition().signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilSetEmpty() throws InterruptedException {
        this.clusteredLock.lock();
        try {
            while (this.bulkLoadEnabledNodesSet.size() != 0) {
                if (this.loggingEnabled) {
                    this.debug("Waiting until bulk-load enabled nodes list is empty" + this.bulkLoadEnabledNodesSet.size());
                }
                this.clusteredLock.getCondition().await(10L, TimeUnit.SECONDS);
                if (this.bulkLoadEnabledNodesSet.size() <= 0) continue;
                this.cleanupOfflineNodes();
            }
        }
        finally {
            this.clusteredLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBulkLoadEnabledInCluster() {
        this.clusteredLock.lock();
        try {
            boolean rv;
            boolean bl = rv = this.bulkLoadEnabledNodesSet.size() != 0;
            if (this.loggingEnabled) {
                this.debug("Is bulk-load enabled in cluster? " + rv);
            }
            boolean bl2 = rv;
            return bl2;
        }
        finally {
            this.clusteredLock.unlock();
        }
    }

    public void disposeLocally() {
        this.clusterInfo.removeClusterListener((ClusterListener)this.cleanupOnNodeLeftListener);
    }

    private static class CleanupOnNodeLeftListener
    implements ClusterListener {
        private final BulkLoadEnabledNodesSet nodesSet;
        private final ClusterInfo clusterInfo;

        public CleanupOnNodeLeftListener(BulkLoadEnabledNodesSet nodesSet, ClusterInfo clusterInfo, ToolkitInternal toolkit) {
            this.nodesSet = nodesSet;
            this.clusterInfo = clusterInfo;
        }

        public void onClusterEvent(ClusterEvent event) {
            switch (event.getType()) {
                case NODE_LEFT: {
                    this.handleNodeLeft(event);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleNodeLeft(ClusterEvent event) {
            String offlineNode = BulkLoadEnabledNodesSet.getIdForNode(event.getNode());
            this.nodesSet.logger.info((Object)("Received node left event for: " + offlineNode));
            if (BulkLoadEnabledNodesSet.getIdForNode(this.clusterInfo.getCurrentNode()).equals(offlineNode)) {
                if (this.nodesSet.loggingEnabled) {
                    this.nodesSet.logger.info((Object)("Ignoring " + event.getType() + " of current node itself - " + offlineNode));
                }
                return;
            }
            if (!this.clusterInfo.areOperationsEnabled()) {
                this.nodesSet.logger.warn((Object)("Ignoring node left of node: " + offlineNode + ", as current node is offline."));
                return;
            }
            this.nodesSet.clusteredLock.lock();
            try {
                boolean shouldSend = !this.nodesSet.bulkLoadEnabledNodesSet.isEmpty();
                this.nodesSet.removeNodeIdAndNotifyAll(offlineNode);
                if (shouldSend && this.nodesSet.bulkLoadEnabledNodesSet.isEmpty()) {
                    this.nodesSet.listener.clusterCoherent(true);
                }
            }
            finally {
                this.nodesSet.clusteredLock.unlock();
            }
        }
    }
}

