/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.modules.ehcache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Set;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.PinningConfiguration;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.transaction.Decision;
import net.sf.ehcache.transaction.TransactionID;
import org.terracotta.modules.ehcache.TerracottaToolkitBuilder;
import org.terracotta.modules.ehcache.ToolkitInstanceFactory;
import org.terracotta.modules.ehcache.async.AsyncConfig;
import org.terracotta.modules.ehcache.collections.SerializationHelper;
import org.terracotta.modules.ehcache.collections.SerializedToolkitCache;
import org.terracotta.modules.ehcache.event.CacheEventNotificationMsg;
import org.terracotta.modules.ehcache.store.CacheConfigChangeNotificationMsg;
import org.terracotta.modules.ehcache.store.ToolkitNonStopConfiguration;
import org.terracotta.modules.ehcache.store.nonstop.ToolkitNonstopDisableConfig;
import org.terracotta.modules.ehcache.transaction.ClusteredSoftLockIDKey;
import org.terracotta.modules.ehcache.transaction.SerializedReadCommittedClusteredSoftLock;
import org.terracotta.toolkit.Toolkit;
import org.terracotta.toolkit.ToolkitFeatureType;
import org.terracotta.toolkit.ToolkitObjectType;
import org.terracotta.toolkit.builder.ToolkitCacheConfigBuilder;
import org.terracotta.toolkit.builder.ToolkitStoreConfigBuilder;
import org.terracotta.toolkit.cache.ToolkitCache;
import org.terracotta.toolkit.collections.ToolkitMap;
import org.terracotta.toolkit.concurrent.locks.ToolkitLock;
import org.terracotta.toolkit.concurrent.locks.ToolkitReadWriteLock;
import org.terracotta.toolkit.config.Configuration;
import org.terracotta.toolkit.events.ToolkitNotifier;
import org.terracotta.toolkit.feature.NonStopFeature;
import org.terracotta.toolkit.internal.cache.ToolkitCacheInternal;
import org.terracotta.toolkit.nonstop.NonStopConfiguration;
import org.terracotta.toolkit.nonstop.NonStopConfigurationRegistry;
import org.terracotta.toolkit.store.ToolkitConfigFields;

public class ToolkitInstanceFactoryImpl
implements ToolkitInstanceFactory {
    public static final String DELIMITER = "|";
    private static final String EVENT_NOTIFIER_SUFFIX = "event-notifier";
    private static final String EHCACHE_NAME_PREFIX = "__tc_clustered-ehcache";
    private static final String CONFIG_NOTIFIER_SUFFIX = "config-notifier";
    private static final String EHCACHE_TXNS_DECISION_STATE_MAP_NAME = "__tc_clustered-ehcache|txnsDecision";
    private static final String ALL_SOFT_LOCKS_MAP_SUFFIX = "softLocks";
    private static final String NEW_SOFT_LOCKS_LIST_SUFFIX = "newSoftLocks";
    private static final String ASYNC_CONFIG_MAP = "asyncConfigMap";
    private static final String CLUSTERED_STORE_CONFIG_MAP = "__tc_clustered-ehcache|configMap";
    private static final String EHCACHE_TXNS_SOFTLOCK_WRITE_LOCK_NAME = "__tc_clustered-ehcache|softWriteLock";
    private static final String EHCACHE_TXNS_SOFTLOCK_FREEZE_LOCK_NAME = "__tc_clustered-ehcache|softFreezeLock";
    private static final String EHCACHE_TXNS_SOFTLOCK_NOTIFIER_LOCK_NAME = "__tc_clustered-ehcache|softNotifierLock";
    protected final Toolkit toolkit;

    public ToolkitInstanceFactoryImpl(TerracottaClientConfiguration terracottaClientConfiguration) {
        this.toolkit = ToolkitInstanceFactoryImpl.createTerracottaToolkit(terracottaClientConfiguration);
        this.updateDefaultNonStopConfig(this.toolkit);
    }

    private void updateDefaultNonStopConfig(Toolkit toolkitParam) {
        ToolkitNonstopDisableConfig disableNonStop = new ToolkitNonstopDisableConfig();
        NonStopConfigurationRegistry nonStopConfigurationRegistry = ((NonStopFeature)toolkitParam.getFeature(ToolkitFeatureType.NONSTOP)).getNonStopConfigurationRegistry();
        for (ToolkitObjectType t : ToolkitObjectType.values()) {
            try {
                nonStopConfigurationRegistry.registerForType((NonStopConfiguration)disableNonStop, new ToolkitObjectType[]{t});
            }
            catch (UnsupportedOperationException e) {
                if (t == ToolkitObjectType.BARRIER || t == ToolkitObjectType.BLOCKING_QUEUE) continue;
                throw e;
            }
        }
    }

    private static Toolkit createTerracottaToolkit(TerracottaClientConfiguration terracottaClientConfiguration) {
        TerracottaToolkitBuilder terracottaClientBuilder = new TerracottaToolkitBuilder();
        EhcacheTcConfig ehcacheTcConfig = EhcacheTcConfig.create(terracottaClientConfiguration);
        switch (ehcacheTcConfig.type) {
            case URL: {
                terracottaClientBuilder.setTCConfigUrl(ehcacheTcConfig.tcConfigUrlOrSnippet);
                break;
            }
            case EMBEDDED_TC_CONFIG: 
            case FILE: {
                terracottaClientBuilder.setTCConfigSnippet(ehcacheTcConfig.tcConfigUrlOrSnippet);
            }
        }
        terracottaClientBuilder.addTunnelledMBeanDomain("net.sf.ehcache");
        terracottaClientBuilder.addTunnelledMBeanDomain("net.sf.ehcache.hibernate");
        terracottaClientBuilder.setRejoinEnabled(terracottaClientConfiguration.isRejoin());
        return terracottaClientBuilder.buildToolkit();
    }

    @Override
    public Toolkit getToolkit() {
        return this.toolkit;
    }

    @Override
    public ToolkitCacheInternal<String, Serializable> getOrCreateToolkitCache(Ehcache cache) {
        Configuration clusteredCacheConfig = ToolkitInstanceFactoryImpl.createClusteredCacheConfig(cache);
        this.addNonStopConfigForCache(cache);
        return (ToolkitCacheInternal)this.toolkit.getCache(this.getFullyQualifiedCacheName(cache), clusteredCacheConfig, Serializable.class);
    }

    @Override
    public ToolkitNotifier<CacheConfigChangeNotificationMsg> getOrCreateConfigChangeNotifier(Ehcache cache) {
        return this.toolkit.getNotifier(this.getFullyQualifiedCacheName(cache) + DELIMITER + CONFIG_NOTIFIER_SUFFIX, CacheConfigChangeNotificationMsg.class);
    }

    @Override
    public ToolkitNotifier<CacheEventNotificationMsg> getOrCreateCacheEventNotifier(Ehcache cache) {
        return this.toolkit.getNotifier(this.getFullyQualifiedCacheName(cache) + DELIMITER + EVENT_NOTIFIER_SUFFIX, CacheEventNotificationMsg.class);
    }

    private static Configuration createClusteredCacheConfig(Ehcache cache) {
        ToolkitCacheConfigBuilder builder = new ToolkitCacheConfigBuilder();
        CacheConfiguration ehcacheConfig = cache.getCacheConfiguration();
        TerracottaConfiguration terracottaConfiguration = ehcacheConfig.getTerracottaConfiguration();
        builder.maxTTISeconds((int)ehcacheConfig.getTimeToIdleSeconds());
        builder.maxTTLSeconds((int)ehcacheConfig.getTimeToLiveSeconds());
        builder.maxTotalCount(ehcacheConfig.getMaxEntriesInCache());
        builder.localCacheEnabled(terracottaConfiguration.isLocalCacheEnabled());
        if (terracottaConfiguration.isSynchronousWrites()) {
            builder.consistency(ToolkitConfigFields.Consistency.SYNCHRONOUS_STRONG);
        } else if (terracottaConfiguration.getConsistency() == TerracottaConfiguration.Consistency.EVENTUAL) {
            builder.consistency(ToolkitConfigFields.Consistency.EVENTUAL);
        } else {
            builder.consistency(ToolkitConfigFields.Consistency.STRONG);
        }
        if (terracottaConfiguration.getConcurrency() == 0) {
            builder.concurrency(ToolkitInstanceFactoryImpl.calculateCorrectConcurrency(ehcacheConfig));
        } else {
            builder.concurrency(terracottaConfiguration.getConcurrency());
        }
        String cmName = cache.getCacheManager().isNamed() ? cache.getCacheManager().getName() : "__DEFAULT__";
        builder.localCacheEnabled(terracottaConfiguration.isLocalCacheEnabled());
        builder.configField("localStoreManagerName", (Serializable)((Object)cmName));
        builder.pinnedInLocalMemory(ToolkitInstanceFactoryImpl.isPinnedInLocalMemory(ehcacheConfig));
        builder.evictionEnabled(!ToolkitInstanceFactoryImpl.isPinnedInCache(ehcacheConfig));
        builder.maxCountLocalHeap((int)ehcacheConfig.getMaxEntriesLocalHeap());
        builder.maxBytesLocalHeap(ehcacheConfig.getMaxBytesLocalHeap());
        builder.maxBytesLocalOffheap(ehcacheConfig.getMaxBytesLocalOffHeap());
        builder.offheapEnabled(ehcacheConfig.isOverflowToOffHeap());
        builder.compressionEnabled(terracottaConfiguration.isCompressionEnabled());
        builder.copyOnReadEnabled(ehcacheConfig.isCopyOnRead());
        return builder.build();
    }

    private static boolean isPinnedInCache(CacheConfiguration ehcacheConfig) {
        return ehcacheConfig.getPinningConfiguration() != null && ehcacheConfig.getPinningConfiguration().getStore() == PinningConfiguration.Store.INCACHE;
    }

    private static int calculateCorrectConcurrency(CacheConfiguration cacheConfiguration) {
        int maxElementOnDisk = cacheConfiguration.getMaxElementsOnDisk();
        if (maxElementOnDisk <= 0 || maxElementOnDisk >= 256) {
            return 256;
        }
        int concurrency = 1;
        while (concurrency * 2 <= maxElementOnDisk) {
            concurrency *= 2;
        }
        return concurrency;
    }

    private static boolean isPinnedInLocalMemory(CacheConfiguration ehcacheConfig) {
        return ehcacheConfig.getPinningConfiguration() != null && ehcacheConfig.getPinningConfiguration().getStore() == PinningConfiguration.Store.LOCALMEMORY;
    }

    @Override
    public String getFullyQualifiedCacheName(Ehcache cache) {
        return ToolkitInstanceFactoryImpl.getFullyQualifiedCacheName(ToolkitInstanceFactoryImpl.getCacheManagerName(cache), cache.getName());
    }

    public static String getFullyQualifiedCacheName(String cacheMgrName, String cacheName) {
        return "__tc_clustered-ehcache|" + cacheMgrName + DELIMITER + cacheName;
    }

    private static String getCacheManagerName(Ehcache cache) {
        String cacheMgrName = cache.getCacheManager().isNamed() ? cache.getCacheManager().getName() : "__DEFAULT__";
        return cacheMgrName;
    }

    @Override
    public ToolkitLock getOrCreateStoreLock(Ehcache cache) {
        return this.toolkit.getLock(this.getFullyQualifiedCacheName(cache) + DELIMITER + "storeRWLock");
    }

    @Override
    public ToolkitMap<String, AttributeExtractor> getOrCreateExtractorsMap(Ehcache cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        this.toolkit.shutdown();
    }

    @Override
    public SerializedToolkitCache<ClusteredSoftLockIDKey, SerializedReadCommittedClusteredSoftLock> getOrCreateAllSoftLockMap(String cacheManagerName, String cacheName) {
        Configuration config = new ToolkitStoreConfigBuilder().consistency(ToolkitConfigFields.Consistency.STRONG).build();
        ToolkitCache map = this.toolkit.getCache(ToolkitInstanceFactoryImpl.getFullyQualifiedCacheName(cacheManagerName, cacheName) + DELIMITER + ALL_SOFT_LOCKS_MAP_SUFFIX, config, SerializedReadCommittedClusteredSoftLock.class);
        return new SerializedToolkitCache<ClusteredSoftLockIDKey, SerializedReadCommittedClusteredSoftLock>(map);
    }

    @Override
    public ToolkitMap<SerializedReadCommittedClusteredSoftLock, Integer> getOrCreateNewSoftLocksSet(String cacheManagerName, String cacheName) {
        return this.toolkit.getMap(ToolkitInstanceFactoryImpl.getFullyQualifiedCacheName(cacheManagerName, cacheName) + DELIMITER + NEW_SOFT_LOCKS_LIST_SUFFIX, SerializedReadCommittedClusteredSoftLock.class, Integer.class);
    }

    @Override
    public ToolkitMap<String, AsyncConfig> getOrCreateAsyncConfigMap() {
        return this.toolkit.getMap(ASYNC_CONFIG_MAP, String.class, AsyncConfig.class);
    }

    @Override
    public ToolkitMap<String, Set<String>> getOrCreateAsyncListNamesMap(String fullAsyncName) {
        ToolkitMap asyncListNames = this.toolkit.getMap(fullAsyncName, String.class, Set.class);
        return asyncListNames;
    }

    @Override
    public String getFullAsyncName(Ehcache cache) {
        String cacheMgrName = ToolkitInstanceFactoryImpl.getCacheManagerName(cache);
        String cacheName = cache.getName();
        String fullAsyncName = cacheMgrName + DELIMITER + cacheName;
        return fullAsyncName;
    }

    @Override
    public ToolkitMap<String, Serializable> getOrCreateClusteredStoreConfigMap(String cacheManagerName, String cacheName) {
        return this.toolkit.getMap(ToolkitInstanceFactoryImpl.getFullyQualifiedCacheName(cacheManagerName, cacheName) + DELIMITER + CLUSTERED_STORE_CONFIG_MAP, String.class, Serializable.class);
    }

    @Override
    public SerializedToolkitCache<TransactionID, Decision> getOrCreateTransactionCommitStateMap(String cacheManagerName) {
        Configuration config = new ToolkitStoreConfigBuilder().consistency(ToolkitConfigFields.Consistency.SYNCHRONOUS_STRONG).build();
        ToolkitCache map = this.toolkit.getCache(cacheManagerName + DELIMITER + EHCACHE_TXNS_DECISION_STATE_MAP_NAME, config, Decision.class);
        return new SerializedToolkitCache<TransactionID, Decision>(map);
    }

    @Override
    public ToolkitLock getSoftLockWriteLock(String cacheManagerName, String cacheName, TransactionID transactionID, Object key) {
        return this.toolkit.getLock(ToolkitInstanceFactoryImpl.getFullyQualifiedCacheName(cacheManagerName, cacheName) + DELIMITER + ToolkitInstanceFactoryImpl.serializeToString(transactionID) + DELIMITER + ToolkitInstanceFactoryImpl.serializeToString(key) + DELIMITER + EHCACHE_TXNS_SOFTLOCK_WRITE_LOCK_NAME);
    }

    private static String serializeToString(Object serializable) {
        try {
            return SerializationHelper.serializeToString(serializable);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ToolkitReadWriteLock getSoftLockFreezeLock(String cacheManagerName, String cacheName, TransactionID transactionID, Object key) {
        return this.toolkit.getReadWriteLock(ToolkitInstanceFactoryImpl.getFullyQualifiedCacheName(cacheManagerName, cacheName) + DELIMITER + ToolkitInstanceFactoryImpl.serializeToString(transactionID) + DELIMITER + ToolkitInstanceFactoryImpl.serializeToString(key) + DELIMITER + EHCACHE_TXNS_SOFTLOCK_FREEZE_LOCK_NAME);
    }

    @Override
    public ToolkitReadWriteLock getSoftLockNotifierLock(String cacheManagerName, String cacheName, TransactionID transactionID, Object key) {
        return this.toolkit.getReadWriteLock(ToolkitInstanceFactoryImpl.getFullyQualifiedCacheName(cacheManagerName, cacheName) + DELIMITER + ToolkitInstanceFactoryImpl.serializeToString(transactionID) + DELIMITER + ToolkitInstanceFactoryImpl.serializeToString(key) + DELIMITER + EHCACHE_TXNS_SOFTLOCK_NOTIFIER_LOCK_NAME);
    }

    private void addNonStopConfigForCache(Ehcache cache) {
        CacheConfiguration ehcacheConfig = cache.getCacheConfiguration();
        TerracottaConfiguration terracottaConfiguration = ehcacheConfig.getTerracottaConfiguration();
        ToolkitNonStopConfiguration nonstopConfiguration = new ToolkitNonStopConfiguration(terracottaConfiguration.getNonstopConfiguration());
        ((NonStopFeature)this.toolkit.getFeature(ToolkitFeatureType.NONSTOP)).getNonStopConfigurationRegistry().registerForInstance((NonStopConfiguration)nonstopConfiguration, this.getFullyQualifiedCacheName(cache), ToolkitObjectType.CACHE);
    }

    @Override
    public void removeNonStopConfigforCache(Ehcache cache) {
        ((NonStopFeature)this.toolkit.getFeature(ToolkitFeatureType.NONSTOP)).getNonStopConfigurationRegistry().deregisterForInstance(this.getFullyQualifiedCacheName(cache), ToolkitObjectType.CACHE);
    }

    private static class EhcacheTcConfig {
        private final Type type;
        private final String tcConfigUrlOrSnippet;

        private EhcacheTcConfig(Type type, String config) {
            this.type = type;
            this.tcConfigUrlOrSnippet = config;
        }

        public static EhcacheTcConfig create(TerracottaClientConfiguration config) {
            if (config.isUrlConfig()) {
                String urlOrFilePath = config.getUrl();
                if (EhcacheTcConfig.isFile(urlOrFilePath)) {
                    return new EhcacheTcConfig(Type.FILE, EhcacheTcConfig.slurpFile(urlOrFilePath));
                }
                return new EhcacheTcConfig(Type.URL, urlOrFilePath);
            }
            return new EhcacheTcConfig(Type.EMBEDDED_TC_CONFIG, config.getEmbeddedConfig());
        }

        private static String slurpFile(String urlOrFilePath) {
            try {
                StringBuilder builder = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(urlOrFilePath)));
                String line = null;
                while ((line = br.readLine()) != null) {
                    builder.append(line);
                }
                return builder.toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private static boolean isFile(String urlOrFilePath) {
            File file = new File(urlOrFilePath);
            return file.exists() && file.isFile();
        }

        private static enum Type {
            URL,
            EMBEDDED_TC_CONFIG,
            FILE;

        }
    }
}

