/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import net.sf.ehcache.CacheOperationOutcomes;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.search.impl.SearchManager;
import net.sf.ehcache.store.CopyingCacheStore;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.Store;

public final class NotifyingMemoryStore
extends MemoryStore {
    private final Ehcache cache;

    private NotifyingMemoryStore(Ehcache cache, Pool pool, SearchManager searchManager) {
        super(cache, pool, true, new MemoryStore.BasicBackingFactory(), searchManager);
        this.cache = cache;
    }

    public static Store createNotifyingStore(Ehcache cache, Pool pool) {
        Store store;
        MemoryStore.BruteForceSearchManager searchManager = new MemoryStore.BruteForceSearchManager();
        NotifyingMemoryStore memoryStore = new NotifyingMemoryStore(cache, pool, searchManager);
        cache.getCacheConfiguration().addConfigurationListener(memoryStore);
        if (CopyingCacheStore.requiresCopy(cache.getCacheConfiguration())) {
            CopyingCacheStore<NotifyingMemoryStore> copyingCacheStore = CopyingCacheStore.wrap(memoryStore, cache.getCacheConfiguration());
            searchManager.setMemoryStore(copyingCacheStore);
            store = copyingCacheStore;
        } else {
            searchManager.setMemoryStore(memoryStore);
            store = memoryStore;
        }
        return store;
    }

    @Override
    protected boolean evict(Element element) {
        this.evictionObserver.begin();
        Element remove = this.remove(element.getObjectKey());
        if (remove != null) {
            this.evictionObserver.end(CacheOperationOutcomes.EvictionOutcome.SUCCESS);
            this.cache.getCacheEventNotificationService().notifyElementEvicted(element, false);
        }
        return remove != null;
    }

    @Override
    protected void notifyDirectEviction(Element element) {
        this.evictionObserver.begin();
        this.evictionObserver.end(CacheOperationOutcomes.EvictionOutcome.SUCCESS);
        this.cache.getCacheEventNotificationService().notifyElementEvicted(element, false);
    }

    @Override
    public void expireElements() {
        for (Object key : this.keySet()) {
            Element element = this.expireElement(key);
            if (element == null) continue;
            this.cache.getCacheEventNotificationService().notifyElementExpiry(element, false);
        }
    }
}

