/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.pool.Pool;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.CacheStore;
import net.sf.ehcache.store.CopyingCacheStore;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.cachingtier.OnHeapCachingTier;
import net.sf.ehcache.store.disk.DiskStore;

public abstract class DiskBackedMemoryStore
extends AbstractStore {
    public static Store create(Ehcache cache, Pool onHeapPool, Pool onDiskPool) {
        DiskStore diskStore = DiskBackedMemoryStore.createDiskStore(cache, onHeapPool, onDiskPool);
        OnHeapCachingTier<Object, Element> onHeapCache = OnHeapCachingTier.createOnHeapCache(cache, onHeapPool);
        return CopyingCacheStore.wrapIfCopy(new CacheStore(onHeapCache, diskStore, cache.getCacheConfiguration()), cache.getCacheConfiguration());
    }

    private static DiskStore createDiskStore(Ehcache cache, Pool onHeapPool, Pool onDiskPool) {
        CacheConfiguration config = cache.getCacheConfiguration();
        if (config.isOverflowToDisk()) {
            return DiskStore.create(cache, onHeapPool, onDiskPool);
        }
        throw new CacheException("DiskBackedMemoryStore can only be used for cache overflowing to disk");
    }

    @Override
    public Object getMBean() {
        return null;
    }
}

