/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.statistics.extended;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import net.sf.ehcache.statistics.extended.ExtendedStatistics;
import net.sf.ehcache.statistics.extended.SampledStatistic;
import org.terracotta.statistics.Time;
import org.terracotta.statistics.ValueStatistic;
import org.terracotta.statistics.archive.Timestamped;

abstract class AbstractStatistic<T extends Number>
implements ExtendedStatistics.Statistic<T> {
    private final SampledStatistic<T> history;
    private boolean active = false;
    private long touchTimestamp = -1L;

    public AbstractStatistic(ScheduledExecutorService executor, int historySize, long historyNanos) {
        this.history = new SampledStatistic(new ValueStatistic<T>(){

            @Override
            public T value() {
                return AbstractStatistic.this.readStatistic();
            }
        }, executor, historySize, historyNanos);
    }

    @Override
    public final synchronized boolean active() {
        return this.active;
    }

    @Override
    public T value() {
        this.touch();
        return this.readStatistic();
    }

    @Override
    public final List<Timestamped<T>> history() {
        this.touch();
        return this.history.history();
    }

    private final synchronized void touch() {
        this.touchTimestamp = Time.absoluteTime();
        this.start();
    }

    final synchronized void start() {
        if (!this.active) {
            this.startStatistic();
            this.history.startSampling();
            this.active = true;
        }
    }

    final synchronized boolean expire(long expiry) {
        if (this.touchTimestamp < expiry) {
            if (this.active) {
                this.history.stopSampling();
                this.stopStatistic();
                this.active = false;
            }
            return true;
        }
        return false;
    }

    final void setHistory(int historySize, long historyNanos) {
        this.history.adjust(historySize, historyNanos);
    }

    abstract void stopStatistic();

    abstract void startStatistic();

    abstract T readStatistic();
}

