/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.sf.ehcache.Element;
import net.sf.ehcache.util.TimeUtil;
import org.terracotta.toolkit.internal.cache.TimestampedValue;

public class ElementData
implements Externalizable,
TimestampedValue {
    private volatile Object value;
    private volatile long version;
    private volatile long creationTime;
    private volatile long lastAccessTime;
    private volatile long hitCount;
    private volatile boolean cacheDefaultLifespan;
    private volatile int timeToLive;
    private volatile int timeToIdle;
    private volatile long lastUpdateTime;

    public ElementData() {
    }

    public ElementData(Object value, long version, long creationTime, long lastAccessTime, long hitCount, boolean cacheDefaultLifespan, int timeToLive, int timeToIdle, long lastUpdateTime) {
        this.value = value;
        this.version = version;
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
        this.hitCount = hitCount;
        this.cacheDefaultLifespan = cacheDefaultLifespan;
        this.timeToLive = timeToLive;
        this.timeToIdle = timeToIdle;
        this.lastUpdateTime = lastUpdateTime;
    }

    public ElementData(Element element) {
        this(element.getValue(), element.getVersion(), element.getCreationTime(), element.getLastAccessTime(), element.getHitCount(), element.usesCacheDefaultLifespan(), element.getTimeToLive(), element.getTimeToIdle(), element.getLastUpdateTime());
    }

    public Element createElement(Object key) {
        return new Element(key, this.value, this.version, this.creationTime, this.lastAccessTime, this.hitCount, this.cacheDefaultLifespan, this.timeToLive, this.timeToIdle, this.lastUpdateTime);
    }

    public Object getValue() {
        return this.value;
    }

    public int getLastAccessedTime() {
        return TimeUtil.toSecs(this.lastAccessTime);
    }

    protected void setLastAccessedTimeInternal(int usedAtTime) {
        this.lastAccessTime = TimeUtil.toMillis(usedAtTime);
    }

    public int getCreateTime() {
        return TimeUtil.toSecs(this.creationTime);
    }

    @Override
    public void writeExternal(ObjectOutput oos) throws IOException {
        oos.writeObject(this.value);
        oos.writeLong(this.version);
        oos.writeLong(this.creationTime);
        oos.writeLong(this.lastAccessTime);
        oos.writeLong(this.hitCount);
        oos.writeBoolean(this.cacheDefaultLifespan);
        oos.writeInt(this.timeToLive);
        oos.writeInt(this.timeToIdle);
        oos.writeLong(this.lastUpdateTime);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = in.readObject();
        this.version = in.readLong();
        this.creationTime = in.readLong();
        this.lastAccessTime = in.readLong();
        this.hitCount = in.readLong();
        this.cacheDefaultLifespan = in.readBoolean();
        this.timeToLive = in.readInt();
        this.timeToIdle = in.readInt();
        this.lastUpdateTime = in.readLong();
    }

    public void updateTimestamps(int createTime, int lastAccessedTime) {
        this.setLastAccessedTimeInternal(lastAccessedTime);
    }
}

