/*
 * Decompiled with CFR 0.152.
 */
package net.bingosoft.oss.ssoclient.spi;

import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import net.bingosoft.oss.ssoclient.SSOConfig;
import net.bingosoft.oss.ssoclient.SSOUtils;
import net.bingosoft.oss.ssoclient.exception.HttpException;
import net.bingosoft.oss.ssoclient.exception.InvalidCodeException;
import net.bingosoft.oss.ssoclient.exception.InvalidTokenException;
import net.bingosoft.oss.ssoclient.exception.TokenExpiredException;
import net.bingosoft.oss.ssoclient.internal.Base64;
import net.bingosoft.oss.ssoclient.internal.HttpClient;
import net.bingosoft.oss.ssoclient.internal.JSON;
import net.bingosoft.oss.ssoclient.internal.JWT;
import net.bingosoft.oss.ssoclient.internal.Strings;
import net.bingosoft.oss.ssoclient.model.AccessToken;
import net.bingosoft.oss.ssoclient.model.Authentication;
import net.bingosoft.oss.ssoclient.spi.TokenProvider;

public class TokenProviderImpl
implements TokenProvider {
    private final SSOConfig config;
    private RSAPublicKey publicKey;

    public TokenProviderImpl(SSOConfig config) {
        this.config = config;
        this.refreshPublicKey();
    }

    @Override
    public Authentication verifyJwtAccessToken(String accessToken) throws InvalidTokenException {
        Map<String, Object> map = JWT.verify(accessToken, this.publicKey);
        if (null == map && null == (map = this.retryVerify(accessToken))) {
            throw new InvalidTokenException("Incorrect token : " + accessToken);
        }
        Authentication authentication = this.createAuthcFromMap(map);
        if (authentication.isExpired()) {
            throw new TokenExpiredException(accessToken);
        }
        return authentication;
    }

    @Override
    public Authentication verifyIdToken(String idToken) throws InvalidTokenException, TokenExpiredException {
        Map<String, Object> map = JWT.verify(idToken, this.config.getClientSecret());
        if (null == map) {
            throw new InvalidTokenException("Incorrect token : " + idToken);
        }
        Authentication authentication = this.createAuthcFromIdTokenMap(map);
        if (authentication.isExpired()) {
            throw new TokenExpiredException(idToken);
        }
        return authentication;
    }

    @Override
    public Authentication verifyBearerAccessToken(String accessToken) throws InvalidTokenException, TokenExpiredException {
        if (Strings.isEmpty(this.config.getResourceName())) {
            throw new IllegalStateException("resource name must not be null or empty");
        }
        String tokeninfoUrl = this.config.getTokenInfoEndpointUrl();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        params.put("resource", this.config.getResourceName());
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", SSOUtils.encodeBasicAuthorizationHeader(this.config.getClientId(), this.config.getClientSecret()));
        String json = null;
        try {
            json = HttpClient.post(tokeninfoUrl, params, header);
        }
        catch (HttpException e) {
            if (e.getMessage().contains("invalid_token")) {
                throw new InvalidTokenException("error in obtain access token:[http code:" + e.getCode() + "] " + e.getMessage(), e);
            }
            throw e;
        }
        Map<String, Object> tokenInfoMap = JSON.decodeToMap(json);
        if (tokenInfoMap.containsKey("error")) {
            throw new InvalidTokenException(tokenInfoMap.get("error") + ":" + tokenInfoMap.get("error_description"));
        }
        Authentication authc = new Authentication();
        authc.setUserId((String)tokenInfoMap.remove("user_id"));
        authc.setClientId((String)tokenInfoMap.remove("client_id"));
        authc.setUsername((String)tokenInfoMap.remove("username"));
        String scope = (String)tokenInfoMap.remove("scope");
        authc.setScope(scope);
        String expiresIn = Strings.nullOrToString(tokenInfoMap.remove("expires_in"));
        if (null == expiresIn) {
            expiresIn = "0";
        }
        authc.setExpires(System.currentTimeMillis() / 1000L + (long)Integer.parseInt(expiresIn));
        if (authc.isExpired()) {
            throw new TokenExpiredException("token is expired:" + accessToken);
        }
        return authc;
    }

    @Override
    public AccessToken obtainAccessTokenByAuthzCode(String authzCode) throws InvalidCodeException, TokenExpiredException {
        Map<String, Object> map;
        String json;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "authorization_code");
        params.put("code", authzCode);
        params.put("redirect_uri", Base64.urlEncode(this.config.getRedirectUri()));
        try {
            json = HttpClient.post(this.config.getTokenEndpointUrl(), params, this.createAuthorizationHeader());
        }
        catch (HttpException e) {
            if (e.getMessage().contains("invalid_grant")) {
                throw new InvalidCodeException("error in obtain access token:[http code:" + e.getCode() + "] " + e.getMessage(), e);
            }
            throw e;
        }
        try {
            map = JSON.decodeToMap(json);
        }
        catch (Exception e) {
            throw new RuntimeException("parse json error", e);
        }
        AccessToken token = this.createAccessTokenFromMap(map);
        if (null == token.getAccessToken() || token.getAccessToken().isEmpty()) {
            throw new InvalidCodeException("invalid authorization code[" + authzCode + "]:" + map.get("error") + "\n" + map.get("error_description"));
        }
        if (token.isExpired()) {
            throw new TokenExpiredException("access token obtain by authorization code " + authzCode + " is expired!");
        }
        return token;
    }

    @Override
    public AccessToken obtainAccessTokenByClientCredentials() {
        Map<String, Object> map;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "client_credentials");
        String json = HttpClient.post(this.config.getTokenEndpointUrl(), params, this.createAuthorizationHeader());
        try {
            map = JSON.decodeToMap(json);
        }
        catch (Exception e) {
            throw new RuntimeException("parse json error", e);
        }
        AccessToken token = this.createAccessTokenFromMap(map);
        if (null == token.getAccessToken() || token.getAccessToken().isEmpty()) {
            throw new RuntimeException(map.get("error") + ":" + map.get("error_description"));
        }
        if (token.isExpired()) {
            throw new TokenExpiredException("access token obtain by client secret is expired!");
        }
        return token;
    }

    @Override
    public AccessToken obtainAccessTokenByClientCredentialsWithJwtToken(String accessToken) throws InvalidTokenException, TokenExpiredException {
        this.verifyJwtAccessToken(accessToken);
        return this.obtainAccessTokenByTokenClientCredentials(accessToken);
    }

    @Override
    public AccessToken obtainAccessTokenByClientCredentialsWithBearerToken(String accessToken) throws InvalidTokenException, TokenExpiredException {
        return this.obtainAccessTokenByTokenClientCredentials(accessToken);
    }

    protected AccessToken obtainAccessTokenByTokenClientCredentials(String accessToken) throws TokenExpiredException {
        Map<String, Object> map;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "token_client_credentials");
        params.put("access_token", accessToken);
        String json = HttpClient.post(this.config.getTokenEndpointUrl(), params, this.createAuthorizationHeader());
        try {
            map = JSON.decodeToMap(json);
        }
        catch (Exception e) {
            throw new RuntimeException("parse json error", e);
        }
        if (map.containsKey("error")) {
            throw new InvalidTokenException("invalid token:" + map.get("error_description"));
        }
        AccessToken token = this.createAccessTokenFromMap(map);
        if (token.isExpired()) {
            throw new TokenExpiredException("access token obtain by token p client credentials is expired!");
        }
        return token;
    }

    @Override
    public AccessToken refreshAccessToken(AccessToken accessToken) throws InvalidTokenException, TokenExpiredException {
        Map<String, Object> map;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "refresh_token");
        params.put("refresh_token", accessToken.getRefreshToken());
        String json = null;
        try {
            json = HttpClient.post(this.config.getTokenEndpointUrl(), params, this.createAuthorizationHeader());
        }
        catch (HttpException e) {
            String msg = e.getMessage();
            throw new InvalidTokenException(msg, e);
        }
        try {
            map = JSON.decodeToMap(json);
        }
        catch (Exception e) {
            throw new RuntimeException("parse json error", e);
        }
        if (map.containsKey("error")) {
            throw new InvalidTokenException("invalid token:" + map.get("error_description"));
        }
        AccessToken token = this.createAccessTokenFromMap(map);
        if (token.isExpired()) {
            throw new TokenExpiredException("refresh token is expired!");
        }
        return token;
    }

    protected Map<String, Object> retryVerify(String accessToken) {
        this.refreshPublicKey();
        return JWT.verify(accessToken, this.publicKey);
    }

    protected void refreshPublicKey() {
        String publicKeyBase64 = HttpClient.get(this.config.getPublicKeyEndpointUrl());
        this.publicKey = TokenProviderImpl.decodePublicKey(publicKeyBase64);
    }

    private static RSAPublicKey decodePublicKey(String base64) {
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(Base64.mimeDecode(base64));
            KeyFactory f = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)f.generatePublic(spec);
        }
        catch (Exception e) {
            throw new RuntimeException("Decode public key error", e);
        }
    }

    protected Authentication createAuthcFromMap(Map<String, Object> map) {
        Authentication authentication = new Authentication();
        authentication.setUserId((String)map.remove("user_id"));
        authentication.setUsername((String)map.remove("username"));
        authentication.setClientId((String)map.remove("client_id"));
        String scope = (String)map.remove("scope");
        authentication.setScope(scope);
        String expires = Strings.nullOrToString(map.remove("exp"));
        authentication.setExpires(expires == null ? 0L : Long.parseLong(expires));
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            authentication.setAttribute(entry.getKey(), entry.getValue());
        }
        return authentication;
    }

    protected Authentication createAuthcFromIdTokenMap(Map<String, Object> map) {
        Authentication authentication = new Authentication();
        authentication.setUserId((String)map.remove("sub"));
        authentication.setUsername((String)map.remove("login_name"));
        authentication.setClientId((String)map.remove("aud"));
        String scope = (String)map.remove("scope");
        authentication.setScope(scope);
        String expires = Strings.nullOrToString(map.remove("exp"));
        authentication.setExpires(expires == null ? 0L : Long.parseLong(expires));
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            authentication.setAttribute(entry.getKey(), entry.getValue());
        }
        return authentication;
    }

    protected AccessToken createAccessTokenFromMap(Map<String, Object> map) {
        AccessToken token = new AccessToken();
        token.setAccessToken((String)map.remove("access_token"));
        token.setRefreshToken((String)map.remove("refresh_token"));
        token.setTokenType((String)map.remove("token_type"));
        String expiresIn = Strings.nullOrToString(map.remove("expires_in"));
        token.setExpiresInFromNow(expiresIn == null ? 0 : Integer.parseInt(expiresIn));
        return token;
    }

    protected Map<String, String> createAuthorizationHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        String h = SSOUtils.encodeBasicAuthorizationHeader(this.config.getClientId(), this.config.getClientSecret());
        header.put("Authorization", h);
        return header;
    }
}

