/*
 * Decompiled with CFR 0.152.
 */
package net.bingosoft.oss.ssoclient.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bingosoft.oss.ssoclient.SSOClient;
import net.bingosoft.oss.ssoclient.internal.Strings;
import net.bingosoft.oss.ssoclient.internal.Urls;

public abstract class AbstractLogoutServlet
extends HttpServlet {
    protected static final String POST_LOGOUT_REDIRECT_URI_PARAM = "post_logout_redirect_uri";
    private SSOClient client;

    public void init(ServletConfig config) throws ServletException {
        this.client = this.getClient(config);
        super.init(config);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isLocalLogoutRequest(req, resp)) {
            this.localLogout(req, resp);
        } else {
            this.redirectToSSOLogout(req, resp);
        }
    }

    protected boolean isLocalLogoutRequest(HttpServletRequest req, HttpServletResponse resp) {
        return !req.getRequestURI().endsWith("/oauth2_logout");
    }

    protected void redirectToSSOLogout(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String ssoLogoutUrl = this.buildSSOLogoutUrl(req, resp);
        resp.sendRedirect(ssoLogoutUrl);
    }

    protected String buildSSOLogoutUrl(HttpServletRequest req, HttpServletResponse resp) {
        String logoutUrl = this.client.getConfig().getOauthLogoutEndpoint();
        String returnUrl = req.getParameter(POST_LOGOUT_REDIRECT_URI_PARAM);
        if (Strings.isEmpty(returnUrl)) {
            returnUrl = Urls.getServerContextUrl(req);
            returnUrl = returnUrl + this.getContextPathOfReverseProxy(req);
            String state = this.getStateQueryParam(req, resp);
            if (!Strings.isEmpty(state)) {
                returnUrl = Urls.appendQueryString(returnUrl, "__state__", state);
            }
        }
        logoutUrl = Urls.appendQueryString(logoutUrl, POST_LOGOUT_REDIRECT_URI_PARAM, returnUrl);
        return logoutUrl;
    }

    protected String getContextPathOfReverseProxy(HttpServletRequest req) {
        return req.getContextPath();
    }

    protected String getStateQueryParam(HttpServletRequest req, HttpServletResponse resp) {
        return String.valueOf(System.currentTimeMillis());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected abstract SSOClient getClient(ServletConfig var1) throws ServletException;

    protected abstract void localLogout(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;
}

