/*
 * Decompiled with CFR 0.152.
 */
package net.bingosoft.oss.ssoclient.servlet;

import java.io.IOException;
import java.util.UUID;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bingosoft.oss.ssoclient.SSOClient;
import net.bingosoft.oss.ssoclient.internal.Strings;
import net.bingosoft.oss.ssoclient.internal.Urls;
import net.bingosoft.oss.ssoclient.model.AccessToken;
import net.bingosoft.oss.ssoclient.model.Authentication;

public abstract class AbstractLoginServlet
extends HttpServlet {
    protected static final String ID_TOKEN_PARAM = "id_token";
    protected static final String AUTHZ_CODE_PARAM = "code";
    private SSOClient client;

    public void init(ServletConfig config) throws ServletException {
        this.client = this.getClient(config);
        super.init(config);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isRedirectedFromSSO(req)) {
            this.gotoLocalLogin(req, resp);
        } else {
            this.redirectToSSOLogin(req, resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    protected void redirectToSSOLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String redirectUri = this.buildRedirectUri(req, resp);
        String loginUrl = this.buildLoginUrl(req, resp, redirectUri);
        resp.sendRedirect(loginUrl);
    }

    protected void gotoLocalLogin(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (this.checkOauth2LoginState(req, resp)) {
            String idToken = req.getParameter(ID_TOKEN_PARAM);
            String code = req.getParameter(AUTHZ_CODE_PARAM);
            Authentication authc = this.client.verifyIdToken(idToken);
            AccessToken token = this.client.obtainAccessTokenByCode(code);
            this.localLogin(req, resp, authc, token);
            String returnUrl = req.getParameter("return_url");
            if (Strings.isEmpty(returnUrl) && (returnUrl = Urls.getServerBaseUrl(req) + this.getContextPathOfReverseProxy(req)).endsWith("//")) {
                returnUrl.substring(0, returnUrl.length() - 1);
            }
            resp.sendRedirect(returnUrl);
        } else {
            resp.sendError(400, "state has been change!");
        }
    }

    protected boolean checkOauth2LoginState(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String state = req.getParameter("state");
        String sessionState = (String)req.getSession().getAttribute("oauth2_login_state");
        return Strings.equals(sessionState, state);
    }

    protected String setOauth2LoginState(HttpServletRequest req, HttpServletResponse resp, String authzEndpoint) {
        String state = UUID.randomUUID().toString().replace("-", "");
        req.getSession().setAttribute("oauth2_login_state", (Object)state);
        authzEndpoint = Urls.appendQueryString(authzEndpoint, "state", state);
        return authzEndpoint;
    }

    protected String buildLoginUrl(HttpServletRequest req, HttpServletResponse resp, String redirectUri) {
        String authzEndpoint = this.client.getConfig().getAuthorizationEndpointUrl();
        authzEndpoint = Urls.appendQueryString(authzEndpoint, "response_type", "code id_token");
        authzEndpoint = Urls.appendQueryString(authzEndpoint, "client_id", this.client.getConfig().getClientId());
        authzEndpoint = Urls.appendQueryString(authzEndpoint, "redirect_uri", redirectUri);
        if (!Strings.isEmpty(this.client.getConfig().getLogoutUri())) {
            authzEndpoint = Urls.appendQueryString(authzEndpoint, "logout_uri", this.client.getConfig().getLogoutUri());
        }
        if (!Strings.isEmpty(req.getParameter("login_token"))) {
            authzEndpoint = Urls.appendQueryString(authzEndpoint, "login_token", req.getParameter("login_token"));
        }
        authzEndpoint = this.setOauth2LoginState(req, resp, authzEndpoint);
        return authzEndpoint;
    }

    protected String buildRedirectUri(HttpServletRequest req, HttpServletResponse resp) {
        String baseUrl = Urls.getServerBaseUrl(req);
        String requestUri = this.parseRequestUriWithoutContextPath(req);
        String current = baseUrl + this.getContextPathOfReverseProxy(req) + requestUri;
        String queryString = req.getQueryString();
        if (Strings.isEmpty(queryString)) {
            if (this.client.getConfig().getDefaultReturnUrl() != null && !this.client.getConfig().getDefaultReturnUrl().isEmpty()) {
                current = Urls.appendQueryString(current, "return_url", this.client.getConfig().getDefaultReturnUrl());
            }
            return current;
        }
        if (!Urls.parseQueryString(current = current + "?" + queryString).containsKey("return_url") && this.client.getConfig().getDefaultReturnUrl() != null && !this.client.getConfig().getDefaultReturnUrl().isEmpty()) {
            current = Urls.appendQueryString(current, "return_url", this.client.getConfig().getDefaultReturnUrl());
        }
        return current;
    }

    protected String parseRequestUriWithoutContextPath(HttpServletRequest req) {
        String requestUri = req.getRequestURI();
        String contextPath = req.getContextPath();
        if ((requestUri = requestUri.substring(contextPath.length())).startsWith("/")) {
            return requestUri;
        }
        return "/" + requestUri;
    }

    protected String getContextPathOfReverseProxy(HttpServletRequest req) {
        return req.getContextPath();
    }

    protected boolean isRedirectedFromSSO(HttpServletRequest req) {
        String idToken = req.getParameter(ID_TOKEN_PARAM);
        String accessToken = req.getParameter(AUTHZ_CODE_PARAM);
        return !Strings.isEmpty(idToken) && !Strings.isEmpty(accessToken);
    }

    protected abstract SSOClient getClient(ServletConfig var1) throws ServletException;

    protected abstract void localLogin(HttpServletRequest var1, HttpServletResponse var2, Authentication var3, AccessToken var4) throws ServletException, IOException;
}

