/*
 * Decompiled with CFR 0.152.
 */
package net.bingosoft.oss.ssoclient.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class Urls {
    public static String appendQueryString(String url, String name, String value) {
        String append = name + "=" + Urls.encode(value);
        if (url.indexOf("?") < 0) {
            return url + "?" + append;
        }
        return url + "&" + append;
    }

    public static String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> parseQueryString(String url) {
        String[] kvs;
        HashMap<String, String> map = new HashMap<String, String>();
        if (null == url) {
            return map;
        }
        if (url.indexOf("?") < 0) {
            return map;
        }
        String queryString = url.substring(url.indexOf("?") + 1);
        if (queryString.isEmpty()) {
            return map;
        }
        for (String kv : kvs = queryString.split("&")) {
            int ei = kv.indexOf("=");
            String k = kv.substring(0, ei);
            String v = kv.substring(ei + 1);
            map.put(k, v);
        }
        return map;
    }

    public static String getServerContextUrl(HttpServletRequest request) {
        String url = Urls.getServerBaseUrl(request);
        if ((url = url + request.getContextPath()).endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String getServerBaseUrl(HttpServletRequest request) {
        String schema = request.getHeader("x-forwarded-proto");
        if (schema == null || "".equals(schema)) {
            schema = request.getScheme();
        }
        schema = schema + "://";
        String host = request.getHeader("x-forwarded-host");
        if (host == null || "".equals(host)) {
            host = request.getServerPort() > 0 ? request.getServerName() + ":" + request.getServerPort() : request.getServerName();
        }
        String url = schema + host;
        url = Urls.regularUrl(url);
        return url;
    }

    private static String regularUrl(String url) {
        url = (url = url + "/").startsWith("https") || url.startsWith("HTTPS") ? url.replaceFirst(":443/", "/") : url.replaceFirst(":80/", "/");
        return url.substring(0, url.length() - 1);
    }
}

