/*
 * Decompiled with CFR 0.152.
 */
package net.bingosoft.oss.ssoclient.internal;

import java.io.UnsupportedEncodingException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.bingosoft.oss.ssoclient.exception.InvalidTokenException;
import net.bingosoft.oss.ssoclient.internal.Base64;
import net.bingosoft.oss.ssoclient.internal.JSON;
import net.bingosoft.oss.ssoclient.internal.Strings;

public class JWT {
    public static final String UTF_8 = "UTF-8";
    public static final String ALG_SHA256WITHRSA = "SHA256withRSA";
    public static final String ALG_HMACSHA256 = "HMACSHA256";

    public static Map<String, Object> verify(String token, final RSAPublicKey pk) throws InvalidTokenException {
        Verifier verifier = new Verifier(){

            @Override
            public boolean verifySignature(String content, String payload, String signature) {
                return JWT.verifySignature(content, signature, pk);
            }
        };
        return JWT.verify(token, verifier);
    }

    public static Map<String, Object> verify(String token, final String secret) throws InvalidTokenException {
        Verifier verifier = new Verifier(){

            @Override
            public boolean verifySignature(String content, String payload, String signature) {
                return JWT.verifySignature(content, secret, signature);
            }
        };
        return JWT.verify(token, verifier);
    }

    private static boolean verifySignature(String content, String signed, RSAPublicKey pk) throws InvalidTokenException {
        try {
            byte[] signedData = Base64.urlDecode(signed);
            byte[] contentData = content.getBytes(UTF_8);
            Signature signature = Signature.getInstance(ALG_SHA256WITHRSA);
            signature.initVerify(pk);
            signature.update(contentData);
            return signature.verify(signedData);
        }
        catch (SignatureException e) {
            throw new InvalidTokenException("Invalid signature", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Verify signature error", e);
        }
    }

    private static boolean verifySignature(String content, String secret, String signature) throws InvalidTokenException {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(), ALG_HMACSHA256);
            Mac mac = Mac.getInstance(ALG_HMACSHA256);
            mac.init(secretKey);
            byte[] bytes = mac.doFinal(content.getBytes());
            String base64 = JWT.base64UrlEncode(bytes);
            return Strings.equals(base64, signature);
        }
        catch (Exception e) {
            throw new RuntimeException("Verify signature error", e);
        }
    }

    private static String base64UrlEncode(byte[] bytes) {
        String encoded = Base64.urlEncode(bytes);
        StringBuilder sb = new StringBuilder(encoded);
        while (sb.charAt(sb.length() - 1) == '=') {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private static Map<String, Object> verify(String token, Verifier verifier) throws InvalidTokenException {
        String signature;
        String payload;
        String[] parts = token.split("\\.");
        if (parts.length != 3) {
            throw new InvalidTokenException("Invalid jwt: length of parts expect 3 but actual " + parts.length + ", token:" + token);
        }
        String content = parts[0] + "." + parts[1];
        if (verifier.verifySignature(content, payload = parts[1], signature = parts[2])) {
            try {
                String json = new String(Base64.urlDecode(payload), UTF_8);
                return JSON.decodeToMap(json);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static interface Verifier {
        public boolean verifySignature(String var1, String var2, String var3) throws InvalidTokenException;
    }
}

