/*
 * Decompiled with CFR 0.152.
 */
package net.bingosoft.oss.ssoclient.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.bingosoft.oss.ssoclient.exception.HttpException;
import net.bingosoft.oss.ssoclient.internal.Urls;

public class HttpClient {
    public static String get(String url) throws HttpException {
        return HttpClient.get(url, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, Map<String, String> queryParams, Map<String, String> headers) throws HttpException {
        String string;
        InputStreamReader inputStreamReader;
        InputStream inputStream;
        HttpURLConnection connection;
        block17: {
            if (queryParams != null && queryParams.size() > 0) {
                for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                    url = HttpClient.appendQueryParams(url, entry.getKey(), entry.getValue());
                }
            }
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(3000);
            connection.setDoInput(true);
            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            InputStream inputStream2 = null;
            InputStreamReader inputStreamReader2 = null;
            BufferedReader reader = null;
            try {
                String line;
                int code = connection.getResponseCode();
                if (code >= 400) {
                    String line2;
                    InputStream inputStream3 = connection.getErrorStream();
                    InputStreamReader inputStreamReader3 = new InputStreamReader(inputStream3, "UTF-8");
                    reader = new BufferedReader(inputStreamReader3);
                    StringBuilder sb = new StringBuilder();
                    while ((line2 = reader.readLine()) != null) {
                        sb.append(line2);
                    }
                    throw new HttpException(code, "get request [" + url + "] error with response code [" + code + "] \nerror message: " + sb.toString());
                }
                inputStream = connection.getInputStream();
                inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
                reader = new BufferedReader(inputStreamReader);
                StringBuilder sb = new StringBuilder();
                while (null != (line = reader.readLine())) {
                    sb.append(line);
                }
                string = sb.toString();
                if (reader == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (inputStreamReader2 != null) {
                        inputStreamReader2.close();
                    }
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                    connection.disconnect();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            reader.close();
        }
        if (inputStreamReader != null) {
            inputStreamReader.close();
        }
        if (inputStream != null) {
            inputStream.close();
        }
        connection.disconnect();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> params, Map<String, String> headers) throws HttpException {
        String string;
        BufferedReader reader;
        InputStreamReader isr;
        InputStream is;
        OutputStreamWriter osw;
        OutputStream os;
        HttpURLConnection connection;
        block27: {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setConnectTimeout(3000);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            os = null;
            osw = null;
            BufferedWriter writer = null;
            is = null;
            isr = null;
            reader = null;
            try {
                String string2;
                int code;
                if (headers != null && !headers.isEmpty()) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        connection.setRequestProperty(entry.getKey(), entry.getValue());
                    }
                }
                try {
                    connection.connect();
                }
                catch (IOException e) {
                    throw new IOException(e.getMessage() + "[" + url + "]", e);
                }
                if (params != null && !params.isEmpty()) {
                    os = connection.getOutputStream();
                    osw = new OutputStreamWriter(os, "UTF-8");
                    writer = new BufferedWriter(osw);
                    StringBuilder paramsBuilder = new StringBuilder();
                    for (Map.Entry<String, String> entry : params.entrySet()) {
                        paramsBuilder.append(entry.getKey());
                        paramsBuilder.append("=");
                        paramsBuilder.append(Urls.encode(entry.getValue()));
                        paramsBuilder.append("&");
                    }
                    if (paramsBuilder.length() > 0) {
                        paramsBuilder.deleteCharAt(paramsBuilder.length() - 1);
                    }
                    if (paramsBuilder.length() > 0) {
                        writer.write(paramsBuilder.toString());
                        writer.flush();
                    }
                }
                if ((code = connection.getResponseCode()) >= 400) {
                    String string3;
                    is = connection.getErrorStream();
                    isr = new InputStreamReader(is, "UTF-8");
                    reader = new BufferedReader(isr);
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((string3 = reader.readLine()) != null) {
                        stringBuilder.append(string3);
                    }
                    throw new HttpException(code, "post request [" + url + "] error with response code [" + code + "] \nerror message: " + stringBuilder.toString());
                }
                is = connection.getInputStream();
                isr = new InputStreamReader(is, "UTF-8");
                reader = new BufferedReader(isr);
                StringBuilder stringBuilder = new StringBuilder();
                while ((string2 = reader.readLine()) != null) {
                    stringBuilder.append(string2);
                }
                string = stringBuilder.toString();
                if (writer == null) break block27;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    if (osw != null) {
                        osw.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                    connection.disconnect();
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            writer.close();
        }
        if (osw != null) {
            osw.close();
        }
        if (os != null) {
            os.close();
        }
        if (reader != null) {
            reader.close();
        }
        if (isr != null) {
            isr.close();
        }
        if (is != null) {
            is.close();
        }
        connection.disconnect();
        return string;
    }

    public static String appendQueryString(String url, String queryString) {
        if (null == url) {
            return url;
        }
        int index = url.lastIndexOf(63);
        if (index < 0) {
            return url + "?" + queryString;
        }
        if (index == url.length() - 1) {
            return url + queryString;
        }
        return url + "&" + queryString;
    }

    public static String appendQueryParams(String url, String name, String value) {
        return HttpClient.appendQueryString(url, name + "=" + HttpClient.encode(value));
    }

    public static String encode(String url) {
        if (null == url) {
            return url;
        }
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encode(String url, String charset) {
        if (null == url) {
            return url;
        }
        try {
            return URLEncoder.encode(url, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void ignoreHttpsCer() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslSession) {
                    return true;
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

