/*
 * Decompiled with CFR 0.152.
 */
package net.bingosoft.oss.ssoclient;

import javax.servlet.http.HttpServletRequest;
import net.bingosoft.oss.ssoclient.SSOClient;
import net.bingosoft.oss.ssoclient.internal.Base64;
import net.bingosoft.oss.ssoclient.internal.Strings;
import net.bingosoft.oss.ssoclient.internal.Urls;

public class SSOUtils {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String BEARER = "Bearer";
    public static final String BASIC = "Basic";
    public static final String ACCESS_TOKEN_PARAM_NAME = "access_token";
    public static final String POST_LOGOUT_REDIRECT_URI_PARAM = "post_logout_redirect_uri";

    public static String extractAccessToken(HttpServletRequest request) {
        String accessToken = request.getHeader(AUTHORIZATION_HEADER);
        if (accessToken == null || accessToken.trim().isEmpty()) {
            accessToken = request.getParameter(ACCESS_TOKEN_PARAM_NAME);
        } else if ((accessToken = accessToken.trim()).startsWith(BEARER)) {
            accessToken = accessToken.substring(BEARER.length());
            accessToken = accessToken.trim();
        }
        return accessToken;
    }

    public static String encodeBasicAuthorizationHeader(String clientId, String clientSecret) {
        return "Basic " + Base64.urlEncode(clientId + ":" + clientSecret);
    }

    public static String getSSOLogoutUrl(SSOClient client, String returnUrl) {
        String logoutUrl = client.getConfig().getOauthLogoutEndpoint();
        if (!Strings.isEmpty(returnUrl)) {
            logoutUrl = Urls.appendQueryString(logoutUrl, POST_LOGOUT_REDIRECT_URI_PARAM, returnUrl);
        }
        return logoutUrl;
    }

    private static String getContextPathOfReverseProxy(HttpServletRequest req) {
        return req.getContextPath();
    }

    protected SSOUtils() {
    }
}

