/*
 * Decompiled with CFR 0.152.
 */
package net.bingosoft.oss.ssoclient;

public class SSOConfig {
    protected String clientId;
    protected String clientSecret;
    protected String resourceName;
    protected String logoutUri;
    protected String defaultReturnUrl;
    protected String redirectUri;
    protected String publicKeyEndpointUrl;
    protected String tokenEndpointUrl;
    protected String tokenInfoEndpointUrl;
    protected String authorizationEndpointUrl;
    protected String oauthLogoutEndpoint;

    public SSOConfig() {
        this(null, null);
    }

    public SSOConfig(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public SSOConfig(String serverUrl) {
        this.autoConfigureUrls(serverUrl);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getResourceName() {
        return this.resourceName == null ? this.clientId : this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getLogoutUri() {
        return this.logoutUri;
    }

    public void setLogoutUri(String logoutUri) {
        this.logoutUri = logoutUri;
    }

    public String getDefaultReturnUrl() {
        return this.defaultReturnUrl;
    }

    public void setDefaultReturnUrl(String defaultReturnUrl) {
        this.defaultReturnUrl = defaultReturnUrl;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getPublicKeyEndpointUrl() {
        return this.publicKeyEndpointUrl;
    }

    public void setPublicKeyEndpointUrl(String publicKeyEndpointUrl) {
        this.publicKeyEndpointUrl = publicKeyEndpointUrl;
    }

    public String getTokenEndpointUrl() {
        return this.tokenEndpointUrl;
    }

    public void setTokenEndpointUrl(String tokenEndpointUrl) {
        this.tokenEndpointUrl = tokenEndpointUrl;
    }

    public String getTokenInfoEndpointUrl() {
        return this.tokenInfoEndpointUrl;
    }

    public void setTokenInfoEndpointUrl(String tokenInfoEndpointUrl) {
        this.tokenInfoEndpointUrl = tokenInfoEndpointUrl;
    }

    public String getAuthorizationEndpointUrl() {
        return this.authorizationEndpointUrl;
    }

    public void setAuthorizationEndpointUrl(String authorizationEndpointUrl) {
        this.authorizationEndpointUrl = authorizationEndpointUrl;
    }

    public String getOauthLogoutEndpoint() {
        return this.oauthLogoutEndpoint;
    }

    public void setOauthLogoutEndpoint(String oauthLogoutEndpoint) {
        this.oauthLogoutEndpoint = oauthLogoutEndpoint;
    }

    public SSOConfig autoConfigureUrls(String baseUrl) {
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        this.setPublicKeyEndpointUrl(baseUrl + "/oauth2/publickey");
        this.setTokenEndpointUrl(baseUrl + "/oauth2/token");
        this.setAuthorizationEndpointUrl(baseUrl + "/oauth2/authorize");
        this.setOauthLogoutEndpoint(baseUrl + "/oauth2/logout");
        this.setTokenInfoEndpointUrl(baseUrl + "/oauth2/tokeninfo");
        return this;
    }
}

