/*
 * Decompiled with CFR 0.152.
 */
package net.bingosoft.oss.ssoclient;

import net.bingosoft.oss.ssoclient.SSOConfig;
import net.bingosoft.oss.ssoclient.exception.InvalidCodeException;
import net.bingosoft.oss.ssoclient.exception.InvalidTokenException;
import net.bingosoft.oss.ssoclient.exception.TokenExpiredException;
import net.bingosoft.oss.ssoclient.model.AccessToken;
import net.bingosoft.oss.ssoclient.model.Authentication;
import net.bingosoft.oss.ssoclient.spi.CacheProvider;
import net.bingosoft.oss.ssoclient.spi.CacheProviderImpl;
import net.bingosoft.oss.ssoclient.spi.TokenProvider;
import net.bingosoft.oss.ssoclient.spi.TokenProviderImpl;

public class SSOClient {
    protected SSOConfig config;
    protected CacheProvider cacheProvider;
    protected TokenProvider tokenProvider;

    public SSOClient() {
    }

    public SSOClient(SSOConfig config) {
        this.config = config;
    }

    public Authentication verifyAccessToken(String accessToken) throws InvalidTokenException, TokenExpiredException {
        boolean jwt;
        CacheProvider cp = this.cp();
        Authentication authc = (Authentication)cp.get(accessToken);
        if (null != authc) {
            if (!authc.isExpired()) {
                return authc;
            }
            cp.remove(accessToken);
        }
        authc = (jwt = this.checkJwtToken(accessToken)) ? this.tp().verifyJwtAccessToken(accessToken) : this.tp().verifyBearerAccessToken(accessToken);
        cp.put(accessToken, authc, authc.getExpires());
        return authc;
    }

    public Authentication verifyIdToken(String idToken) throws InvalidTokenException, TokenExpiredException {
        boolean jwt;
        CacheProvider cp = this.cp();
        Authentication authc = (Authentication)cp.get(idToken);
        if (null != authc) {
            if (!authc.isExpired()) {
                return authc;
            }
            cp.remove(idToken);
        }
        if (!(jwt = this.checkJwtToken(idToken))) {
            throw new InvalidTokenException("idToken is not and jwt token:" + idToken);
        }
        authc = this.tp().verifyIdToken(idToken);
        cp.put(idToken, authc, authc.getExpires());
        return authc;
    }

    public AccessToken obtainAccessTokenByCode(String authorizationCode) throws InvalidCodeException, TokenExpiredException {
        AccessToken token = this.tp().obtainAccessTokenByAuthzCode(authorizationCode);
        return token;
    }

    public AccessToken obtainAccessTokenByClientCredentials() throws TokenExpiredException {
        String key = "obtainAccessTokenByClientCredentials:" + this.config.getClientId();
        AccessToken accessToken = this.getAccessTokenFromCache(key);
        if (accessToken != null) {
            return accessToken;
        }
        accessToken = this.tp().obtainAccessTokenByClientCredentials();
        this.cp().put(key, accessToken, accessToken.getExpires());
        return accessToken;
    }

    public AccessToken obtainAccessTokenByToken(String accessToken) throws InvalidTokenException, TokenExpiredException {
        String key = "obtainAccessTokenByToken:" + accessToken;
        AccessToken token = this.getAccessTokenFromCache(key);
        if (token != null) {
            return token;
        }
        boolean isJwt = this.checkJwtToken(accessToken);
        token = isJwt ? this.tp().obtainAccessTokenByClientCredentialsWithJwtToken(accessToken) : this.tp().obtainAccessTokenByClientCredentialsWithBearerToken(accessToken);
        this.cp().put(key, token, token.getExpires());
        return token;
    }

    public AccessToken refreshAccessToken(AccessToken accessToken) throws InvalidTokenException, TokenExpiredException {
        return this.tp().refreshAccessToken(accessToken);
    }

    protected AccessToken getAccessTokenFromCache(String key) {
        CacheProvider cp = this.cp();
        AccessToken token = (AccessToken)cp.get(key);
        if (token != null) {
            if (!token.isExpired()) {
                return token;
            }
            cp.remove(key);
        }
        return null;
    }

    protected boolean checkJwtToken(String accessToken) {
        return accessToken.contains(".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final CacheProvider cp() {
        if (null == this.cacheProvider) {
            SSOClient sSOClient = this;
            synchronized (sSOClient) {
                if (null == this.cacheProvider) {
                    this.cacheProvider = new CacheProviderImpl();
                }
            }
        }
        return this.cacheProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final TokenProvider tp() {
        if (null == this.tokenProvider) {
            SSOClient sSOClient = this;
            synchronized (sSOClient) {
                if (null == this.tokenProvider) {
                    this.tokenProvider = new TokenProviderImpl(this.getConfig());
                }
            }
        }
        return this.tokenProvider;
    }

    public SSOConfig getConfig() {
        return this.config;
    }

    public void setConfig(SSOConfig config) {
        this.config = config;
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public void setCacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public void setTokenProvider(TokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }
}

