/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.hunter.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.zhyd.hunter.config.platform.InnerPlatform;
import me.zhyd.hunter.config.platform.Platform;
import me.zhyd.hunter.exception.HunterException;

public class PlatformUtil {
    public static String getHost(String url) {
        String res = PlatformUtil.getDomain(url);
        if (null == res) {
            return null;
        }
        return res.replace("https://", "").replace("http://", "");
    }

    public static InnerPlatform getPlarform(String url) {
        Platform platform = Platform.getPlatformByUrl(url);
        if (null == platform) {
            throw new HunterException("\u6682\u65f6\u4e0d\u652f\u6301\u8be5\u5e73\u53f0\uff1a" + url);
        }
        return PlatformUtil.getPlarform(platform);
    }

    public static InnerPlatform getPlarform(Platform platform) {
        if (null == platform) {
            throw new HunterException("\u65e0\u6548\u7684\u535a\u5ba2\u5e73\u53f0");
        }
        Class clazz = platform.getClazz();
        try {
            return (InnerPlatform)clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new HunterException(String.format("\u65e0\u6cd5\u83b7\u53d6InnerPlatform\u5b9e\u4f8b\uff0curl: %s", platform.getHost()), e);
        }
    }

    public static String getDomain(String url) {
        String regex = "(http|https)://(www.)?([\\w-_]+(\\.)?)+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(url);
        return matcher.find() ? matcher.group() : null;
    }
}

